/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.api;

import AppliedIntegrations.api.IEnergyInterface;
import AppliedIntegrations.api.IInterfaceStorageDuality;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import appeng.api.config.Actionable;
import appeng.api.util.AEPartLocation;
import ic2.api.energy.prefab.BasicSinkSource;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import net.minecraft.util.EnumFacing;

public class InterfaceSinkSource
extends BasicSinkSource
implements IInterfaceStorageDuality<Double> {
    private final IEnergyInterface owner;
    private final AEPartLocation side;

    public InterfaceSinkSource(IEnergyInterface owner, AEPartLocation side, double capacity, int sinkTier, int sourceTier) {
        super(owner.getHostWorld(), owner.getHostPos(), capacity, sinkTier, sourceTier);
        this.owner = owner;
        this.side = side;
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        return true;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
        return true;
    }

    @Override
    public void modifyEnergyStored(int i) {
        this.owner.setLastInjectedEnergy(this.side, AIEnergy.EU);
        this.energyStored = this.energyStored + (double)i < this.getMaxStored() ? (double)i : this.getMaxStored();
    }

    @Override
    public Class<Double> getTypeClass() {
        return Double.class;
    }

    @Override
    public Double getStored() {
        return this.getEnergyStored();
    }

    @Override
    public Double getMaxStored() {
        return this.getCapacity();
    }

    @Override
    public Double receive(Double value, Actionable action) {
        this.owner.setLastInjectedEnergy(this.side, AIEnergy.EU);
        double storedBefore = this.getEnergyStored();
        double injectedAmount = this.injectEnergy(null, value, 4.0);
        if (action == Actionable.SIMULATE) {
            this.setEnergyStored(storedBefore);
        }
        return injectedAmount;
    }

    @Override
    public Double extract(Double value, Actionable action) {
        double storedBefore = this.getEnergyStored();
        this.drawEnergy(value);
        double storedAfter = this.getEnergyStored();
        if (action == Actionable.SIMULATE) {
            this.setEnergyStored(storedBefore);
        }
        return storedBefore - storedAfter;
    }

    @Override
    public Double toNativeValue(Number val) {
        return val.doubleValue();
    }
}

