/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Topology;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.Topology.GraphToolMode;
import AppliedIntegrations.Topology.SubnetHelper;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyGridProvider;
import appeng.api.util.AEPartLocation;
import appeng.me.cache.EnergyGridCache;
import appeng.me.cache.P2PCache;
import appeng.parts.p2p.PartP2PTunnel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;

public class TopologyUtils {
    private static JSONObject innerObject = new JSONObject();

    public static void createWebUI(IGrid grid, EntityPlayer player, GraphToolMode mode, IGridHost machine) {
        switch (mode) {
            case ALL: {
                TopologyUtils.graphAll(grid, player);
                break;
            }
            case P2P_LINKS: {
                TopologyUtils.graphP2PLinks(grid, player);
                break;
            }
            case SUBNETWORK: {
                TopologyUtils.graphSubnetworks(grid, player);
                break;
            }
            case NODE_CLICKED: {
                TopologyUtils.graphGiven(grid, player, machine);
            }
        }
    }

    @Nonnull
    public static JSONObject getInnerObject() {
        return innerObject;
    }

    public static TextComponentString createLink() {
        ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, "http://127.0.0.1:" + AIConfig.webUIPort);
        TextComponentString message = new TextComponentString(TextFormatting.AQUA + TextFormatting.UNDERLINE + "http://127.0.0.1:" + AIConfig.webUIPort);
        message.func_150256_b().func_150241_a(click);
        return message;
    }

    private static void graphGiven(IGrid grid, EntityPlayer player, IGridHost machine) {
        ArrayList<IGridNode> nodeList = new ArrayList<IGridNode>();
        for (IGridNode node : grid.getNodes()) {
            if (node.getMachine().getClass() != machine.getClass()) continue;
            nodeList.add(node);
        }
        innerObject = TopologyUtils.createJSONFromGridNodes(nodeList);
    }

    private static void graphSubnetworks(final IGrid grid, EntityPlayer player) {
        EnergyGridCache iEnergyGrid = (EnergyGridCache)grid.getCache(IEnergyGrid.class);
        Collection gridProviders = iEnergyGrid.providers();
        ArrayList<IGridNode> nodeList = new ArrayList<IGridNode>();
        ArrayList<Pair<IGridNode, IGridNode>> connections = new ArrayList<Pair<IGridNode, IGridNode>>();
        nodeList.add(grid.getPivot());
        gridProviders.forEach(iEnergyGridProvider -> {
            Pair<IGridNode, IGridNode> pair = new Pair<IGridNode, IGridNode>(){

                public IGridNode getLeft() {
                    return grid.getPivot();
                }

                public IGridNode getRight() {
                    if (iEnergyGridProvider instanceof IGridHost) {
                        return ((IGridHost)iEnergyGridProvider).getGridNode(AEPartLocation.INTERNAL);
                    }
                    return null;
                }

                public IGridNode setValue(IGridNode value) {
                    return null;
                }
            };
            if (pair.getRight() != null) {
                connections.add(pair);
            }
            if (iEnergyGridProvider instanceof IGridHost) {
                nodeList.add(((IGridHost)iEnergyGridProvider).getGridNode(AEPartLocation.INTERNAL));
            }
        });
        TopologyUtils.createSubnetworkJSON(nodeList, connections, grid);
    }

    private static void graphLineNodes(IGrid grid, EntityPlayer player) {
    }

    private static void graphAll(IGrid grid, EntityPlayer player) {
        innerObject = TopologyUtils.createJSONFromGridNodes((Iterable<IGridNode>)grid.getNodes());
    }

    private static void graphP2PLinks(IGrid grid, EntityPlayer player) {
        P2PCache cache = (P2PCache)grid.getCache(P2PCache.class);
        LinkedList tunnelList = new LinkedList();
        grid.getNodes().forEach(iGridNode -> {
            if (iGridNode.getMachine() instanceof PartP2PTunnel) {
                tunnelList.add((PartP2PTunnel)iGridNode.getMachine());
            }
        });
        LinkedList<Pair<IGridNode, IGridNode>> connections = new LinkedList<Pair<IGridNode, IGridNode>>();
        tunnelList.forEach(partP2PTunnel -> cache.getOutputs(partP2PTunnel.getFrequency(), partP2PTunnel.getClass()).forEach(tunnelRight -> connections.add(new Pair<IGridNode, IGridNode>(){

            public IGridNode getLeft() {
                return partP2PTunnel.getGridNode();
            }

            public IGridNode getRight() {
                return tunnelRight.getGridNode();
            }

            public IGridNode setValue(IGridNode value) {
                return null;
            }
        })));
        LinkedList<IGridNode> nodeList = new LinkedList<IGridNode>();
        tunnelList.forEach(partP2PTunnel -> nodeList.add(partP2PTunnel.getGridNode()));
        innerObject = TopologyUtils.createJSONFromConnections(nodeList, connections);
    }

    private static String toHumanReadableString(String toString) {
        String[] array = toString.split("\\.");
        return array[array.length - 1];
    }

    private static JSONObject serializeNodeData(IGridNode node) {
        JSONObject temp = new JSONObject();
        temp.put("Active", node.isActive());
        temp.put("X", node.getGridBlock().getLocation().x);
        temp.put("Y", node.getGridBlock().getLocation().y);
        temp.put("Z", node.getGridBlock().getLocation().z);
        temp.put("Hex", node.getGridBlock().getGridColor().mediumVariant);
        for (GridFlags flag : GridFlags.values()) {
            temp.put(flag.name(), node.getGridBlock().getFlags().contains(flag));
        }
        temp.put("Usage", (Object)(node.getGridBlock().getIdlePowerUsage() + " AE"));
        if (node.getMachine() instanceof PartP2PTunnel) {
            PartP2PTunnel partP2PTunnel = (PartP2PTunnel)node.getMachine();
            temp.put("Frequency", (int)partP2PTunnel.getFrequency());
        } else {
            temp.put("Frequency", 32768);
        }
        temp.put("Pivot", node.getGrid().getPivot() == node);
        return temp;
    }

    private static JSONObject createJSONFromGridNodes(Iterable<IGridNode> nodeList) {
        LinkedList<Pair<IGridNode, IGridNode>> connections = new LinkedList<Pair<IGridNode, IGridNode>>();
        for (IGridNode gridNode : nodeList) {
            gridNode.getConnections().forEach(iGridConnection -> connections.add(new Pair<IGridNode, IGridNode>(){

                public IGridNode getLeft() {
                    return iGridConnection.a();
                }

                public IGridNode getRight() {
                    return iGridConnection.b();
                }

                public IGridNode setValue(IGridNode value) {
                    return null;
                }
            }));
        }
        return TopologyUtils.createJSONFromConnections(nodeList, connections);
    }

    private static JSONObject createJSONFromConnections(Iterable<IGridNode> nodeList, List<Pair<IGridNode, IGridNode>> connections) {
        JSONObject network = new JSONObject();
        JSONArray jsonNodeList = new JSONArray();
        JSONArray aNodeList = new JSONArray();
        JSONArray bNodeList = new JSONArray();
        ArrayList serializedDataList = new ArrayList();
        connections.forEach(iGridNodeIGridNodePair -> {
            aNodeList.put((Object)TopologyUtils.toHumanReadableString(((IGridNode)iGridNodeIGridNodePair.getLeft()).getMachine().toString()));
            bNodeList.put((Object)TopologyUtils.toHumanReadableString(((IGridNode)iGridNodeIGridNodePair.getRight()).getMachine().toString()));
        });
        nodeList.forEach(iGridNode -> {
            jsonNodeList.put((Object)TopologyUtils.toHumanReadableString(iGridNode.getMachine().toString()));
            serializedDataList.add(TopologyUtils.serializeNodeData(iGridNode));
        });
        network.put("nodes", (Object)jsonNodeList);
        network.put("src", (Object)aNodeList);
        network.put("dest", (Object)bNodeList);
        network.put("data", serializedDataList);
        network.put("mode", (Object)"not_sub_network");
        return network;
    }

    private static void createSubnetworkJSON(List<IGridNode> nodeList, List<Pair<IGridNode, IGridNode>> connections, IGrid mainNet) {
        JSONObject network = new JSONObject();
        JSONArray jsonNodeList = new JSONArray();
        JSONArray aNodeList = new JSONArray();
        JSONArray bNodeList = new JSONArray();
        ArrayList<JSONObject> serializedDataList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> serializedGridList = new ArrayList<JSONObject>();
        for (IGridNode gridNode : nodeList) {
            serializedDataList.add(TopologyUtils.serializeNodeData(gridNode));
            if (gridNode == mainNet.getPivot()) {
                if (jsonNodeList.toList().contains("Selected Network")) continue;
                jsonNodeList.put((Object)"Selected Network");
                JSONObject obj = TopologyUtils.createJSONFromGridNodes((Iterable<IGridNode>)mainNet.getNodes());
                obj.put("iGridProvider", (Object)TopologyUtils.toHumanReadableString(gridNode.getMachine().toString()));
                serializedGridList.add(obj);
                continue;
            }
            jsonNodeList.put((Object)TopologyUtils.toHumanReadableString(gridNode.getMachine().toString()));
            Collection providers = ((IEnergyGridProvider)gridNode.getMachine()).providers();
            providers.forEach(iEnergyGridProvider -> {
                if (iEnergyGridProvider != mainNet.getCache(IEnergyGrid.class)) {
                    IGrid outerGrid = null;
                    try {
                        outerGrid = SubnetHelper.getOuterGridOrNull((IGridCache)iEnergyGridProvider);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    if (outerGrid != null) {
                        JSONObject obj = TopologyUtils.createJSONFromGridNodes((Iterable<IGridNode>)outerGrid.getNodes());
                        obj.put("iGridProvider", (Object)TopologyUtils.toHumanReadableString(gridNode.getMachine().toString()));
                        serializedGridList.add(obj);
                    }
                }
            });
        }
        connections.forEach(iGridNodePair -> {
            aNodeList.put((Object)"Selected Network");
            bNodeList.put((Object)TopologyUtils.toHumanReadableString(((IGridNode)iGridNodePair.getRight()).getMachine().toString()));
        });
        network.put("nodes", (Object)jsonNodeList);
        network.put("src", (Object)aNodeList);
        network.put("dest", (Object)bNodeList);
        network.put("data", serializedDataList);
        network.put("mode", (Object)"sub_network");
        network.put("iGridData", serializedGridList);
        innerObject = network;
    }
}

