/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Proxy;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.Blocks.BlocksEnum;
import AppliedIntegrations.Client.TextureEventManager;
import AppliedIntegrations.Gui.Hosts.IWidgetHost;
import AppliedIntegrations.Gui.MultiController.FilterSlots.WidgetEnergySlot;
import AppliedIntegrations.Gui.MultiController.FilterSlots.WidgetFluidSlot;
import AppliedIntegrations.Gui.MultiController.FilterSlots.WidgetItemSlot;
import AppliedIntegrations.Helpers.Energy.Utils;
import AppliedIntegrations.Integration.Botania.BotaniaLoader;
import AppliedIntegrations.Items.ItemEnum;
import AppliedIntegrations.Proxy.CommonProxy;
import AppliedIntegrations.Topology.WebServer.WebManager;
import AppliedIntegrations.api.AIApi;
import AppliedIntegrations.api.Storage.IEnergyStorageChannel;
import AppliedIntegrations.grid.AEEnergyStack;
import AppliedIntegrations.tile.HoleStorageSystem.TileMETurretFoundation;
import AppliedIntegrations.tile.HoleStorageSystem.render.TileBlackHoleRenderer;
import AppliedIntegrations.tile.HoleStorageSystem.render.TileMEPylonRenderer;
import AppliedIntegrations.tile.HoleStorageSystem.render.TileMETurretRenderer;
import AppliedIntegrations.tile.HoleStorageSystem.render.TileWhiteHoleRenderer;
import AppliedIntegrations.tile.HoleStorageSystem.singularities.TileBlackHole;
import AppliedIntegrations.tile.HoleStorageSystem.singularities.TileWhiteHole;
import AppliedIntegrations.tile.HoleStorageSystem.storage.TileMEPylon;
import AppliedIntegrations.tile.MultiController.Render.MultiControllerRibRenderer;
import AppliedIntegrations.tile.MultiController.Render.MultiControllerSecurityRenderer;
import AppliedIntegrations.tile.MultiController.TileMultiControllerCore;
import AppliedIntegrations.tile.MultiController.TileMultiControllerRib;
import AppliedIntegrations.tile.MultiController.TileMultiControllerTerminal;
import AppliedIntegrations.tile.MultiController.helpers.Matter.FilteredMultiControllerPortEnergyHandler;
import AppliedIntegrations.tile.MultiController.helpers.Matter.FilteredMultiControllerPortFluidHandler;
import AppliedIntegrations.tile.MultiController.helpers.Matter.FilteredMultiControllerPortItemHandler;
import appeng.api.AEApi;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.fluids.util.AEFluidStack;
import appeng.fluids.util.IAEFluidTank;
import appeng.util.item.AEItemStack;
import java.util.LinkedHashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ClientProxy
extends CommonProxy {
    public ClientProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void SidedPreInit() {
        super.SidedPreInit();
        FMLCommonHandler.instance().bus().register((Object)new TextureEventManager());
        if (AIConfig.enableMEServer) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileMultiControllerRib.class, (TileEntitySpecialRenderer)new MultiControllerRibRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileMultiControllerTerminal.class, (TileEntitySpecialRenderer)new MultiControllerSecurityRenderer());
        }
        if (AIConfig.enableBlackHoleStorage) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileBlackHole.class, (TileEntitySpecialRenderer)new TileBlackHoleRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileWhiteHole.class, (TileEntitySpecialRenderer)new TileWhiteHoleRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileMEPylon.class, (TileEntitySpecialRenderer)new TileMEPylonRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileMETurretFoundation.class, (TileEntitySpecialRenderer)new TileMETurretRenderer());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void SidedInit(FMLInitializationEvent init) {
        super.SidedInit(init);
        ItemEnum.registerModels();
        BlocksEnum.registerModels();
        BlocksEnum.registerItemModels();
        try {
            this.registerChannelSprites();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (AIConfig.enableWebServer) {
            WebManager.init();
        }
    }

    private void registerChannelSprites() throws NoSuchMethodException {
        AIApi instance = Objects.requireNonNull(AIApi.instance());
        instance.addChannelToServerFilterList(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class), new ResourceLocation("appliedintegrations", "textures/gui/states.png"), WidgetItemSlot.class.getConstructor(Integer.TYPE, Integer.TYPE), FilteredMultiControllerPortItemHandler.class.getConstructor(LinkedHashMap.class, LinkedHashMap.class, TileMultiControllerCore.class), (stack1, world) -> AEItemStack.fromItemStack((ItemStack)stack1), (Pair<Integer, Integer>)Pair.of((Object)0, (Object)0), (Pair<AIApi.IStackEncoder, AIApi.IStackDecoder>)Pair.of((nbt, stack) -> stack.writeToNBT(nbt), AEItemStack::fromNBT));
        instance.addChannelToServerFilterList(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class), new ResourceLocation("appliedintegrations", "textures/gui/states.png"), WidgetFluidSlot.class.getConstructor(IAEFluidTank.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, IWidgetHost.class), FilteredMultiControllerPortFluidHandler.class.getConstructor(LinkedHashMap.class, LinkedHashMap.class, TileMultiControllerCore.class), (stack, world) -> {
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluidStack == null || fluidStack.amount == 0 || fluidStack.getFluid() == null) {
                return null;
            }
            return AEFluidStack.fromFluidStack((FluidStack)fluidStack);
        }, (Pair<Integer, Integer>)Pair.of((Object)16, (Object)0), (Pair<AIApi.IStackEncoder, AIApi.IStackDecoder>)Pair.of((nbt, stack) -> stack.writeToNBT(nbt), AEFluidStack::fromNBT));
        instance.addChannelToServerFilterList(AEApi.instance().storage().getStorageChannel(IEnergyStorageChannel.class), new ResourceLocation("appliedintegrations", "textures/gui/states.png"), WidgetEnergySlot.class.getConstructor(IWidgetHost.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE), FilteredMultiControllerPortEnergyHandler.class.getConstructor(LinkedHashMap.class, LinkedHashMap.class, TileMultiControllerCore.class), Utils::getEnergyStackFromItemStack, (Pair<Integer, Integer>)Pair.of((Object)0, (Object)16), (Pair<AIApi.IStackEncoder, AIApi.IStackDecoder>)Pair.of((nbt, stack) -> stack.writeToNBT(nbt), AEEnergyStack::fromNBT));
        if (Loader.isModLoaded((String)"botania") && AIConfig.enableManaFeatures) {
            BotaniaLoader.initChannelHandlers(instance);
        }
    }

    @Override
    public void SidedPostInit() {
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }
}

