/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts;

import appeng.api.AEApi;
import appeng.api.parts.IPartModel;
import appeng.api.parts.IPartModels;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public enum PartModelEnum implements IPartModel
{
    EXPORT_BASE("export_base"),
    EXPORT_HAS_CHANNEL(new Object[]{EXPORT_BASE, "export_has_channel"}),
    EXPORT_OFF(new Object[]{EXPORT_BASE, "export_off"}),
    EXPORT_ON(new Object[]{EXPORT_BASE, "export_on"}),
    IMPORT_BASE("import_base"),
    IMPORT_HAS_CHANNEL(new Object[]{IMPORT_BASE, "import_has_channel"}),
    IMPORT_OFF(new Object[]{IMPORT_BASE, "import_off"}),
    IMPORT_ON(new Object[]{IMPORT_BASE, "import_on"}),
    DISPLAY_BASE("display_base"),
    TERMINAL_OFF(new Object[]{DISPLAY_BASE, "display_status_off", "terminal_off"}),
    TERMINAL_ON(new Object[]{DISPLAY_BASE, "display_status_on", "terminal_on"}),
    TERMINAL_HAS_CHANNEL(new Object[]{TERMINAL_ON, "display_has_channel"}),
    STORAGE_BUS_BASE("storage_base"),
    STORAGE_BUS_OFF(new Object[]{STORAGE_BUS_BASE, "storage_off"}),
    STORAGE_BUS_ON(new Object[]{STORAGE_BUS_BASE, "storage_on"}),
    STORAGE_BUS_HAS_CHANNEL(new Object[]{STORAGE_BUS_BASE, "storage_has_channel"}),
    MANA_STORAGE_BUS_BASE("mana_storage_base"),
    MANA_STORAGE_BUS_OFF(new Object[]{MANA_STORAGE_BUS_BASE, "mana_storage_off"}),
    MANA_STORAGE_BUS_ON(new Object[]{MANA_STORAGE_BUS_BASE, "mana_storage_on"}),
    MANA_STORAGE_BUS_HAS_CHANNEL(new Object[]{MANA_STORAGE_BUS_BASE, "mana_storage_has_channel"}),
    P2P_MANA("p2p/tunnel_mana"),
    P2P_EMBER("p2p/tunnel_ember"),
    P2P_WILL("p2p/tunnel_will"),
    STORAGE_INTERFACE_BASE("interface_base"),
    STORAGE_INTERFACE_OFF(new Object[]{STORAGE_INTERFACE_BASE, "interface_off"}),
    STORAGE_INTERFACE_ON(new Object[]{STORAGE_INTERFACE_BASE, "interface_on"}),
    STORAGE_INTERFACE_HAS_CHANNEL(new Object[]{STORAGE_INTERFACE_BASE, "interface_has_channel"}),
    STORAGE_INTERFACE_MANA_BASE("mana_interface_base"),
    STORAGE_INTERFACE_MANA_OFF(new Object[]{STORAGE_INTERFACE_MANA_BASE, "mana_interface_off"}),
    STORAGE_INTERFACE_MANA_ON(new Object[]{STORAGE_INTERFACE_MANA_BASE, "mana_interface_on"}),
    STORAGE_INTERFACE_MANA_HAS_CHANNEL(new Object[]{STORAGE_INTERFACE_MANA_BASE, "mana_interface_has_channel"}),
    ANNIHILATION_BASE("annihilation_base"),
    ANNIHILATION_OFF(new Object[]{ANNIHILATION_BASE, "annihilation_off"}),
    ANNIHILATION_HAS_CHANNEL(new Object[]{ANNIHILATION_BASE, "annihilation_has_channel"}),
    ANNIHILATION_ON(new Object[]{ANNIHILATION_BASE, "annihilation_on"}),
    FORMATION_BASE("formation_base"),
    FORMATION_OFF(new Object[]{FORMATION_BASE, "formation_off"}),
    FORMATION_HAS_CHANNEL(new Object[]{FORMATION_BASE, "formation_has_channel"}),
    FORMATION_ON(new Object[]{FORMATION_BASE, "formation_on"}),
    INTERACTION_BASE("interaction/interaction_base"),
    INTERACTION_OFF(new Object[]{INTERACTION_BASE, "interaction/interaction_off"}),
    INTERACTION_HAS_CHANNEL(new Object[]{INTERACTION_BASE, "interaction/interaction_has_channel"}),
    INTERACTION_ON(new Object[]{INTERACTION_BASE, "interaction/interaction_on"});

    List<ResourceLocation> locations;

    private PartModelEnum(Object ... modelNames) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Object o : modelNames) {
            if (o instanceof IPartModel) {
                builder.addAll((Iterable)((IPartModel)o).getModels());
                continue;
            }
            builder.add((Object)new ResourceLocation("appliedintegrations", "part/" + o.toString()));
        }
        this.locations = builder.build();
    }

    public static void registerModels() {
        IPartModels partModels = AEApi.instance().registries().partModels();
        for (PartModelEnum model : PartModelEnum.values()) {
            partModels.registerModels(model.getModels());
        }
    }

    public boolean requireCableConnection() {
        return true;
    }

    @Nonnull
    public List<ResourceLocation> getModels() {
        return this.locations;
    }

    public ResourceLocation getFirstModel() {
        return this.getModels().get(0);
    }
}

