/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.P2P;

import AppliedIntegrations.Parts.P2P.AIP2PModels;
import AppliedIntegrations.Parts.P2P.AIPartP2PTunnel;
import AppliedIntegrations.Parts.PartModelEnum;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.soul.IDemonWillConduit;
import WayofTime.bloodmagic.tile.TileDemonPylon;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartModel;
import appeng.me.GridAccessException;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PartWillP2PTunnel
extends AIPartP2PTunnel<PartWillP2PTunnel>
implements IGridTickable {
    private IDemonWillConduit inputHandler = new InputWillHandler();
    private static final AIP2PModels MODELS = new AIP2PModels(PartModelEnum.P2P_WILL.getFirstModel());

    public PartWillP2PTunnel(ItemStack is) {
        super(is);
    }

    private TileDemonPylon getAdjacentWillHandler() {
        TileEntity self;
        TileEntity te;
        if (this.isActive() && (te = (self = this.getTile()).func_145831_w().func_175625_s(self.func_174877_v().func_177972_a(this.getSide().getFacing()))) instanceof TileDemonPylon) {
            return (TileDemonPylon)te;
        }
        return null;
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(2, 2, false, false);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.isOutput()) {
            TileDemonPylon pylon = this.getAdjacentWillHandler();
            if (pylon == null) {
                return TickRateModulation.SAME;
            }
            for (EnumDemonWillType will : EnumDemonWillType.values()) {
                double drain = WorldDemonWillHandler.drainWill((World)pylon.func_145831_w(), (BlockPos)pylon.func_174877_v(), (EnumDemonWillType)will, (double)1.0, (boolean)false);
                double fill = this.inputHandler.fillDemonWill(will, drain, true);
                WorldDemonWillHandler.drainWill((World)pylon.func_145831_w(), (BlockPos)pylon.func_174877_v(), (EnumDemonWillType)will, (double)fill, (boolean)true);
            }
        }
        return TickRateModulation.SAME;
    }

    public IDemonWillConduit getInputHandler() {
        return this.inputHandler;
    }

    private class InputWillHandler
    implements IDemonWillConduit {
        private InputWillHandler() {
        }

        public int getWeight() {
            int total = 0;
            try {
                for (PartWillP2PTunnel t : PartWillP2PTunnel.this.getOutputs()) {
                    if (t.getAdjacentWillHandler() == null) continue;
                    total += t.getAdjacentWillHandler().getWeight();
                }
            }
            catch (GridAccessException e) {
                return 0;
            }
            return total;
        }

        public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
            int totalReceived = 0;
            try {
                int outputTunnels = PartWillP2PTunnel.this.getOutputs().size();
                if (outputTunnels == 0 | amount == 0.0) {
                    return 0.0;
                }
                double amountPerOutput = amount / (double)outputTunnels;
                double overflow = amountPerOutput == 0.0 ? amount : amount % amountPerOutput;
                for (PartWillP2PTunnel t : PartWillP2PTunnel.this.getOutputs()) {
                    TileDemonPylon output = t.getAdjacentWillHandler();
                    if (output == null) continue;
                    double toSend = amountPerOutput + overflow;
                    double received = WorldDemonWillHandler.fillWill((World)output.func_145831_w(), (BlockPos)output.func_174877_v(), (EnumDemonWillType)type, (double)toSend, (boolean)doFill);
                    overflow = toSend - received;
                    totalReceived = (int)((double)totalReceived + received);
                }
                if (doFill) {
                    PartWillP2PTunnel.this.queueTunnelDrain(PowerUnits.AE, type != EnumDemonWillType.DEFAULT ? (double)(totalReceived * 2) : (double)totalReceived);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return totalReceived;
        }

        public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
            return 0.0;
        }

        public boolean canFill(EnumDemonWillType type) {
            return true;
        }

        public boolean canDrain(EnumDemonWillType type) {
            return false;
        }

        public double getCurrentWill(EnumDemonWillType type) {
            int total = 0;
            try {
                for (PartWillP2PTunnel t : PartWillP2PTunnel.this.getOutputs()) {
                    TileDemonPylon pylon = t.getAdjacentWillHandler();
                    if (pylon == null) continue;
                    total = (int)((double)total + WorldDemonWillHandler.getCurrentWill((World)pylon.func_145831_w(), (BlockPos)pylon.func_174877_v(), (EnumDemonWillType)type));
                }
            }
            catch (GridAccessException e) {
                return 0.0;
            }
            return total;
        }
    }
}

