/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.P2P;

import AppliedIntegrations.Integration.Botania.IBotaniaIntegrated;
import AppliedIntegrations.Parts.P2P.AIP2PModels;
import AppliedIntegrations.Parts.P2P.AIPartP2PTunnel;
import AppliedIntegrations.Parts.PartModelEnum;
import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.me.GridAccessException;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.api.mana.IManaReceiver;

@Optional.Interface(iface="vazkii.botania.api.mana.IManaReceiver", modid="botania", striprefs=true)
public class PartManaP2PTunnel
extends AIPartP2PTunnel<PartManaP2PTunnel>
implements IBotaniaIntegrated,
IManaReceiver {
    private static final AIP2PModels MODELS = new AIP2PModels(PartModelEnum.P2P_MANA.getFirstModel());
    private static final IManaReceiver NULL_HANDLER = new IManaReceiver(){

        public int getCurrentMana() {
            return 0;
        }

        public boolean isFull() {
            return false;
        }

        public void recieveMana(int mana) {
        }

        public boolean canRecieveManaFromBursts() {
            return false;
        }
    };

    public PartManaP2PTunnel(ItemStack is) {
        super(is);
    }

    private double receiveManaWithDiff(IManaReceiver output, double toSend) {
        int initialMana = output.getCurrentMana();
        output.recieveMana((int)toSend);
        int newMana = output.getCurrentMana();
        return newMana - initialMana;
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public boolean isFull() {
        if (!this.isOutput()) {
            try {
                for (PartManaP2PTunnel t : this.getOutputs()) {
                    if (!t.getAdjacentManaStorage().isFull()) continue;
                    return true;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return false;
        }
        return this.getAdjacentManaStorage().isFull();
    }

    public void recieveMana(int mana) {
        if (!this.isOutput()) {
            int totalReceived = 0;
            try {
                int outputTunnels = this.getOutputs().size();
                if (outputTunnels == 0 | mana == 0) {
                    return;
                }
                double amountPerOutput = (double)mana / (double)outputTunnels;
                double overflow = amountPerOutput == 0.0 ? (double)mana : (double)mana % amountPerOutput;
                for (PartManaP2PTunnel target : this.getOutputs()) {
                    IManaReceiver output = target.getAdjacentManaStorage();
                    double toSend = amountPerOutput + overflow;
                    double received = this.receiveManaWithDiff(output, toSend);
                    overflow = toSend - received;
                    totalReceived = (int)((double)totalReceived + received);
                }
                this.queueTunnelDrain(PowerUnits.RF, totalReceived);
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            this.getAdjacentManaStorage().recieveMana(mana);
        }
    }

    public boolean canRecieveManaFromBursts() {
        if (!this.isOutput()) {
            try {
                for (PartManaP2PTunnel t : this.getOutputs()) {
                    if (!t.getAdjacentManaStorage().canRecieveManaFromBursts()) continue;
                    return true;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return false;
        }
        return this.getAdjacentManaStorage().canRecieveManaFromBursts();
    }

    public int getCurrentMana() {
        if (!this.isOutput()) {
            int total = 0;
            try {
                for (PartManaP2PTunnel t : this.getOutputs()) {
                    total += t.getAdjacentManaStorage().getCurrentMana();
                }
            }
            catch (GridAccessException e) {
                return 0;
            }
            return total;
        }
        return this.getAdjacentManaStorage().getCurrentMana();
    }

    @Nonnull
    private IManaReceiver getAdjacentManaStorage() {
        TileEntity self;
        TileEntity te;
        if (this.isActive() && (te = (self = this.getTile()).func_145831_w().func_175625_s(self.func_174877_v().func_177972_a(this.getSide().getFacing()))) instanceof IManaReceiver) {
            return (IManaReceiver)te;
        }
        return NULL_HANDLER;
    }
}

