/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.Energy;

import AppliedIntegrations.Container.part.ContainerEnergyStorage;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Gui.Hosts.IPriorityHostExtended;
import AppliedIntegrations.Integration.IntegrationsHelper;
import AppliedIntegrations.Inventory.AIGridNodeInventory;
import AppliedIntegrations.Inventory.Handlers.HandlerEnergyStorageBusContainer;
import AppliedIntegrations.Inventory.Handlers.HandlerEnergyStorageBusInterface;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PartGUI.PacketAccessModeServerToClient;
import AppliedIntegrations.Network.Packets.PartGUI.PacketFilterServerToClient;
import AppliedIntegrations.Parts.AIPart;
import AppliedIntegrations.Parts.IEnergyMachine;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.Parts.PartModelEnum;
import AppliedIntegrations.Utils.ChangeHandler;
import AppliedIntegrations.api.IEnergyInterface;
import AppliedIntegrations.api.IEnumHost;
import AppliedIntegrations.api.IInventoryHost;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.EnumCapabilityType;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.sync.GuiBridge;
import appeng.tile.networking.TileCableBus;
import appeng.util.Platform;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.energy.CapabilityEnergy;

public class PartEnergyStorage
extends AIPart
implements ICellContainer,
IGridTickable,
IEnergyMachine,
IInventoryHost,
IPriorityHostExtended,
IEnumHost {
    public static final int FILTER_SIZE = 18;
    public final List<LiquidAIEnergy> filteredEnergies = new LinkedList<LiquidAIEnergy>();
    private final ChangeHandler<AccessRestriction> accessRestrictionChangeHandler = new ChangeHandler();
    public AccessRestriction access = AccessRestriction.READ_WRITE;
    public List<ContainerEnergyStorage> linkedListeners = new ArrayList<ContainerEnergyStorage>();
    private IMEInventoryHandler<IAEEnergyStack> handler;
    private boolean lastActive = false;
    private int priority = 0;
    private boolean updateRequested;
    private List<ChangeHandler<LiquidAIEnergy>> filteredEnergiesChangeHandler = new ArrayList<ChangeHandler<LiquidAIEnergy>>();
    private AIGridNodeInventory upgradeInventory = new AIGridNodeInventory("ME Energy Export/Import Bus", 4, 1, this){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return AEApi.instance().definitions().materials().cardInverter().isSameAs(itemStack);
        }
    };

    public PartEnergyStorage() {
        this(PartEnum.EnergyStorageBus, SecurityPermissions.EXTRACT, SecurityPermissions.INJECT);
        for (int index = 0; index < 18; ++index) {
            this.filteredEnergies.add(null);
            this.filteredEnergiesChangeHandler.add(new ChangeHandler());
        }
    }

    protected PartEnergyStorage(PartEnum manaStorage, SecurityPermissions inject, SecurityPermissions extract) {
        super(manaStorage);
    }

    private void postCellEvent() {
        IGridNode node = this.getGridNode(AEPartLocation.INTERNAL);
        if (node != null) {
            IGrid grid = node.getGrid();
            grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
    }

    private IMEInventoryHandler<IAEEnergyStack> generateNewHandler(TileEntity tile) {
        if (tile instanceof IEnergyInterface) {
            this.handler = new HandlerEnergyStorageBusInterface((IEnergyInterface)tile, this);
        } else if (tile instanceof TileCableBus) {
            TileCableBus maybeInterface = (TileCableBus)tile;
            if (maybeInterface.getPart(this.getHostSide().getOpposite()) instanceof IEnergyInterface) {
                this.handler = new HandlerEnergyStorageBusInterface((IEnergyInterface)((TileCableBus)tile).getPart(this.getHostSide().getOpposite()), this);
            }
        } else if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false) && tile.hasCapability(Capabilities.ENERGY_ACCEPTOR_CAPABILITY, this.getHostSide().getFacing().func_176734_d())) {
            this.handler = new HandlerEnergyStorageBusContainer(this, tile, EnumCapabilityType.Joules);
        } else if (tile.hasCapability(CapabilityEnergy.ENERGY, this.getHostSide().getFacing().func_176734_d())) {
            this.handler = new HandlerEnergyStorageBusContainer(this, tile, EnumCapabilityType.FE);
        } else if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false) && tile instanceof IEnergySink) {
            this.handler = new HandlerEnergyStorageBusContainer(this, tile, EnumCapabilityType.EU);
        }
        return this.handler;
    }

    private IMEInventoryHandler<IAEEnergyStack> getHandler() {
        return this.handler == null && this.getFacingTile() != null ? this.generateNewHandler(this.getFacingTile()) : this.handler;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(20, 20, false, false);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode iGridNode, int ticksSinceLastCall) {
        for (ContainerEnergyStorage listener : this.linkedListeners) {
            for (int i = 0; i < 18; ++i) {
                int finalI = i;
                this.filteredEnergiesChangeHandler.get(i).onChange(this.filteredEnergies.get(i), energy -> NetworkHandler.sendTo(new PacketFilterServerToClient((LiquidAIEnergy)((Object)energy), finalI, this), (EntityPlayerMP)listener.player));
                if (!this.updateRequested) continue;
                NetworkHandler.sendTo(new PacketFilterServerToClient(this.filteredEnergies.get(i), finalI, this), (EntityPlayerMP)listener.player);
            }
            this.accessRestrictionChangeHandler.onChange(this.access, accessRestriction -> NetworkHandler.sendTo(new PacketAccessModeServerToClient(this.access, this), (EntityPlayerMP)listener.player));
            if (!this.updateRequested) continue;
            NetworkHandler.sendTo(new PacketAccessModeServerToClient(this.access, this), (EntityPlayerMP)listener.player);
        }
        this.updateRequested = false;
        return TickRateModulation.SAME;
    }

    @Override
    public AIGridNodeInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < 18; ++i) {
            if (this.filteredEnergies.get(i) != null) {
                tag.func_74778_a("#ENERGY" + i, this.filteredEnergies.get(i).getTag());
                continue;
            }
            tag.func_74778_a("#ENERGY" + i, "null");
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        for (int i = 0; i < 18; ++i) {
            String energyTag = tag.func_74779_i("#ENERGY" + i);
            if (energyTag.equals("null")) {
                this.filteredEnergies.set(i, null);
                continue;
            }
            this.filteredEnergies.set(i, LiquidAIEnergy.energies.get(energyTag));
        }
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public void onNeighborChanged(IBlockAccess access, BlockPos pos, BlockPos neighbor) {
        if (pos == null || neighbor == null) {
            return;
        }
        TileEntity tile = this.getFacingTile();
        if (tile != null) {
            this.generateNewHandler(tile);
            this.postCellEvent();
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand enumHand, Vec3d vec3d) {
        if (Platform.isServer() && !player.func_70093_af()) {
            AIGuiHandler.open(AIGuiHandler.GuiEnum.GuiStoragePart, player, this.getHostSide(), this.getHostTile().func_174877_v());
            this.updateRequested = true;
            return true;
        }
        return false;
    }

    @Override
    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged changedChannels) {
        boolean currentActive = this.getGridNode().isActive();
        if (this.lastActive != currentActive) {
            this.lastActive = currentActive;
            this.host.markForUpdate();
            this.postCellEvent();
        }
    }

    public void onEntityCollision(Entity entity) {
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 2.0f;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return PartModelEnum.STORAGE_BUS_HAS_CHANNEL;
            }
            return PartModelEnum.STORAGE_BUS_ON;
        }
        return PartModelEnum.STORAGE_BUS_OFF;
    }

    public void blinkCell(int i) {
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        IMEInventoryHandler<IAEEnergyStack> handler = this.getHandler();
        if (channel != this.getChannel() || handler == null) {
            return new LinkedList<IMEInventoryHandler>();
        }
        return Collections.singletonList(handler);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
    }

    public ItemStack getItemStackRepresentation() {
        return this.getItemStack(PartItemStack.BREAK);
    }

    public GuiBridge getGuiBridge() {
        return null;
    }

    public void saveChanges(@Nullable ICellInventory<?> iCellInventory) {
        if (iCellInventory != null) {
            iCellInventory.persist();
        }
        this.getHostTile().func_145831_w().func_175646_b(this.getHostTile().func_174877_v(), this.getHostTile());
    }

    @Override
    public void updateFilter(LiquidAIEnergy energy, int index) {
        this.filteredEnergies.set(index, energy);
    }

    @Override
    public void onInventoryChanged() {
    }

    @Override
    @Nonnull
    public AIGuiHandler.GuiEnum getGui() {
        return AIGuiHandler.GuiEnum.GuiStoragePart;
    }

    @Override
    public void setEnumVal(Enum val) {
        this.access = (AccessRestriction)val;
        this.postCellEvent();
    }
}

