/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts.Energy;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.Container.part.ContainerEnergyInterface;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Gui.Hosts.IPriorityHostExtended;
import AppliedIntegrations.Helpers.EnergyInterfaceDuality;
import AppliedIntegrations.Integration.IntegrationsHelper;
import AppliedIntegrations.Inventory.AIGridNodeInventory;
import AppliedIntegrations.Parts.AIPart;
import AppliedIntegrations.Parts.IEnergyMachine;
import AppliedIntegrations.Parts.PartEnum;
import AppliedIntegrations.Parts.PartModelEnum;
import AppliedIntegrations.Utils.AILog;
import AppliedIntegrations.api.EnergyInterfaceStorage;
import AppliedIntegrations.api.IEnergyInterface;
import AppliedIntegrations.api.IEnergyInterfaceDuality;
import AppliedIntegrations.api.IInterfaceStorageDuality;
import AppliedIntegrations.api.IInventoryHost;
import AppliedIntegrations.api.InterfaceSinkSource;
import AppliedIntegrations.api.JouleInterfaceStorage;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.api.TeslaInterfaceStorageDuality;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.exceptions.NullNodeConnectionException;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.sync.GuiBridge;
import appeng.me.GridAccessException;
import appeng.util.Platform;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.event.EnergyTileLoadEvent", modid="ic2", striprefs=true), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2", striprefs=true), @Optional.Interface(iface="mekanism.api.energy.IStrictEnergyStorage", modid="Mekanism", striprefs=true), @Optional.Interface(iface="mekanism.api.energy.IStrictEnergyAcceptor", modid="Mekanism", striprefs=true), @Optional.Interface(iface="mcp.mobius.waila.api.*", modid="Waila", striprefs=true), @Optional.Interface(iface="teamroots.embers.power.IEmberCapability", modid="embers", striprefs=true), @Optional.Interface(iface="teamroots.embers.power.DefaultEmberCapability", modid="embers", striprefs=true)})
public class PartEnergyInterface
extends AIPart
implements IInventory,
IEnergyInterface,
IInventoryHost,
IEnergyMachine,
IPriorityHostExtended,
IGridTickable,
IStorageMonitorable,
ICraftingProvider,
IPowerChannelState,
IEnergySink {
    public LiquidAIEnergy bar;
    public LiquidAIEnergy filteredEnergy = null;
    private int priority;
    private int capacity = AIConfig.interfaceMaxStorage;
    private int maxTransfer = 500000;
    private EnergyInterfaceStorage RFStorage;
    private InterfaceSinkSource EUStorage;
    private JouleInterfaceStorage JStorage;
    private TeslaInterfaceStorageDuality TESLAStorage;
    private EnergyInterfaceDuality duality = new EnergyInterfaceDuality(this);
    private List<ContainerEnergyInterface> linkedListeners = new ArrayList<ContainerEnergyInterface>();
    private AIGridNodeInventory upgradeInventory = new AIGridNodeInventory("", 1, 1, this){

        @Override
        public boolean func_94041_b(int i, ItemStack itemstack) {
            return AEApi.instance().definitions().materials().cardRedstone().isSameAs(itemstack);
        }
    };

    public PartEnergyInterface(PartEnum corespondingEnumPart) {
        super(corespondingEnumPart);
    }

    public PartEnergyInterface() {
        super(PartEnum.EnergyInterface);
        this.duality.initStorage(AEPartLocation.INTERNAL);
    }

    @Override
    public AIGridNodeInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false)) {
            tag.func_74780_a("#EUEnergy", this.EUStorage.getStored().doubleValue());
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false)) {
            this.JStorage.writeToNBT(tag);
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.TESLA, false)) {
            tag.func_74782_a("#TeslaTag", (NBTBase)this.TESLAStorage.serializeNBT());
        }
        this.RFStorage.writeToNBT(tag);
        if (this.filteredEnergy != null) {
            this.filteredEnergy.writeToNBT(tag);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false)) {
            this.JStorage.readFromNBT(tag);
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.TESLA, false)) {
            this.TESLAStorage.deserializeNBT(tag.func_74775_l("#TeslaTag"));
        }
        this.RFStorage.readFromNBT(tag);
        this.filteredEnergy = LiquidAIEnergy.readFromNBT(tag);
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false)) {
            this.invalidateSinkSource();
        }
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false)) {
            this.updateSinkSource();
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand enumHand, Vec3d vec3d) {
        if (Platform.isServer() && !player.func_70093_af()) {
            AIGuiHandler.open(AIGuiHandler.GuiEnum.GuiInterface, player, this.getHostSide(), this.getHostTile().func_174877_v());
        }
        return true;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack stack : this.upgradeInventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    private void updateSinkSource() {
        if (this.getEnergyStorage(AIEnergy.EU, AEPartLocation.INTERNAL) == null) {
            this.EUStorage = new InterfaceSinkSource(this, AEPartLocation.INTERNAL, this.getMaxEnergyStored(null, AIEnergy.EU), 4, 4);
        }
        ((InterfaceSinkSource)this.getEnergyStorage(AIEnergy.EU, AEPartLocation.INTERNAL)).update();
    }

    private void invalidateSinkSource() {
        if (this.getEnergyStorage(AIEnergy.EU, AEPartLocation.INTERNAL) != null) {
            ((InterfaceSinkSource)this.getEnergyStorage(AIEnergy.EU, AEPartLocation.INTERNAL)).invalidate();
        }
    }

    public void onEntityCollision(Entity entity) {
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 2.0f;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            if (this.isActive()) {
                return PartModelEnum.STORAGE_INTERFACE_HAS_CHANNEL;
            }
            return PartModelEnum.STORAGE_INTERFACE_ON;
        }
        return PartModelEnum.STORAGE_INTERFACE_OFF;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability) {
        return this.duality.hasCapability(capability);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability) {
        return this.duality.getCapability(capability, AEPartLocation.INTERNAL);
    }

    @Override
    public void onInventoryChanged() {
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
    }

    public ItemStack getItemStackRepresentation() {
        return this.getItemStack(PartItemStack.BREAK);
    }

    public GuiBridge getGuiBridge() {
        return null;
    }

    public void removeListener(ContainerEnergyInterface container) {
        this.linkedListeners.remove(container);
    }

    public void addListener(ContainerEnergyInterface container) {
        if (!this.linkedListeners.contains(container)) {
            this.linkedListeners.add(container);
        }
    }

    @Override
    public final void updateFilter(LiquidAIEnergy energy, int index) {
        this.filteredEnergy = energy;
    }

    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(1, 1, false, false);
    }

    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int TicksSinceLastCall) {
        if (!this.getHostTile().func_145831_w().field_72995_K) {
            if (this.bar != null) {
                this.duality.notifyListenersOfBarFilterChange(this.bar);
                this.duality.notifyListenersOfEnergyBarChange(this.bar, AEPartLocation.INTERNAL);
            }
            try {
                if (this.isActive()) {
                    this.doInjectDualityWork(Actionable.MODULATE);
                    this.doExtractDualityWork(Actionable.MODULATE);
                }
            }
            catch (NullNodeConnectionException | GridAccessException e) {
                AILog.error(e, "Part energy interface can't access it's grid", new Object[0]);
            }
            this.saveChanges();
        }
        return TickRateModulation.IDLE;
    }

    private void saveChanges() {
        if (this.host != null) {
            this.host.markForSave();
        }
    }

    public IEnergyInterfaceDuality getDuality() {
        return this.duality;
    }

    @Override
    public double getMaxTransfer(AEPartLocation side) {
        return this.maxTransfer;
    }

    @Override
    public LiquidAIEnergy getFilteredEnergy(AEPartLocation side) {
        return this.filteredEnergy;
    }

    @Override
    public IInterfaceStorageDuality getEnergyStorage(LiquidAIEnergy energy, AEPartLocation side) {
        if (energy == AIEnergy.RF) {
            return this.RFStorage;
        }
        if (energy == AIEnergy.EU) {
            return this.EUStorage;
        }
        if (energy == AIEnergy.J) {
            return this.JStorage;
        }
        if (energy == AIEnergy.TESLA) {
            return this.TESLAStorage;
        }
        return null;
    }

    @Override
    public void doInjectDualityWork(Actionable action) throws NullNodeConnectionException, GridAccessException {
        this.getDuality().doInjectDualityWork(action);
    }

    @Override
    public void doExtractDualityWork(Actionable action) throws NullNodeConnectionException, GridAccessException {
        this.getDuality().doExtractDualityWork(action);
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return false;
    }

    public boolean isBusy() {
        return false;
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (this.getGridNode(AEPartLocation.INTERNAL) == null) {
            return null;
        }
        IGrid grid = this.getGridNode(AEPartLocation.INTERNAL).getGrid();
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        return storage.getInventory(channel);
    }

    public int func_70302_i_() {
        return 9;
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70301_a(int id) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Override
    public void initEnergyStorage(LiquidAIEnergy energy, AEPartLocation side) {
        if (energy == AIEnergy.RF) {
            this.initRFStorage();
        }
        if (energy == AIEnergy.EU) {
            this.initEUStorage();
        }
        if (energy == AIEnergy.J) {
            this.initJStorage();
        }
        if (energy == AIEnergy.TESLA) {
            this.initTESLAStorage();
        }
    }

    private void initRFStorage() {
        this.RFStorage = new EnergyInterfaceStorage(this, AEPartLocation.INTERNAL, AIEnergy.RF, this.capacity, this.maxTransfer);
    }

    @Optional.Method(modid="ic2")
    private void initEUStorage() {
    }

    @Optional.Method(modid="mekanism")
    private void initJStorage() {
        this.JStorage = new JouleInterfaceStorage(this, AEPartLocation.INTERNAL, (int)((double)this.capacity * 2.5));
    }

    @Optional.Method(modid="tesla")
    private void initTESLAStorage() {
        this.TESLAStorage = new TeslaInterfaceStorageDuality(this, AEPartLocation.INTERNAL, Long.valueOf(this.capacity), Long.valueOf(this.maxTransfer));
    }

    @Override
    public int getMaxEnergyStored(AEPartLocation unknown, @Nullable LiquidAIEnergy linkedMetric) {
        if (linkedMetric == AIEnergy.RF) {
            return this.capacity;
        }
        if (linkedMetric == AIEnergy.EU) {
            return (int)((double)this.capacity * 0.25);
        }
        if (linkedMetric == AIEnergy.J) {
            return (int)((double)this.capacity * 2.5);
        }
        if (linkedMetric == AIEnergy.WA) {
            return this.capacity * 10;
        }
        if (linkedMetric == AIEnergy.HU) {
            return this.capacity * 4;
        }
        if (linkedMetric == AIEnergy.KU) {
            return this.capacity * 4;
        }
        if (linkedMetric == AIEnergy.FZ) {
            return this.capacity;
        }
        if (linkedMetric == AIEnergy.AE) {
            return this.capacity / 2;
        }
        return 0;
    }

    @Override
    public TileEntity getFacingTile(EnumFacing side) {
        return this.getFacingTile();
    }

    @Override
    public List<ContainerEnergyInterface> getListeners() {
        return this.linkedListeners;
    }

    @Override
    public void setLastInjectedEnergy(AEPartLocation side, LiquidAIEnergy energy) {
        this.bar = energy;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return (Double)this.getEnergyStorage(AIEnergy.EU, AEPartLocation.INTERNAL).getMaxStored() - (Double)this.getEnergyStorage(AIEnergy.EU, AEPartLocation.INTERNAL).getStored();
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing enumFacing, double v, double v1) {
        return this.getEnergyStorage(AIEnergy.EU, AEPartLocation.INTERNAL).receive(v, Actionable.MODULATE);
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        return true;
    }

    @Override
    @Nonnull
    public AIGuiHandler.GuiEnum getGui() {
        return AIGuiHandler.GuiEnum.GuiInterface;
    }
}

