/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Parts;

import AppliedIntegrations.Parts.AIPart;
import AppliedIntegrations.Parts.PartEnum;
import appeng.api.parts.PartItemStack;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public abstract class AIRotatablePart
extends AIPart {
    private static final String NBT_KEY_ROT_DIR = "partRotation";
    protected byte renderRotation = 0;

    public AIRotatablePart(PartEnum associatedPart) {
        super(associatedPart);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(NBT_KEY_ROT_DIR)) {
            this.renderRotation = data.func_74771_c(NBT_KEY_ROT_DIR);
        }
    }

    @Override
    public void writeToStream(ByteBuf stream) throws IOException {
        super.writeToStream(stream);
        stream.writeByte((int)this.renderRotation);
    }

    @Override
    public boolean readFromStream(ByteBuf stream) throws IOException {
        boolean redraw = super.readFromStream(stream);
        byte streamRot = stream.readByte();
        if (this.renderRotation != streamRot) {
            this.renderRotation = streamRot;
            redraw = true;
        }
        return redraw;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d position) {
        TileEntity hte = this.getHostTile();
        if (!player.func_70093_af() && Platform.isWrench((EntityPlayer)player, (ItemStack)player.func_184586_b(hand), (BlockPos)hte.func_174877_v())) {
            if (Platform.isServer()) {
                if (this.renderRotation > 3 || this.renderRotation < 0) {
                    this.renderRotation = 0;
                }
                switch (this.renderRotation) {
                    case 0: {
                        this.renderRotation = 1;
                        break;
                    }
                    case 1: {
                        this.renderRotation = (byte)3;
                        break;
                    }
                    case 2: {
                        this.renderRotation = 0;
                        break;
                    }
                    case 3: {
                        this.renderRotation = (byte)2;
                    }
                }
                this.markForUpdate();
                this.markForSave();
            }
            return true;
        }
        return super.onActivate(player, hand, position);
    }

    @Override
    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        super.writeToNBT(data, saveType);
        if (saveType == PartItemStack.WORLD && this.renderRotation != 0) {
            data.func_74774_a(NBT_KEY_ROT_DIR, this.renderRotation);
        }
    }
}

