/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Network.Packets.HoleStorage;

import AppliedIntegrations.Network.ClientPacketHelper;
import AppliedIntegrations.Network.Packets.AIPacket;
import AppliedIntegrations.api.BlackHoleSystem.ISingularity;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;

public class PacketPylonSingularitySync
extends AIPacket {
    public boolean shouldDrain;
    public ISingularity operatedTile;
    public BlockPos pos;
    public float beamState;

    public PacketPylonSingularitySync() {
    }

    public PacketPylonSingularitySync(ISingularity operatedTile, float beamState, boolean shouldDrain, BlockPos pos) {
        this.pos = pos;
        this.operatedTile = operatedTile;
        this.beamState = beamState;
        this.shouldDrain = shouldDrain;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        this.beamState = buf.readFloat();
        this.shouldDrain = buf.readBoolean();
        boolean isNull = buf.readBoolean();
        if (!isNull) {
            this.operatedTile = (ISingularity)ClientPacketHelper.readSyncHostClient(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
        buf.writeFloat(this.beamState);
        buf.writeBoolean(this.shouldDrain);
        if (this.operatedTile != null) {
            buf.writeBoolean(false);
            this.writeSyncHost(this.operatedTile, buf, false);
        } else {
            buf.writeBoolean(true);
        }
    }
}

