/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Items;

import AppliedIntegrations.Items.AIItemRegistrable;
import AppliedIntegrations.Items.ItemEnum;
import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.features.ILocatable;
import appeng.api.features.INetworkEncodable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.capabilities.Capabilities;
import appeng.core.localization.GuiText;
import appeng.tile.networking.TileWireless;
import appeng.util.Platform;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnergyWirelessTerminal
extends AIItemRegistrable
implements IWirelessTermHandler,
INetworkEncodable,
IAEItemPowerStorage {
    private static final String TAG_KEY = "#encryption_key";
    private static final String TAG_ENERGY = "#energy_stored";
    private static final String TAG_SQUARED_RANGE = "#squared_range";
    private static final String TAG_RANGE = "#range";
    protected final double capacity = 1600000.0;

    public ItemEnergyWirelessTerminal(String name) {
        super(name);
        this.func_77625_d(1);
        AEApi.instance().registries().wireless().registerWirelessHandler((IWirelessTermHandler)this);
    }

    protected IGrid getGrid(ItemStack stack) {
        ILocatable obj = null;
        try {
            obj = AEApi.instance().registries().locatable().getLocatableBy(Long.parseLong(this.getEncryptionKey(stack)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (obj instanceof IActionHost) {
            IGridNode n = ((IActionHost)obj).getActionableNode();
            return n.getGrid();
        }
        return null;
    }

    protected boolean isNotInRange(ItemStack stack, IGrid grid, BlockPos pos, int worldID) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
        tag.func_74780_a(TAG_RANGE, Double.MAX_VALUE);
        tag.func_74780_a(TAG_SQUARED_RANGE, Double.MAX_VALUE);
        if (grid != null) {
            IMachineSet tw = grid.getMachines(TileWireless.class);
            IWirelessAccessPoint wap = null;
            for (IGridNode n : tw) {
                IWirelessAccessPoint point = (IWirelessAccessPoint)n.getMachine();
                if (!this.isWapInRange(point, tag, pos, worldID)) continue;
                wap = point;
            }
            return wap == null;
        }
        return true;
    }

    private boolean isWapInRange(IWirelessAccessPoint wap, NBTTagCompound tag, BlockPos pos, int worldID) {
        double offZ;
        double offY;
        double offX;
        double r;
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalCoord dc = wap.getLocation();
        if (dc.getWorld().field_73011_w.getDimension() == worldID && (r = (offX = (double)(dc.x - pos.func_177958_n())) * offX + (offY = (double)(dc.y - pos.func_177956_o())) * offY + (offZ = (double)(dc.z - pos.func_177952_p())) * offZ) < rangeLimit && tag.func_74769_h(TAG_SQUARED_RANGE) > r && wap.isActive()) {
            tag.func_74780_a(TAG_SQUARED_RANGE, r);
            tag.func_74780_a(TAG_RANGE, Math.sqrt(r));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        double percent = this.getAECurrentPower(stack) / this.getAEMaxPower(stack);
        lines.add(GuiText.StoredEnergy.getLocal() + ": " + MessageFormat.format(" {0,number,#} ", this.getAECurrentPower(stack)) + " - " + MessageFormat.format(" {0,number,#.##%} ", percent) + "%");
        if (stack.func_77942_o()) {
            NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
            if (tag != null) {
                String encKey = tag.func_74779_i(TAG_KEY);
                if (encKey.isEmpty()) {
                    lines.add(GuiText.Unlinked.getLocal());
                } else {
                    lines.add(GuiText.Linked.getLocal());
                }
            }
        } else {
            lines.add(I18n.func_74838_a((String)GuiText.Unlinked.getLocal()));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World w, EntityPlayer player, EnumHand hand) {
        AEApi.instance().registries().wireless().openWirelessTerminalGui(player.func_184586_b(hand), w, player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack is) {
        return 1.0 - this.getAECurrentPower(is) / this.getAEMaxPower(is);
    }

    public String getEncryptionKey(ItemStack stack) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
        return tag.func_74764_b(TAG_KEY) ? tag.func_74779_i(TAG_KEY) : "";
    }

    public void setEncryptionKey(ItemStack stack, String s, String s1) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)stack);
        tag.func_74778_a(TAG_KEY, s);
    }

    public double injectAEPower(ItemStack stack, double v, Actionable actionable) {
        double maxStorage = this.getAEMaxPower(stack);
        double currentStorage = this.getAECurrentPower(stack);
        double required = maxStorage - currentStorage;
        double overflow = v - required;
        if (actionable == Actionable.MODULATE) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)stack);
            double toAdd = Math.min(v, required);
            data.func_74780_a(TAG_ENERGY, currentStorage + toAdd);
        }
        return Math.max(0.0, overflow);
    }

    public double extractAEPower(ItemStack stack, double v, Actionable actionable) {
        double currentStorage = this.getAECurrentPower(stack);
        double extractable = Math.min(v, currentStorage);
        if (actionable == Actionable.MODULATE) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)stack);
            data.func_74780_a(TAG_ENERGY, currentStorage - extractable);
        }
        return extractable;
    }

    public double getAEMaxPower(ItemStack itemStack) {
        return 1600000.0;
    }

    public double getAECurrentPower(ItemStack stack) {
        NBTTagCompound data = Platform.openNbtData((ItemStack)stack);
        return data.func_74769_h(TAG_ENERGY);
    }

    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        return AccessRestriction.WRITE;
    }

    public boolean canHandle(ItemStack itemStack) {
        return itemStack.func_77973_b() == ItemEnum.ITEMENERGYWIRELESSTERMINAL.getItem();
    }

    public boolean usePower(EntityPlayer entityPlayer, double v, ItemStack itemStack) {
        return this.extractAEPower(itemStack, v, Actionable.MODULATE) >= v - 0.5;
    }

    public boolean hasPower(EntityPlayer entityPlayer, double v, ItemStack itemStack) {
        return this.getAECurrentPower(itemStack) >= v;
    }

    public IConfigManager getConfigManager(ItemStack itemStack) {
        return null;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyTerminalCapabilityDelegate(stack, this);
    }

    private static class EnergyTerminalCapabilityDelegate
    implements ICapabilityProvider,
    IEnergyStorage {
        private final ItemStack is;
        private final IAEItemPowerStorage item;
        private final Object teslaAdapter;

        EnergyTerminalCapabilityDelegate(ItemStack is, IAEItemPowerStorage item) {
            this.is = is;
            this.item = item;
            this.teslaAdapter = Capabilities.TESLA_CONSUMER != null || Capabilities.TESLA_HOLDER != null ? new TeslaPowerDelegate() : null;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == Capabilities.FORGE_ENERGY || capability == Capabilities.TESLA_CONSUMER || capability == Capabilities.TESLA_HOLDER;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == Capabilities.FORGE_ENERGY) {
                return (T)this;
            }
            if (capability == Capabilities.TESLA_CONSUMER || capability == Capabilities.TESLA_HOLDER) {
                return (T)this.teslaAdapter;
            }
            return null;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            double convertedOffer = PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxReceive);
            double overflow = this.item.injectAEPower(this.is, convertedOffer, simulate ? Actionable.SIMULATE : Actionable.MODULATE);
            return maxReceive - (int)PowerUnits.AE.convertTo(PowerUnits.RF, overflow);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.item.getAECurrentPower(this.is));
        }

        public int getMaxEnergyStored() {
            return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.item.getAEMaxPower(this.is));
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        private class TeslaPowerDelegate
        implements ITeslaConsumer,
        ITeslaHolder {
            private TeslaPowerDelegate() {
            }

            public long givePower(long power, boolean simulated) {
                return EnergyTerminalCapabilityDelegate.this.receiveEnergy((int)power, simulated);
            }

            public long getStoredPower() {
                return EnergyTerminalCapabilityDelegate.this.getEnergyStored();
            }

            public long getCapacity() {
                return EnergyTerminalCapabilityDelegate.this.getMaxEnergyStored();
            }
        }
    }
}

