/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Integration.Botania;

import AppliedIntegrations.AIConfig;
import AppliedIntegrations.Gui.MultiController.FilterSlots.WidgetManaSlot;
import AppliedIntegrations.Helpers.Energy.Utils;
import AppliedIntegrations.Integration.Botania.BotaniaEntryHelper;
import AppliedIntegrations.Integration.Botania.ManaLayer;
import AppliedIntegrations.Items.ItemEnum;
import AppliedIntegrations.api.AIApi;
import AppliedIntegrations.api.Botania.IManaStorageChannel;
import AppliedIntegrations.grid.Mana.AEManaStack;
import AppliedIntegrations.grid.Mana.ManaStorageChannel;
import AppliedIntegrations.tile.MultiController.TileMultiControllerCore;
import AppliedIntegrations.tile.MultiController.helpers.Matter.FilteredMultiControllerPortManaHandler;
import appeng.api.AEApi;
import appeng.api.features.IGrinderRecipe;
import appeng.api.storage.IStorageChannel;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.BotaniaAPI;

public class BotaniaLoader {
    public static void preInit() {
        AEApi.instance().storage().registerStorageChannel(IManaStorageChannel.class, (IStorageChannel)new ManaStorageChannel());
        BotaniaEntryHelper helper = new BotaniaEntryHelper();
        helper.createPages();
    }

    public static void init() {
        AEApi.instance().partHelper().registerNewLayer(ManaLayer.class.getName(), ManaLayer.class.getName());
    }

    public static void postInit() {
    }

    public static void initRecipes() {
        BotaniaAPI.registerManaInfusionRecipe((ItemStack)new ItemStack(ItemEnum.MANASTORAGE_1k.getItem(), 1, 0), (Object)new ItemStack(ItemEnum.ENERGYSTORAGE_1k.getItem(), 1, 0), (int)100000);
        BotaniaAPI.registerManaInfusionRecipe((ItemStack)new ItemStack(ItemEnum.MANASTORAGE_4k.getItem(), 1, 0), (Object)new ItemStack(ItemEnum.ENERGYSTORAGE_4k.getItem(), 1, 0), (int)100000);
        BotaniaAPI.registerManaInfusionRecipe((ItemStack)new ItemStack(ItemEnum.MANASTORAGE_16k.getItem(), 1, 0), (Object)new ItemStack(ItemEnum.ENERGYSTORAGE_16k.getItem(), 1, 0), (int)200000);
        BotaniaAPI.registerManaInfusionRecipe((ItemStack)new ItemStack(ItemEnum.MANASTORAGE_64k.getItem(), 1, 0), (Object)new ItemStack(ItemEnum.ENERGYSTORAGE_64k.getItem(), 1, 0), (int)200000);
        Optional fluixOptional = AEApi.instance().definitions().materials().fluixCrystal().maybeStack(1);
        Optional pureFluixOptional = AEApi.instance().definitions().materials().purifiedFluixCrystal().maybeStack(1);
        if (fluixOptional.isPresent()) {
            ItemStack fluixStack = (ItemStack)fluixOptional.get();
            BotaniaAPI.registerElvenTradeRecipe((ItemStack)new ItemStack(ItemEnum.ITEMENCORIUMSEED.getItem(), 1, 0), (Object[])new Object[]{fluixStack});
        }
        if (pureFluixOptional.isPresent()) {
            ItemStack fluixPureStack = (ItemStack)pureFluixOptional.get();
            BotaniaAPI.registerElvenTradeRecipe((ItemStack)new ItemStack(ItemEnum.ITEMENCORIUMSEED.getItem(), 1, 0), (Object[])new Object[]{fluixPureStack});
        }
        AEApi.instance().registries().grinder().addRecipe(new IGrinderRecipe(){

            @Nonnull
            public ItemStack getInput() {
                return ItemEnum.ITEMENCORIUM.getStack();
            }

            @Nonnull
            public ItemStack getOutput() {
                return ItemEnum.ITEMENCORIUMDUST.getStack();
            }

            @Nonnull
            public Optional<ItemStack> getOptionalOutput() {
                return Optional.empty();
            }

            public Optional<ItemStack> getSecondOptionalOutput() {
                return Optional.empty();
            }

            @Nonnull
            public float getOptionalChance() {
                return 0.0f;
            }

            public float getSecondOptionalChance() {
                return 0.0f;
            }

            public int getRequiredTurns() {
                return 8;
            }
        });
    }

    public static void initChannelHandlers(AIApi instance) throws NoSuchMethodException {
        instance.addChannelToServerFilterList(AEApi.instance().storage().getStorageChannel(IManaStorageChannel.class), new ResourceLocation("appliedintegrations", "textures/gui/states.png"), WidgetManaSlot.class.getConstructor(new Class[0]), FilteredMultiControllerPortManaHandler.class.getConstructor(LinkedHashMap.class, LinkedHashMap.class, TileMultiControllerCore.class), (itemStack, world) -> Utils.getManaFromItemStack(itemStack), (Pair<Integer, Integer>)Pair.of((Object)32, (Object)0), (Pair<AIApi.IStackEncoder, AIApi.IStackDecoder>)Pair.of((nbt, stack) -> stack.writeToNBT(nbt), AEManaStack::fromNBT));
    }

    public static boolean enableBotania() {
        return Loader.isModLoaded((String)"botania") && AIConfig.enableManaFeatures;
    }
}

