/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Helpers.Energy;

import AppliedIntegrations.Integration.IntegrationsHelper;
import AppliedIntegrations.Parts.AIPart;
import AppliedIntegrations.api.Botania.IAEManaStack;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.IAEEnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import AppliedIntegrations.grid.AEEnergyStack;
import AppliedIntegrations.grid.EnumCapabilityType;
import AppliedIntegrations.grid.Implementation.AIEnergy;
import AppliedIntegrations.grid.Mana.AEManaStack;
import AppliedIntegrations.tile.AITile;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AEPartLocation;
import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IEnergyStorage;
import javax.annotation.Nonnull;
import mekanism.api.energy.IEnergizedItem;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="teamroots.embers.api.item.IEmberChargedTool", modid="embers", striprefs=true), @Optional.Interface(iface="ic2.api.item.IElectricItem", modid="ic2", striprefs=true), @Optional.Interface(iface="mekanism.api.energy.IEnergizedItem", modid="mekanism", striprefs=true)})
public class Utils {
    public static IAEStack<IAEEnergyStack> getEnergyStackFromItemStack(ItemStack itemStack, World world) {
        EnergyStack stack = new EnergyStack(Utils.getEnergyFromItemStack(itemStack, world), 1L);
        if (stack.getEnergy() == null) {
            return null;
        }
        return AEEnergyStack.fromStack(stack);
    }

    public static LiquidAIEnergy getEnergyFromItemStack(ItemStack itemStack, World world) {
        Block blk;
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IPartItem) {
            IPart part = ((IPartItem)item).createPartFromItemStack(itemStack);
            return Utils.getEnergyFromPart(part);
        }
        if (item instanceof ItemBlock && (blk = ((ItemBlock)item).func_179223_d()).hasTileEntity(blk.func_176223_P())) {
            TileEntity tileEntity = blk.createTileEntity(world, blk.func_176223_P());
            if (tileEntity != null) {
                return Utils.getEnergyFromContainer(tileEntity);
            }
            return null;
        }
        return Utils.getEnergyFromItem(item);
    }

    private static LiquidAIEnergy getEnergyFromPart(IPart part) {
        for (LiquidAIEnergy energy : LiquidAIEnergy.energies.values()) {
            if (EnumCapabilityType.fromEnergy(energy) == null) continue;
            EnumCapabilityType type = EnumCapabilityType.fromEnergy(energy);
            if (type == null) {
                return null;
            }
            if (type.getCapabilityWithModCheck() == null) {
                return null;
            }
            for (Capability capability : type.getCapabilityWithModCheck()) {
                if (!part.hasCapability(capability)) continue;
                return type.energy;
            }
        }
        return null;
    }

    private static LiquidAIEnergy getEnergyFromContainer(TileEntity tile) {
        for (LiquidAIEnergy energy : LiquidAIEnergy.energies.values()) {
            EnumCapabilityType type;
            if (EnumCapabilityType.fromEnergy(energy) == null || (type = EnumCapabilityType.fromEnergy(energy)) == null) continue;
            if (type.getCapabilityWithModCheck() == null) {
                if (type != EnumCapabilityType.EU || !(tile instanceof IEnergyStorage)) continue;
                return type.energy;
            }
            for (Capability capability : type.getCapabilityWithModCheck()) {
                if (!tile.hasCapability(capability, null)) continue;
                return type.energy;
            }
        }
        return null;
    }

    private static LiquidAIEnergy getEnergyFromItem(Item item) {
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.EU, false) && item instanceof IElectricItem) {
            return AIEnergy.EU;
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.J, false) && item instanceof IEnergizedItem) {
            return AIEnergy.J;
        }
        if (IntegrationsHelper.instance.isLoaded(AIEnergy.RF, true) && item instanceof IEnergyContainerItem) {
            return AIEnergy.RF;
        }
        return null;
    }

    public static ISyncHost getSyncHostByParams(@Nonnull BlockPos pos, @Nonnull AEPartLocation side, @Nonnull World obj) {
        if (side == AEPartLocation.INTERNAL) {
            return Utils.getTileByParams(pos, obj);
        }
        return Utils.getPartByParams(pos, side.getFacing(), obj);
    }

    public static AITile getTileByParams(BlockPos pos, World world) {
        return world.func_175625_s(pos) instanceof AITile ? (AITile)world.func_175625_s(pos) : null;
    }

    public static AIPart getPartByParams(@Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull World world) {
        return (AIPart)((IPartHost)world.func_175625_s(pos)).getPart(side);
    }

    public static IAEManaStack getManaFromItemStack(ItemStack itemStack) {
        return new AEManaStack(0);
    }
}

