/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Gui.Widgets;

import AppliedIntegrations.Gui.AIGuiHelper;
import AppliedIntegrations.Gui.Hosts.IWidgetHost;
import AppliedIntegrations.Gui.Widgets.AIWidget;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PacketTabChange;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class WidgetGuiTab
extends AIWidget {
    private static final ResourceLocation INV_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final int ICON_OFFSET_X = 6;
    private static final int ICON_OFFSET_Y = 8;
    private final RenderItem itemRenderer;
    private final FontRenderer fontRenderer;
    private final int adjustentHeight;
    private final int width = 27;
    public final Enum tabEnum;
    private final ItemStack stack;
    public boolean isTabSelected;
    private String tabName;

    private WidgetGuiTab(IWidgetHost hostGUI, int xPos, int yPos, int adjustentHeight, boolean isSelected, Enum tabEnum, String tabName, ItemStack itemStack, RenderItem itemRenderer, FontRenderer fontRenderer) {
        super(hostGUI, xPos, yPos);
        this.tabEnum = tabEnum;
        this.isTabSelected = isSelected;
        this.tabName = tabName;
        this.adjustentHeight = adjustentHeight;
        this.itemRenderer = itemRenderer;
        this.fontRenderer = fontRenderer;
        this.stack = itemStack;
    }

    public WidgetGuiTab(IWidgetHost hostGUI, int xPos, int yPos, int adjustentHeight, boolean isSelected, Enum tabEnum, String tabName, Item item, RenderItem itemRenderer, FontRenderer fontRenderer) {
        this(hostGUI, xPos, yPos, adjustentHeight, isSelected, tabEnum, tabName, new ItemStack(item), itemRenderer, fontRenderer);
    }

    public WidgetGuiTab(IWidgetHost hostGUI, int xPos, int yPos, int adjustentHeight, boolean isSelected, Enum tabEnum, String tabName, Block block, RenderItem itemRender, FontRenderer fontRenderer) {
        this(hostGUI, xPos, yPos, adjustentHeight, isSelected, tabEnum, tabName, new ItemStack(block), itemRender, fontRenderer);
    }

    private int getHeight() {
        return this.isTabSelected ? 28 + this.adjustentHeight : 28;
    }

    private int getTextureY() {
        return this.isTabSelected ? 32 : 0;
    }

    public String getTabName() {
        return this.tabName;
    }

    public void mouseClicked() {
        NetworkHandler.sendToServer(new PacketTabChange(this.hostGUI.getSyncHost(), this.tabEnum));
        this.isTabSelected = true;
    }

    @Override
    public void drawWidget() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(INV_TABS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.func_73729_b(this.xPosition, this.yPosition, 0, this.getTextureY(), 27, this.getHeight());
        this.itemRenderer.func_180450_b(this.stack, this.xPosition + 6, this.yPosition + 8);
        this.itemRenderer.func_175030_a(this.fontRenderer, this.stack, this.xPosition + 6, this.yPosition + 8);
        GL11.glEnable((int)2896);
    }

    @Override
    public void getTooltip(List<String> tooltip) {
    }

    @Override
    public boolean isMouseOverWidget(int mouseX, int mouseY) {
        return AIGuiHelper.INSTANCE.isPointInGuiRegion(this.yPosition, this.xPosition, this.getHeight() - 1, 26, mouseX, mouseY, this.hostGUI.getLeft(), this.hostGUI.getTop());
    }
}

