/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Gui.Part;

import AppliedIntegrations.Container.part.ContainerEnergyStorage;
import AppliedIntegrations.Gui.AIGui;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Gui.MultiController.FilterSlots.WidgetEnergySlot;
import AppliedIntegrations.Gui.Widgets.EnergyWidget;
import AppliedIntegrations.Helpers.Energy.Utils;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PacketEnum;
import AppliedIntegrations.Network.Packets.PacketGuiShift;
import AppliedIntegrations.Parts.Energy.PartEnergyStorage;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Settings;
import appeng.client.gui.widgets.GuiImgButton;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiEnergyStoragePart
extends AIGui {
    public static final int WIDGET_COLUMNS = 2;
    public static final int WIDGET_ROWS = 9;
    public static final int WIDGET_X_POS = 13;
    public static final int WIDGET_Y_POS = 29;
    private static final int GUI_WIDTH_NETWORK_TOOL = 246;
    public static final int GUI_WIDTH_NO_TOOL = 210;
    public static final int TITLE_X_POS = 6;
    public static final int TITLE_Y_POS = 5;
    private boolean hasNetworkTool;
    private PartEnergyStorage storageBus;

    public GuiEnergyStoragePart(ContainerEnergyStorage CEI, PartEnergyStorage storageBus, EntityPlayer player) {
        super(CEI, player);
        this.storageBus = storageBus;
        this.hasNetworkTool = ((ContainerEnergyStorage)this.field_147002_h).hasNetworkTool();
        this.field_146999_f = this.hasNetworkTool ? 246 : 210;
        this.field_147000_g = 251;
    }

    private ContainerEnergyStorage getContainer() {
        return (ContainerEnergyStorage)this.field_147002_h;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addPriorityButton();
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.getContainer().energySlotList.add(new WidgetEnergySlot(this, 0, 13 + 18 * column - 6, 29 + 18 * row - 1, true));
            }
        }
        for (int i = 0; i < 18; ++i) {
            this.getContainer().energySlotList.get((int)i).id = i;
        }
        this.getContainer().accessMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, (Enum)Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        this.field_146292_n.add(this.getContainer().accessMode);
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("appliedintegrations", "textures/gui/energy.storage.bus.png"));
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.field_147003_i + 179, this.field_147009_r, 179, 0, 32, 32);
        if (this.hasNetworkTool) {
            this.func_73729_b(this.field_147003_i + 179, this.field_147009_r + 93, 178, 93, 68, 68);
        }
    }

    @Override
    public ISyncHost getSyncHost() {
        return this.storageBus;
    }

    @Override
    public void setSyncHost(ISyncHost host) {
        if (host instanceof PartEnergyStorage) {
            this.storageBus = (PartEnergyStorage)host;
        }
    }

    @Override
    public void onButtonClicked(GuiButton btn, int mouseButton) {
        super.onButtonClicked(btn, mouseButton);
        if (btn == this.getContainer().accessMode) {
            AccessRestriction mode = (AccessRestriction)this.getContainer().accessMode.getCurrentValue();
            if (mode == AccessRestriction.WRITE) {
                this.getContainer().accessMode.set((Enum)AccessRestriction.READ_WRITE);
            } else if (mode == AccessRestriction.READ_WRITE) {
                this.getContainer().accessMode.set((Enum)AccessRestriction.READ);
            } else if (mode == AccessRestriction.READ) {
                this.getContainer().accessMode.set((Enum)AccessRestriction.WRITE);
            }
            NetworkHandler.sendToServer(new PacketEnum(this.getContainer().accessMode.getCurrentValue(), this.storageBus));
        }
        if (this.storageBus == null) {
            return;
        }
        if (btn == this.priorityButton) {
            NetworkHandler.sendToServer(new PacketGuiShift(AIGuiHandler.GuiEnum.GuiAIPriority, this.storageBus));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(I18n.func_74838_a((String)"ME Energy Storage Bus"), 6, 5, 0);
        this.field_146289_q.func_78276_b(I18n.func_74838_a((String)"Inventory"), 8, this.field_147000_g - 96 + 3, 0x404040);
        EnergyWidget slotUnderMouse = null;
        for (int i = 0; i < this.getContainer().energySlotList.size(); ++i) {
            WidgetEnergySlot currentWidget = this.getContainer().energySlotList.get(i);
            if (slotUnderMouse == null && currentWidget.shouldRender && currentWidget.isMouseOverWidget(mouseX, mouseY)) {
                slotUnderMouse = currentWidget;
            }
            currentWidget.drawWidget();
        }
        if (this.getContainer().accessMode.func_146115_a()) {
            this.tooltip.addAll(Arrays.asList(this.getContainer().accessMode.getMessage().split("\n")));
        }
        if (slotUnderMouse != null) {
            slotUnderMouse.getTooltip(this.tooltip);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (WidgetEnergySlot energySlot : this.getContainer().energySlotList) {
            if (!energySlot.isMouseOverWidget(mouseX, mouseY)) continue;
            LiquidAIEnergy itemEnergy = Utils.getEnergyFromItemStack(this.player.field_71071_by.func_70445_o(), this.storageBus.getHostWorld());
            if (energySlot.getCurrentStack() == null || energySlot.getCurrentStack().getEnergy() == itemEnergy) {
                return;
            }
            energySlot.onMouseClicked(new EnergyStack(itemEnergy, 0L));
            break;
        }
    }
}

