/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Gui.Part;

import AppliedIntegrations.Container.part.ContainerPartEnergyIOBus;
import AppliedIntegrations.Gui.AIGui;
import AppliedIntegrations.Gui.AIGuiHandler;
import AppliedIntegrations.Gui.MultiController.FilterSlots.WidgetEnergySlot;
import AppliedIntegrations.Gui.Widgets.EnergyWidget;
import AppliedIntegrations.Helpers.Energy.Utils;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PacketEnum;
import AppliedIntegrations.Network.Packets.PacketGuiShift;
import AppliedIntegrations.Parts.Energy.PartEnergyExport;
import AppliedIntegrations.Parts.Energy.PartEnergyImport;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.client.gui.widgets.GuiImgButton;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiEnergyIO
extends AIGui {
    private static final int FILTER_GRID_SIZE = 3;
    private static final int WIDGET_X_POSITION = 61;
    private static final int WIDGET_Y_POSITION = 21;
    private static final int GUI_MAIN_WIDTH = 176;
    private static final int GUI_UPGRADES_WIDTH = 35;
    public static final int GUI_UPGRADES_HEIGHT = 86;
    public EntityPlayer player;
    private String stringName;
    private ResourceLocation texture = new ResourceLocation("appliedintegrations", "textures/gui/energy.io.bus.png");

    public GuiEnergyIO(Container container, EntityPlayer player) {
        super(container, player);
        this.player = player;
    }

    public ContainerPartEnergyIOBus getContainer() {
        return (ContainerPartEnergyIOBus)this.field_147002_h;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addPriorityButton();
        this.getContainer().redstoneControlBtn = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, (Enum)Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.field_146292_n.add(this.getContainer().redstoneControlBtn);
        this.getContainer().redstoneControlBtn.setVisibility(false);
        if (!this.getContainer().energySlotList.isEmpty()) {
            return;
        }
        int index = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                int xPos = 61 + column * 18;
                int yPos = 21 + row * 18;
                this.getContainer().energySlotList.add(new WidgetEnergySlot(this, index, xPos, yPos, this.getContainer().configMatrix[index]));
                ++index;
            }
        }
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g + 75);
        this.func_73729_b(this.field_147003_i + 176, this.field_147009_r, 176, 0, 35, 86);
    }

    @Override
    public ISyncHost getSyncHost() {
        return this.getContainer().getSyncHost();
    }

    @Override
    public void setSyncHost(ISyncHost host) {
        this.getContainer().setSyncHost(host);
    }

    @Override
    public void onButtonClicked(GuiButton btn, int mouseButton) {
        if (this.getContainer().part == null) {
            return;
        }
        if (btn == this.priorityButton) {
            NetworkHandler.sendToServer(new PacketGuiShift(AIGuiHandler.GuiEnum.GuiAIPriority, this.getContainer().part));
        }
    }

    @Override
    public void func_73863_a(int MouseX, int MouseY, float pOpacity) {
        super.func_73863_a(MouseX, MouseY, pOpacity);
        this.func_191948_b(MouseX, MouseY);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        boolean hoverUnderlayRendered = false;
        EnergyWidget slotUnderMouse = null;
        for (int i = 0; i < this.getContainer().energySlotList.size(); ++i) {
            WidgetEnergySlot slotWidget = this.getContainer().energySlotList.get(i);
            if (!hoverUnderlayRendered && slotWidget.shouldRender && slotWidget.isMouseOverWidget(mouseX, mouseY)) {
                slotWidget.drawMouseHoverUnderlay();
                slotUnderMouse = slotWidget;
                hoverUnderlayRendered = true;
            }
            slotWidget.drawWidget();
        }
        if (slotUnderMouse != null) {
            slotUnderMouse.getTooltip(this.tooltip);
        }
        if (this.getContainer().redstoneControlBtn.func_146115_a()) {
            this.tooltip.addAll(Arrays.asList(this.getContainer().redstoneControlBtn.getMessage().split("\n")));
        }
        if (this.getContainer().part instanceof PartEnergyExport) {
            this.stringName = I18n.func_74838_a((String)"ME Energy Export Bus");
        }
        if (this.getContainer().part instanceof PartEnergyImport) {
            this.stringName = I18n.func_74838_a((String)"ME Energy Import Bus");
        }
        this.field_146289_q.func_78276_b(this.stringName, 9, 3, 0x404040);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (WidgetEnergySlot slot : this.getContainer().energySlotList) {
            if (!slot.isMouseOverWidget(mouseX, mouseY)) continue;
            LiquidAIEnergy itemEnergy = Utils.getEnergyFromItemStack(this.player.field_71071_by.func_70445_o(), this.getContainer().part.getHostWorld());
            if (slot.getCurrentStack() != null && slot.getCurrentStack().getEnergy() == itemEnergy) {
                return;
            }
            slot.onMouseClicked(new EnergyStack(itemEnergy, 0L));
            break;
        }
        if (this.getContainer().redstoneControlBtn.func_146115_a()) {
            short ordinal = (short)this.getContainer().redstoneControlBtn.getCurrentValue().ordinal();
            this.getContainer().redstoneControlBtn.set((Enum)(ordinal == 3 ? RedstoneMode.IGNORE : RedstoneMode.values()[ordinal + 1]));
            NetworkHandler.sendToServer(new PacketEnum(this.getContainer().redstoneControlBtn.getCurrentValue(), this.getContainer().part));
        }
    }
}

