/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Gui;

import AppliedIntegrations.AppliedIntegrations;
import AppliedIntegrations.Container.ContainerAIPriority;
import AppliedIntegrations.Container.part.ContainerEnergyFormation;
import AppliedIntegrations.Container.part.ContainerEnergyInterface;
import AppliedIntegrations.Container.part.ContainerEnergyStorage;
import AppliedIntegrations.Container.part.ContainerEnergyTerminal;
import AppliedIntegrations.Container.part.ContainerInteractionBus;
import AppliedIntegrations.Container.part.ContainerPartEnergyIOBus;
import AppliedIntegrations.Container.tile.ContainerLogicBus;
import AppliedIntegrations.Container.tile.MultiController.ContainerMultiControllerCore;
import AppliedIntegrations.Container.tile.MultiController.ContainerMultiControllerTerminal;
import AppliedIntegrations.Gui.GuiLogicBus;
import AppliedIntegrations.Gui.GuiPriorityAI;
import AppliedIntegrations.Gui.Hosts.IPriorityHostExtended;
import AppliedIntegrations.Gui.MultiController.GuiMultiControllerCore;
import AppliedIntegrations.Gui.MultiController.GuiMultiControllerTerminal;
import AppliedIntegrations.Gui.Part.GuiEnergyFormation;
import AppliedIntegrations.Gui.Part.GuiEnergyIO;
import AppliedIntegrations.Gui.Part.GuiEnergyInterface;
import AppliedIntegrations.Gui.Part.GuiEnergyStoragePart;
import AppliedIntegrations.Gui.Part.GuiEnergyTerminalDuality;
import AppliedIntegrations.Gui.Part.Interaction.GuiInteractionBus;
import AppliedIntegrations.Helpers.Energy.Utils;
import AppliedIntegrations.Parts.AIOPart;
import AppliedIntegrations.Parts.Energy.PartEnergyFormation;
import AppliedIntegrations.Parts.Energy.PartEnergyStorage;
import AppliedIntegrations.Parts.Energy.PartEnergyTerminal;
import AppliedIntegrations.Parts.Interaction.PartInteraction;
import AppliedIntegrations.api.IEnergyInterface;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.tile.LogicBus.TileLogicBusCore;
import AppliedIntegrations.tile.MultiController.TileMultiControllerCore;
import AppliedIntegrations.tile.MultiController.TileMultiControllerTerminal;
import appeng.api.util.AEPartLocation;
import appeng.util.Platform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class AIGuiHandler
implements IGuiHandler {
    public static void open(@Nonnull GuiEnum gui, @Nonnull EntityPlayer player, @Nonnull AEPartLocation side, @Nonnull BlockPos pos) {
        if (Platform.isClient()) {
            return;
        }
        player.openGui((Object)AppliedIntegrations.instance, AIGuiHandler.concat(gui, side), player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static int concat(GuiEnum gui, AEPartLocation side) {
        return gui.ordinal() << 3 | side.ordinal();
    }

    private static GuiEnum getGui(int value) {
        return GuiEnum.values()[value >> 3];
    }

    private static AEPartLocation getSide(int value) {
        return AEPartLocation.fromOrdinal((int)(value & 7));
    }

    @Nullable
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        AEPartLocation side = AIGuiHandler.getSide(ID);
        GuiEnum gui = AIGuiHandler.getGui(ID);
        if (gui == GuiEnum.GuiInterface) {
            ISyncHost host = Utils.getSyncHostByParams(new BlockPos(x, y, z), side, world);
            return new ContainerEnergyInterface(player, (IEnergyInterface)host);
        }
        if (gui == GuiEnum.GuiLogicBus) {
            TileEntity maybeCore = world.func_175625_s(new BlockPos(x, y, z));
            if (maybeCore instanceof TileLogicBusCore) {
                return new ContainerLogicBus(player, (TileLogicBusCore)maybeCore);
            }
        } else {
            if (gui == GuiEnum.GuiIOPart) {
                AIOPart part = (AIOPart)Utils.getPartByParams(new BlockPos(x, y, z), side.getFacing(), world);
                return new ContainerPartEnergyIOBus(part, player);
            }
            if (gui == GuiEnum.GuiStoragePart) {
                PartEnergyStorage part = (PartEnergyStorage)Utils.getPartByParams(new BlockPos(x, y, z), side.getFacing(), world);
                return new ContainerEnergyStorage(part, player);
            }
            if (gui == GuiEnum.GuiTerminalPart) {
                PartEnergyTerminal part = (PartEnergyTerminal)Utils.getPartByParams(new BlockPos(x, y, z), side.getFacing(), world);
                return new ContainerEnergyTerminal(part, player);
            }
            if (gui == GuiEnum.GuiAIPriority) {
                IPriorityHostExtended host = (IPriorityHostExtended)((Object)Utils.getPartByParams(new BlockPos(x, y, z), side.getFacing(), world));
                return new ContainerAIPriority(player.field_71071_by, host);
            }
            if (gui == GuiEnum.GuiServerTerminal) {
                TileMultiControllerTerminal terminal = (TileMultiControllerTerminal)Utils.getTileByParams(new BlockPos(x, y, z), world);
                return new ContainerMultiControllerTerminal(terminal, player);
            }
            if (gui == GuiEnum.GuiServerStorage) {
                TileMultiControllerCore core = (TileMultiControllerCore)Utils.getTileByParams(new BlockPos(x, y, z), world);
                return new ContainerMultiControllerCore(player, core);
            }
            if (gui == GuiEnum.GuiInteraction) {
                PartInteraction interaction = (PartInteraction)Utils.getPartByParams(new BlockPos(x, y, z), side.getFacing(), world);
                return new ContainerInteractionBus(player, interaction);
            }
            if (gui == GuiEnum.GuiFormationPlane) {
                PartEnergyFormation plane = (PartEnergyFormation)Utils.getPartByParams(new BlockPos(x, y, z), side.getFacing(), world);
                return new ContainerEnergyFormation(plane, player);
            }
        }
        return null;
    }

    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        AEPartLocation side = AIGuiHandler.getSide(ID);
        GuiEnum gui = AIGuiHandler.getGui(ID);
        if (gui == GuiEnum.GuiInterface) {
            return new GuiEnergyInterface((ContainerEnergyInterface)this.getServerGuiElement(ID, player, world, x, y, z), player);
        }
        if (gui == GuiEnum.GuiLogicBus) {
            TileEntity maybeCore = world.func_175625_s(new BlockPos(x, y, z));
            if (maybeCore instanceof TileLogicBusCore) {
                return new GuiLogicBus(player, (TileLogicBusCore)maybeCore, (ContainerLogicBus)this.getServerGuiElement(ID, player, world, x, y, z));
            }
        } else {
            if (gui == GuiEnum.GuiIOPart) {
                return new GuiEnergyIO((ContainerPartEnergyIOBus)this.getServerGuiElement(ID, player, world, x, y, z), player);
            }
            if (gui == GuiEnum.GuiStoragePart) {
                PartEnergyStorage part = (PartEnergyStorage)Utils.getPartByParams(new BlockPos(x, y, z), side.getFacing(), world);
                return new GuiEnergyStoragePart((ContainerEnergyStorage)this.getServerGuiElement(ID, player, world, x, y, z), part, player);
            }
            if (gui == GuiEnum.GuiTerminalPart) {
                PartEnergyTerminal part = (PartEnergyTerminal)Utils.getPartByParams(new BlockPos(x, y, z), side.getFacing(), world);
                return new GuiEnergyTerminalDuality((ContainerEnergyTerminal)this.getServerGuiElement(ID, player, world, x, y, z), part, player);
            }
            if (gui == GuiEnum.GuiAIPriority) {
                IPriorityHostExtended host = (IPriorityHostExtended)((Object)Utils.getPartByParams(new BlockPos(x, y, z), side.getFacing(), world));
                return new GuiPriorityAI(player.field_71071_by, host);
            }
            if (gui == GuiEnum.GuiServerTerminal) {
                return new GuiMultiControllerTerminal((ContainerMultiControllerTerminal)this.getServerGuiElement(ID, player, world, x, y, z), player);
            }
            if (gui == GuiEnum.GuiServerStorage) {
                return new GuiMultiControllerCore((ContainerMultiControllerCore)this.getServerGuiElement(ID, player, world, x, y, z), player);
            }
            if (gui == GuiEnum.GuiInteraction) {
                return new GuiInteractionBus((ContainerInteractionBus)this.getServerGuiElement(ID, player, world, x, y, z), player);
            }
            if (gui == GuiEnum.GuiFormationPlane) {
                return new GuiEnergyFormation((ContainerEnergyFormation)this.getServerGuiElement(ID, player, world, x, y, z), player);
            }
        }
        return null;
    }

    public static enum GuiEnum {
        GuiInterface,
        GuiStoragePart,
        GuiInteraction,
        GuiServerStorage,
        GuiTerminalPart,
        GuiServerTerminal,
        GuiLogicBus,
        GuiAIPriority,
        GuiIOPart,
        GuiFormationPlane;

    }
}

