/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Gui;

import AppliedIntegrations.Container.ContainerWithUpgradeSlots;
import AppliedIntegrations.Gui.AIGuiHelper;
import AppliedIntegrations.Gui.Buttons.AIGuiButton;
import AppliedIntegrations.Gui.Hosts.IWidgetHost;
import appeng.api.AEApi;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.core.localization.GuiText;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class AIGui
extends GuiContainer
implements IWidgetHost {
    protected static final int GUI_MAIN_WIDTH = 176;
    protected static final int GUI_UPGRADES_WIDTH = 35;
    protected static final int GUI_UPGRADES_HEIGHT = 35;
    private static final int BUTTON_PRIORITY_X_POSITION = 154;
    protected final List<String> tooltip = new ArrayList<String>();
    protected GuiTabButton priorityButton;
    public EntityPlayer player;

    public AIGui(Container container, EntityPlayer player) {
        super(container);
        this.player = player;
    }

    protected void addPriorityButton() {
        this.priorityButton = new GuiTabButton(this.field_147003_i + 154, this.field_147009_r, 66, GuiText.Priority.getLocal(), this.field_146296_j);
        this.field_146292_n.add(this.priorityButton);
    }

    public final void func_146284_a(GuiButton button) {
        this.onButtonClicked(button, 0);
    }

    public void onButtonClicked(GuiButton btn, int mouseButton) {
    }

    public void func_73863_a(int mouseX, int mouseY, float mouseButton) {
        super.func_73863_a(mouseX, mouseY, mouseButton);
        if (this.tooltip.isEmpty()) {
            this.addTooltipFromButtons(mouseX, mouseY);
        }
        if (!this.tooltip.isEmpty()) {
            this.drawHoveringText(this.tooltip, mouseX, mouseY, this.field_146289_q);
            this.tooltip.clear();
        }
        this.func_191948_b(mouseX, mouseY);
    }

    private boolean addTooltipFromButtons(int mouseX, int mouseY) {
        for (Object obj : this.field_146292_n) {
            AIGuiButton currentButton;
            if (!(obj instanceof AIGuiButton) || !(currentButton = (AIGuiButton)((Object)obj)).isMouseOverButton(mouseX, mouseY)) continue;
            currentButton.getTooltip(this.tooltip);
            return true;
        }
        return false;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.priorityButton == null) {
            return;
        }
        if (this.priorityButton.func_146115_a()) {
            this.tooltip.addAll(Arrays.asList(this.priorityButton.getMessage().split("\n")));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.field_147002_h instanceof ContainerWithUpgradeSlots && ((ContainerWithUpgradeSlots)this.field_147002_h).hasNetworkTool()) {
            Slot slot = this.getSlotAtMousePosition(mouseX, mouseY);
            Optional stackOptional = AEApi.instance().definitions().items().networkTool().maybeStack(1);
            if (stackOptional.isPresent() && slot != null && slot.func_75211_c().func_77969_a((ItemStack)stackOptional.get())) {
                return;
            }
        }
        try {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Slot getSlotAtMousePosition(int x, int y) {
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!this.isPointWithinSlot(slot, x, y)) continue;
            return slot;
        }
        return null;
    }

    private final boolean isPointWithinSlot(Slot slot, int x, int y) {
        return AIGuiHelper.INSTANCE.isPointInGuiRegion(slot.field_75221_f, slot.field_75223_e, 16, 16, x, y, this.field_147003_i, this.field_147009_r);
    }

    @Override
    public final int getLeft() {
        return this.field_147003_i;
    }

    @Override
    public final int getTop() {
        return this.field_147009_r;
    }
}

