/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Container.part;

import AppliedIntegrations.Container.ContainerWithUpgradeSlots;
import AppliedIntegrations.Container.Sync.IFilterContainer;
import AppliedIntegrations.Container.part.IUpgradeHostContainer;
import AppliedIntegrations.Gui.MultiController.FilterSlots.WidgetEnergySlot;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PartGUI.PacketFullSync;
import AppliedIntegrations.Parts.AIOPart;
import AppliedIntegrations.api.ISyncHost;
import AppliedIntegrations.api.Storage.EnergyStack;
import AppliedIntegrations.api.Storage.LiquidAIEnergy;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.YesNo;
import appeng.client.gui.widgets.GuiImgButton;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;

public class ContainerPartEnergyIOBus
extends ContainerWithUpgradeSlots
implements IFilterContainer,
IUpgradeHostContainer {
    public List<WidgetEnergySlot> energySlotList = new ArrayList<WidgetEnergySlot>();
    public GuiImgButton redstoneControlBtn;
    public static int NUMBER_OF_UPGRADE_SLOTS = 4;
    public static int UPGRADE_X_POS = 187;
    public static int UPGRADE_Y_POS = 8;
    public boolean[] configMatrix = new boolean[]{false, false, false, false, true, false, false, false, false};
    public AIOPart part;

    public ContainerPartEnergyIOBus(AIOPart part, EntityPlayer player) {
        super(player);
        this.part = part;
        this.addUpgradeSlots(part.getUpgradeInventory(), NUMBER_OF_UPGRADE_SLOTS, UPGRADE_X_POS, UPGRADE_Y_POS);
        this.bindPlayerInventory((IInventory)player.field_71071_by, 102, 160);
        this.part.addListener(this);
    }

    @Override
    public void func_75134_a(@Nonnull EntityPlayer player) {
        super.func_75134_a(player);
        this.part.removeListener(this);
    }

    @Override
    protected void syncHostWithGUI() {
        super.syncHostWithGUI();
        NetworkHandler.sendTo(new PacketFullSync(this.part.upgradeInventoryManager, this.part), (EntityPlayerMP)this.player);
    }

    @Override
    public boolean func_75145_c(EntityPlayer p_75145_1_) {
        return true;
    }

    @Override
    public ISyncHost getSyncHost() {
        return this.part;
    }

    @Override
    public void setSyncHost(ISyncHost host) {
        if (host instanceof AIOPart) {
            this.part = (AIOPart)host;
        }
    }

    @Override
    public void updateEnergy(@Nonnull LiquidAIEnergy energy, int index) {
        this.energySlotList.get(index).setCurrentStack(new EnergyStack(energy, 0L));
    }

    @Override
    public void updateState(boolean redstoneControl, boolean compareFuzzy, boolean autoCrafting, RedstoneMode redstoneMode, FuzzyMode fuzzyMode, YesNo craftOnly, byte filterSize) {
        if (filterSize == 0) {
            this.configMatrix = new boolean[]{false, false, false, false, true, false, false, false, false};
        }
        if (filterSize == 1) {
            this.configMatrix = new boolean[]{false, true, false, true, true, true, false, true, false};
        }
        if (filterSize == 2) {
            this.configMatrix = new boolean[]{true, true, true, true, true, true, true, true, true};
        }
        for (int i = 0; i < this.configMatrix.length; ++i) {
            this.energySlotList.get((int)i).shouldRender = this.configMatrix[i];
        }
        this.redstoneControlBtn.setVisibility(redstoneControl);
        this.redstoneControlBtn.set((Enum)redstoneMode);
    }
}

