/*
 * Decompiled with CFR 0.152.
 */
package AppliedIntegrations.Container.part;

import AppliedIntegrations.Container.ContainerWithUpgradeSlots;
import AppliedIntegrations.Container.Sync.ITabContainer;
import AppliedIntegrations.Container.part.ContainerPartEnergyIOBus;
import AppliedIntegrations.Container.part.IUpgradeHostContainer;
import AppliedIntegrations.Container.slot.SlotFilter;
import AppliedIntegrations.Container.slot.SlotToggle;
import AppliedIntegrations.Gui.Part.Interaction.Buttons.GuiClickModeButton;
import AppliedIntegrations.Network.NetworkHandler;
import AppliedIntegrations.Network.Packets.PartGUI.PacketClickModeServerToClient;
import AppliedIntegrations.Network.Packets.PartGUI.PacketFullSync;
import AppliedIntegrations.Parts.Interaction.PartInteraction;
import AppliedIntegrations.api.ISyncHost;
import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.YesNo;
import appeng.client.gui.widgets.GuiImgButton;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerInteractionBus
extends ContainerWithUpgradeSlots
implements IUpgradeHostContainer,
ITabContainer {
    public final List<SlotFilter> filters = new ArrayList<SlotFilter>();
    private static final int SLOT_AREA = 3;
    public GuiClickModeButton shiftClickButton;
    public GuiImgButton redstoneControlButton;
    public GuiImgButton fuzzyModeButton;
    public GuiImgButton craftingModeButton;
    private boolean[] slotMatrix = new boolean[]{false, false, false, false, true, false, false, false, false};
    public PartInteraction interaction;

    public ContainerInteractionBus(final EntityPlayer player, PartInteraction interaction) {
        super(player);
        this.interaction = interaction;
        this.bindPlayerInventory((IInventory)player.field_71071_by, 102, 160);
        this.bindPlayerInventory(interaction.mainInventory, 84, 142);
        this.addUpgradeSlots(interaction.upgradeInventoryManager.upgradeInventory, ContainerPartEnergyIOBus.NUMBER_OF_UPGRADE_SLOTS, ContainerPartEnergyIOBus.UPGRADE_X_POS, ContainerPartEnergyIOBus.UPGRADE_Y_POS);
        int index = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                SlotFilter slot = new SlotFilter(interaction.filterInventory, index, 62 + x * 18, 22 + y * 18, this.slotMatrix);
                this.func_75146_a(slot);
                this.filters.add(slot);
                ++index;
            }
        }
        for (int y = 0; y < 4; ++y) {
            final EntityEquipmentSlot armorType = EntityEquipmentSlot.values()[EntityEquipmentSlot.values().length - 1 - y];
            this.func_75146_a(new SlotToggle(interaction.armorInventory, y, 8, 8 + y * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b().isValidArmor(stack, armorType, (Entity)player);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack stack = this.func_75211_c();
                    return (stack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)stack)) && super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[armorType.func_188454_b()];
                }
            });
        }
        this.func_75146_a(new SlotToggle(interaction.offhandInventory, 0, 77, 62){

            @Nonnull
            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
        this.toggleInvSlots(true);
    }

    private void toggleInvSlots(boolean isEnabled) {
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof SlotToggle)) continue;
            ((SlotToggle)slot).isEnabled = (slot.field_75224_c == this.interaction.mainInventory || slot.field_75224_c == this.interaction.armorInventory || slot.field_75224_c == this.interaction.offhandInventory) != isEnabled;
        }
        this.hotbarSlots[0].isEnabled = false;
    }

    @Override
    public ISyncHost getSyncHost() {
        return this.interaction;
    }

    @Override
    public void setSyncHost(ISyncHost host) {
        this.interaction = (PartInteraction)host;
    }

    @Override
    public void updateState(boolean redstoneControl, boolean compareFuzzy, boolean autoCrafting, RedstoneMode redstoneMode, FuzzyMode fuzzyMode, YesNo craftOnly, byte filterSize) {
        if (this.interaction.upgradeInventoryManager.filterSize == 0) {
            this.slotMatrix = new boolean[]{false, false, false, false, true, false, false, false, false};
        } else if (this.interaction.upgradeInventoryManager.filterSize == 1) {
            this.slotMatrix = new boolean[]{false, true, false, true, true, true, false, true, false};
        } else if (this.interaction.upgradeInventoryManager.filterSize >= 2) {
            this.slotMatrix = new boolean[]{true, true, true, true, true, true, true, true, true};
        }
        for (SlotFilter filter : this.filters) {
            filter.updateMatrix(this.slotMatrix);
        }
        this.redstoneControlButton.setVisibility(redstoneControl);
        this.redstoneControlButton.set((Enum)redstoneMode);
        this.fuzzyModeButton.setVisibility(compareFuzzy);
        this.fuzzyModeButton.set((Enum)fuzzyMode);
        this.craftingModeButton.setVisibility(autoCrafting);
        this.craftingModeButton.set((Enum)craftOnly);
    }

    @Override
    protected void syncHostWithGUI() {
        super.syncHostWithGUI();
        NetworkHandler.sendTo(new PacketFullSync(this.interaction.upgradeInventoryManager, this.interaction), (EntityPlayerMP)this.player);
        if (this.interaction.fakePlayer != null) {
            NetworkHandler.sendTo(new PacketClickModeServerToClient(this.interaction, this.interaction.fakePlayer.func_70093_af()), (EntityPlayerMP)this.player);
        }
    }

    @Override
    public void setTab(Enum tabEnum) {
        PartInteraction.EnumInteractionPlaneTabs planeTab = (PartInteraction.EnumInteractionPlaneTabs)tabEnum;
        if (planeTab == PartInteraction.EnumInteractionPlaneTabs.PLANE_FAKE_PLAYER_FILTER) {
            this.toggleInvSlots(true);
        } else if (planeTab == PartInteraction.EnumInteractionPlaneTabs.PLANE_FAKE_PLAYER_INVENTORY) {
            this.toggleInvSlots(false);
        }
    }
}

