/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.features;

import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.api.FeatureBase;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.os3.ISpawnEntry;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class UnderFluid
extends FeatureBase
implements IFeature {
    public UnderFluid() {
        super(new Random());
    }

    @Override
    public void generate(World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, ISpawnEntry spawnData, ChunkPos chunkPos) {
        ChunkPos pos = chunkPos;
        JsonObject params = spawnData.getFeature().getFeatureParameters();
        int chunkX = pos.field_77276_a;
        int chunkZ = pos.field_77275_b;
        UnderFluid.mergeDefaults(params, this.getDefaultParameters());
        this.runCache(chunkX, chunkZ, world, spawnData);
        int blockX = chunkX * 16 + 8;
        int blockZ = chunkZ * 16 + 8;
        int minHeight = params.get("minHeight").getAsInt();
        int maxHeight = params.get("maxHeight").getAsInt();
        int variance = params.get("variation").getAsInt();
        int triesMin = params.get("minAttempts").getAsInt();
        int triesMax = params.get("maxAttempts").getAsInt();
        int nodeSize = params.get("size").getAsInt();
        Fluid fluid = FluidRegistry.getFluid((String)params.get("fluid").getAsString());
        int tries = this.random.nextInt(triesMax - triesMin + 1) + triesMin;
        int ySpan = maxHeight - minHeight;
        int surveySize = 256 * (16 * ySpan) / 4 / 125;
        BlockPos refBlock = new BlockPos(blockX, minHeight, blockZ);
        Block fluidBlock = fluid.getBlock();
        HashSet<BlockPos> found = new HashSet<BlockPos>();
        int surveyCount = 0;
        int spawnCount = 0;
        while (surveyCount < surveySize && spawnCount < tries) {
            BlockPos sampleCenter = refBlock.func_177982_a(this.random.nextInt(16), this.random.nextInt(ySpan), this.random.nextInt(16));
            BlockPos lowSide = sampleCenter.func_177982_a(-2, -2, -2);
            BlockPos highSide = sampleCenter.func_177982_a(2, 2, 2);
            Chunk chunk = world.func_175726_f(sampleCenter);
            if (found.contains(sampleCenter)) continue;
            found.addAll(this.findPossibleTargets(chunk, lowSide, highSide, fluidBlock, minHeight));
            if (!found.isEmpty()) {
                BlockPos target = found.toArray(new BlockPos[0])[this.random.nextInt(found.size())];
                spawnCount += this.maybeSpawn(target, minHeight, maxHeight, nodeSize, variance, world, spawnData);
            }
            ++surveyCount;
        }
    }

    private int maybeSpawn(BlockPos target, int minHeight, int maxHeight, int nodeSize, int variance, World world, ISpawnEntry spawnData) {
        BlockPos mp = target;
        while (world.func_180495_p(mp).func_185904_a().func_76224_d() && mp.func_177956_o() >= minHeight) {
            mp = mp.func_177977_b();
        }
        if (mp.func_177956_o() > minHeight && mp.func_177956_o() < maxHeight) {
            int size = this.random.nextInt(nodeSize - variance + 1) + this.random.nextInt(variance);
            this.spawnOre(world, spawnData, mp, size);
            return 1;
        }
        return 0;
    }

    private List<BlockPos> findPossibleTargets(Chunk chunk, BlockPos lowSide, BlockPos highSide, Block fluidBlock, int minHeight) {
        return StreamSupport.stream(BlockPos.func_177975_b((BlockPos)lowSide, (BlockPos)highSide).spliterator(), false).filter(bp -> chunk.func_177435_g((BlockPos)bp).func_185904_a().func_76224_d() && chunk.func_177435_g((BlockPos)bp).func_177230_c().equals(fluidBlock) && bp.func_177956_o() >= minHeight).map(BlockPos.MutableBlockPos::func_185334_h).collect(Collectors.toList());
    }

    private void spawnOre(World world, ISpawnEntry spawnData, BlockPos pos, int quantity) {
        int count = quantity;
        int lutType = quantity < 8 ? offsetIndexRef_small.length : offsetIndexRef.length;
        int[] lut = quantity < 8 ? offsetIndexRef_small : offsetIndexRef;
        Vec3i[] offs = new Vec3i[lutType];
        System.arraycopy(quantity < 8 ? offsets_small : offsets, 0, offs, 0, lutType);
        if (quantity < 27) {
            int[] scrambledLUT = new int[lutType];
            System.arraycopy(lut, 0, scrambledLUT, 0, scrambledLUT.length);
            this.scramble(scrambledLUT, this.random);
            while (count > 0) {
                IBlockState oreBlock = spawnData.getBlocks().getRandomBlock(this.random);
                if (oreBlock.func_177230_c().equals(Blocks.field_150350_a)) {
                    return;
                }
                BlockPos target = pos.func_177971_a(offs[scrambledLUT[--count]]);
                this.spawn(oreBlock, world, target, world.field_73011_w.getDimension(), true, spawnData);
            }
            return;
        }
        this.doSpawnFill(this.random.nextBoolean(), count, world, spawnData, pos);
    }

    private void doSpawnFill(boolean nextBoolean, int quantity, World world, ISpawnEntry spawnData, BlockPos pos) {
        int count = quantity;
        double radius = Math.pow(quantity, 0.3333333333333333) * 0.238732414637843 + 2.0;
        int rSqr = (int)(radius * radius);
        if (nextBoolean) {
            this.spawnMungeNE(world, pos, rSqr, radius, spawnData, count);
        } else {
            this.spawnMungeSW(world, pos, rSqr, radius, spawnData, count);
        }
    }

    @Override
    public void setRandom(Random rand) {
        this.random = rand;
    }

    @Override
    public JsonObject getDefaultParameters() {
        JsonObject defParams = new JsonObject();
        defParams.addProperty("minHeight", (Number)0);
        defParams.addProperty("maxHeight", (Number)256);
        defParams.addProperty("variation", (Number)16);
        defParams.addProperty("minAttempts", (Number)4);
        defParams.addProperty("maxAttempts", (Number)4);
        defParams.addProperty("size", (Number)8);
        defParams.addProperty("fluid", "water");
        return defParams;
    }
}

