/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mcmoddev.orespawn.OreSpawn;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.crash.CrashReport;

public class PresetsStorage {
    private final Map<String, Map<String, JsonElement>> storage = new TreeMap<String, Map<String, JsonElement>>();
    private static final String ORE_SPAWN_VERSION = "OreSpawn Version";

    public void setSymbolSection(String sectionName, String itemName, JsonElement value) {
        Map temp = this.storage.getOrDefault(sectionName, new HashMap());
        temp.put(itemName, value);
        this.storage.put(sectionName, temp);
    }

    public JsonElement getSymbolSection(String sectionName, String itemName) {
        if (this.storage.containsKey(sectionName) && this.storage.get(sectionName).containsKey(itemName)) {
            return this.storage.get(sectionName).get(itemName);
        }
        return new JsonPrimitive(itemName);
    }

    public void copy(PresetsStorage dest) {
        this.storage.entrySet().stream().forEach(ensm -> {
            String section = (String)ensm.getKey();
            ((Map)ensm.getValue()).entrySet().forEach(ensje -> dest.setSymbolSection(section, (String)ensje.getKey(), (JsonElement)ensje.getValue()));
        });
    }

    public void clear() {
        this.storage.clear();
    }

    public void load(Path inputFile) {
        JsonParser p = new JsonParser();
        JsonElement parsed = null;
        try (BufferedReader r = Files.newBufferedReader(inputFile);){
            parsed = p.parse((Reader)r);
        }
        catch (IOException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading presets from" + inputFile.toString()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
        catch (JsonIOException | JsonSyntaxException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("JSON Parsing Error in " + inputFile.toString()));
            report.func_85056_g().func_71507_a(ORE_SPAWN_VERSION, (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
        if (parsed != null) {
            parsed.getAsJsonObject().entrySet().stream().forEach(entry -> {
                String section = (String)entry.getKey();
                ((JsonElement)entry.getValue()).getAsJsonObject().entrySet().stream().forEach(sect -> this.setSymbolSection(section, (String)sect.getKey(), (JsonElement)sect.getValue()));
            });
        }
    }

    public JsonElement get(String asString) {
        Pattern p = Pattern.compile("\\$\\.(\\w+)\\.(\\w+)");
        Matcher m = p.matcher(asString);
        if (m.matches()) {
            return this.getSymbolSection(m.group(1), m.group(2));
        }
        return new JsonPrimitive("Unknown Variable " + asString);
    }
}

