/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.crash.CrashReport;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.FileUtils;

public class Config {
    private static Configuration configuration;
    private static final HashMap<String, Boolean> boolVals;
    private static final HashMap<String, String> stringVals;
    private static final HashMap<String, Integer> intVals;
    private static final HashMap<String, Float> floatVals;
    private static final List<String> knownKeys;
    private static final List<String> extractedConfigs;

    private Config() {
    }

    public static void loadConfig() {
        configuration = new Configuration(new File("config/orespawn.cfg"));
        boolVals.put("Retrogen", configuration.getBoolean("Retrogen", "general", false, "Do we have Retrogen active and generating anything different from the last run in already existing chunks ?"));
        boolVals.put("Force Retrogen", configuration.getBoolean("Force Retrogen", "general", false, "Force all chunks to retrogen regardless of anything else"));
        boolVals.put("Replace Vanilla Oregen", configuration.getBoolean("Replace Vanilla Oregen", "general", false, "Replace vanilla ore-generation entirely"));
        boolVals.put("Flatten Bedrock", configuration.getBoolean("Flatten Bedrock", "general", false, "Flatten the bedrock during world generation"));
        boolVals.put("Retrogen Flat Bedrock", configuration.getBoolean("Retrogen Flat Bedrock", "general", false, "Retroactively flatten bedrock"));
        intVals.put("Bedrock Thickness", configuration.getInt("Bedrock Thickness", "general", 1, 1, 4, "How thick should the shell of bedrock be?"));
        knownKeys.add("Retrogen");
        knownKeys.add("Force Retrogen");
        knownKeys.add("Replace Vanilla Oregen");
        knownKeys.add("already-extracted");
        knownKeys.add("Flatten Bedrock");
        knownKeys.add("Retrogen Flat Bedrock");
        knownKeys.add("Bedrock Thickness");
        Config.loadExtractedConfigs();
    }

    private static void loadExtractedConfigs() {
        String rawData;
        Path p = FileSystems.getDefault().getPath("config", "orespawn3", "sysconf", "known-configs.json");
        if (!p.toFile().exists()) {
            return;
        }
        File in = p.toFile();
        try {
            rawData = FileUtils.readFileToString((File)in, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            return;
        }
        if (rawData.isEmpty()) {
            return;
        }
        JsonArray data = new JsonParser().parse(rawData).getAsJsonArray();
        data.forEach(item -> Config.addKnownMod(item.getAsString()));
    }

    public static List<String> getKnownMods() {
        return ImmutableList.copyOf(extractedConfigs);
    }

    public static void addKnownMod(String modId) {
        extractedConfigs.add(modId);
    }

    public static boolean getBoolean(String keyname) {
        if (knownKeys.contains(keyname) && boolVals.containsKey(keyname)) {
            return boolVals.get(keyname);
        }
        return false;
    }

    public static String getString(String keyname) {
        if (knownKeys.contains(keyname) && stringVals.containsKey(keyname)) {
            return stringVals.get(keyname);
        }
        return "";
    }

    public static int getInt(String keyname) {
        if (knownKeys.contains(keyname) && intVals.containsKey(keyname)) {
            return intVals.get(keyname);
        }
        return 0;
    }

    public static float getFloat(String keyname) {
        if (knownKeys.contains(keyname) && floatVals.containsKey(keyname)) {
            return floatVals.get(keyname).floatValue();
        }
        return 0.0f;
    }

    public static void saveConfig() {
        if (!extractedConfigs.isEmpty()) {
            Config.saveKnownConfigs();
        }
        configuration.save();
    }

    private static void saveKnownConfigs() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path p = FileSystems.getDefault().getPath("config", "orespawn3", "sysconf", "known-configs.json");
        if (!p.toFile().getParentFile().exists()) {
            p.toFile().mkdirs();
        }
        File in = p.toFile();
        JsonArray data = new JsonArray();
        extractedConfigs.forEach(arg_0 -> ((JsonArray)data).add(arg_0));
        try {
            FileUtils.writeStringToFile((File)in, (String)gson.toJson((JsonElement)data), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)"Failed saving list of already extracted mod configs");
            report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.3.1");
            OreSpawn.LOGGER.info(report.func_71502_e());
        }
    }

    static {
        boolVals = new HashMap();
        stringVals = new HashMap();
        intVals = new HashMap();
        floatVals = new HashMap();
        knownKeys = new ArrayList<String>();
        extractedConfigs = new ArrayList<String>();
    }
}

