/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.os3.ISpawnEntry;
import com.mcmoddev.orespawn.data.Config;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EventHandlers {
    private final Deque<ChunkPos> retroChunks;
    private final Deque<Tuple<ChunkPos, List<String>>> chunks;
    private final List<OreGenEvent.GenerateMinable.EventType> vanillaEvents = Arrays.asList(OreGenEvent.GenerateMinable.EventType.ANDESITE, OreGenEvent.GenerateMinable.EventType.COAL, OreGenEvent.GenerateMinable.EventType.DIAMOND, OreGenEvent.GenerateMinable.EventType.DIORITE, OreGenEvent.GenerateMinable.EventType.DIRT, OreGenEvent.GenerateMinable.EventType.EMERALD, OreGenEvent.GenerateMinable.EventType.GOLD, OreGenEvent.GenerateMinable.EventType.GRANITE, OreGenEvent.GenerateMinable.EventType.GRAVEL, OreGenEvent.GenerateMinable.EventType.IRON, OreGenEvent.GenerateMinable.EventType.LAPIS, OreGenEvent.GenerateMinable.EventType.REDSTONE, OreGenEvent.GenerateMinable.EventType.QUARTZ, OreGenEvent.GenerateMinable.EventType.SILVERFISH);
    private static World world;
    private static ChunkProviderServer chunkProvider;
    private static IChunkGenerator chunkGenerator;
    private static Random random;

    EventHandlers() {
        this.retroChunks = new ConcurrentLinkedDeque<ChunkPos>();
        this.chunks = new ConcurrentLinkedDeque<Tuple<ChunkPos, List<String>>>();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        if (Config.getBoolean("Replace Vanilla Oregen") && this.vanillaEvents.contains(event.getType())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save ev) {
        NBTTagCompound dataTag = ev.getData().func_74775_l("MMD OreSpawn Data");
        NBTTagCompound features = new NBTTagCompound();
        int thisDimension = ev.getWorld().field_73011_w.getDimension();
        BlockPos thisPos = new BlockPos(ev.getChunk().field_76635_g + 8, 128, ev.getChunk().field_76647_h + 8);
        Biome thisBiome = ev.getChunk().func_177411_a(thisPos, ev.getWorld().func_72959_q());
        OreSpawn.API.getAllSpawns().entrySet().stream().filter(ent -> ((ISpawnEntry)ent.getValue()).dimensionAllowed(thisDimension)).filter(ent -> ((ISpawnEntry)ent.getValue()).biomeAllowed(thisBiome)).forEach(ent -> features.func_74778_a((String)ent.getKey(), ((ISpawnEntry)ent.getValue()).getFeature().getFeatureName()));
        dataTag.func_74782_a("features", (NBTBase)features);
        ev.getData().func_74782_a("MMD OreSpawn Data", (NBTBase)dataTag);
    }

    private boolean dequeContains(ChunkPos cc) {
        return this.chunks.stream().map(tup -> ((ChunkPos)tup.func_76341_a()).equals((Object)cc)).collect(Collectors.toList()).contains(true);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load ev) {
        World clWorld = ev.getWorld();
        ChunkPos chunkCoords = new ChunkPos(ev.getChunk().field_76635_g, ev.getChunk().field_76647_h);
        this.doBedrockRetrogen(chunkCoords);
        if (this.dequeContains(chunkCoords)) {
            return;
        }
        if (Config.getBoolean("Retrogen")) {
            NBTTagCompound chunkTag = ev.getData().func_74775_l("MMD OreSpawn Data");
            int thisDimension = clWorld.field_73011_w.getDimension();
            BlockPos thisPos = new BlockPos(ev.getChunk().field_76635_g + 8, 128, ev.getChunk().field_76647_h + 8);
            Biome thisBiome = ev.getChunk().func_177411_a(thisPos, clWorld.func_72959_q());
            if (this.featuresAreDifferent(chunkTag, thisDimension, thisBiome) || Config.getBoolean("Force Retrogen")) {
                this.chunks.addLast((Tuple<ChunkPos, List<String>>)new Tuple((Object)chunkCoords, this.getDifferingTags(chunkTag, thisDimension, thisBiome)));
            }
        }
    }

    private List<String> getDifferingTags(NBTTagCompound chunkTag, int dim, Biome biome) {
        NBTTagCompound tagList = chunkTag.func_74775_l("features");
        TreeMap currentBits = new TreeMap();
        TreeMap oldBits = new TreeMap();
        OreSpawn.API.getAllSpawns().entrySet().stream().filter(ent -> ((ISpawnEntry)ent.getValue()).dimensionAllowed(dim)).filter(ent -> ((ISpawnEntry)ent.getValue()).biomeAllowed(biome)).forEach(ent -> currentBits.put(ent.getKey(), ((ISpawnEntry)ent.getValue()).getFeature().getFeatureName()));
        tagList.func_150296_c().stream().forEach(tag -> oldBits.put(tag, tagList.func_74779_i(tag)));
        MapDifference diff = Maps.difference(oldBits, currentBits);
        LinkedList stuff = Lists.newLinkedList();
        stuff.addAll(diff.entriesDiffering().entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        stuff.addAll(diff.entriesOnlyOnRight().entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        return ImmutableList.copyOf((Collection)stuff);
    }

    private boolean featuresAreDifferent(NBTTagCompound chunkTag, int dim, Biome biome) {
        NBTTagCompound tagList = chunkTag.func_74775_l("features");
        TreeMap currentBits = new TreeMap();
        TreeMap oldBits = new TreeMap();
        OreSpawn.API.getAllSpawns().entrySet().stream().filter(ent -> ((ISpawnEntry)ent.getValue()).dimensionAllowed(dim)).filter(ent -> ((ISpawnEntry)ent.getValue()).biomeAllowed(biome)).forEach(ent -> currentBits.put(ent.getKey(), ((ISpawnEntry)ent.getValue()).getFeature().getFeatureName()));
        tagList.func_150296_c().stream().forEach(tag -> oldBits.put(tag, tagList.func_74779_i(tag)));
        MapDifference diff = Maps.difference(oldBits, currentBits);
        return diff.entriesDiffering().size() == 0 && diff.entriesOnlyOnLeft().size() == 0 && diff.entriesOnlyOnRight().size() == 0;
    }

    private void doBedrockRetrogen(ChunkPos chunkCoords) {
        if (this.retroChunks.contains(chunkCoords)) {
            return;
        }
        if (Config.getBoolean("Retrogen Flat Bedrock")) {
            this.retroChunks.addLast(chunkCoords);
        }
    }

    private static void setupData(World nw) {
        if (world == null || !world.equals(nw)) {
            world = nw;
        }
        if (chunkProvider == null || !chunkProvider.equals(nw.func_72863_F())) {
            chunkProvider = (ChunkProviderServer)nw.func_72863_F();
        }
        if (chunkGenerator == null) {
            chunkGenerator = (IChunkGenerator)ObfuscationReflectionHelper.getPrivateValue(ChunkProviderServer.class, (Object)chunkProvider, (String[])new String[]{"field_186029_c", "chunkGenerator"});
        }
        if (random == null) {
            random = new Random(world.func_72905_C());
        }
    }

    private void runBits(Tuple<ChunkPos, List<String>> tup, World world) {
        ChunkPos p = (ChunkPos)tup.func_76341_a();
        List spawns = (List)tup.func_76340_b();
        if (!world.func_175667_e(new BlockPos(p.func_180334_c(), 128, p.func_180333_d()))) {
            this.chunks.add(tup);
            return;
        }
        random.setSeed((random.nextLong() >> 5) + (long)p.field_77276_a + ((random.nextLong() >> 3) + (long)p.field_77275_b) ^ world.func_72905_C());
        spawns.stream().forEach(s -> OreSpawn.API.getSpawn((String)s).generate(random, world, chunkGenerator, (IChunkProvider)chunkProvider, p));
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent ev) {
        EventHandlers.setupData(ev.world);
        if (ev.side != Side.SERVER) {
            return;
        }
        if (ev.phase == TickEvent.Phase.END) {
            int c;
            int chunkCount = this.chunks.size();
            for (c = 0; c < 25 && !this.chunks.isEmpty(); ++c) {
                Tuple<ChunkPos, List<String>> pp = this.chunks.pop();
                if (ev.world.func_175667_e(new BlockPos(((ChunkPos)pp.func_76341_a()).func_180334_c(), 128, ((ChunkPos)pp.func_76341_a()).func_180333_d()))) {
                    this.runBits(pp, ev.world);
                } else {
                    this.chunks.add(pp);
                    --c;
                }
                if (--chunkCount <= 0) break;
            }
            chunkCount = this.retroChunks.size();
            for (c = 0; c < 25 && !this.retroChunks.isEmpty(); ++c) {
                ChunkPos p = this.retroChunks.pop();
                if (ev.world.func_175667_e(new BlockPos(p.func_180334_c(), 128, p.func_180333_d()))) {
                    OreSpawn.flatBedrock.retrogen(world, p.field_77276_a, p.field_77275_b);
                } else {
                    --c;
                    this.retroChunks.add(p);
                }
                if (--chunkCount <= 0) break;
            }
        }
    }
}

