/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.network;

import io.netty.buffer.ByteBuf;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.common.util.network.IBinaryMessageReceiver;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BinaryMessageTileSync
implements IMessage {
    BlockPos pos;
    ByteBuf buffer;

    public static void sendToAllTracking(World world, BlockPos pos, ByteBuf buf) {
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new BinaryMessageTileSync(pos, buf), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0));
    }

    public BinaryMessageTileSync(BlockPos tile, ByteBuf buffer) {
        this.pos = tile;
        this.buffer = buffer;
    }

    public BinaryMessageTileSync() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.buffer = buf.readBytes(buf.readableBytes());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n()).writeInt(this.pos.func_177956_o()).writeInt(this.pos.func_177952_p());
        buf.writeBytes(this.buffer);
    }

    @SideOnly(value=Side.CLIENT)
    public static class HandlerClient
    implements IMessageHandler<BinaryMessageTileSync, IMessage> {
        public IMessage onMessage(BinaryMessageTileSync message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                TileEntity tile;
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world != null && (tile = world.func_175625_s(message.pos)) instanceof IBinaryMessageReceiver) {
                    ((IBinaryMessageReceiver)tile).receiveMessageFromServer(message.buffer);
                }
            });
            return null;
        }
    }

    public static class HandlerServer
    implements IMessageHandler<BinaryMessageTileSync, IMessage> {
        public IMessage onMessage(BinaryMessageTileSync message, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            world.func_152344_a(() -> {
                TileEntity tile;
                if (world.func_175667_e(message.pos) && (tile = world.func_175625_s(message.pos)) instanceof IBinaryMessageReceiver) {
                    ((IBinaryMessageReceiver)tile).receiveMessageFromClient(message.buffer);
                }
            });
            return null;
        }
    }
}

