/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.top;

import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityBoilerMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityBoilerSlave;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityGasTurbineMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityGasTurbineSlave;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySteamTurbineMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySteamTurbineSlave;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySteelSheetmetalTankMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySteelSheetmetalTankSlave;
import mctmods.immersivetechnology.common.util.compat.ITCompatModule;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class OneProbeHelper
extends ITCompatModule
implements Function<ITheOneProbe, Void> {
    private static int maxSpeed = Config.ITConfig.MechanicalEnergy.mechanicalEnergy_speed_max;
    private static double workingHeatLevel = Config.ITConfig.Machines.Boiler.boiler_heat_workingLevel;

    @Override
    public void preInit() {
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)this.getClass().getName());
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
    }

    @Override
    @Nullable
    public Void apply(@Nullable ITheOneProbe input) {
        input.registerProvider((IProbeInfoProvider)new MechanicalEnergyProvider());
        input.registerProvider((IProbeInfoProvider)new MiscProvider());
        input.registerProvider((IProbeInfoProvider)new FluidInfoProvider());
        return null;
    }

    public static class FluidInfoProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "immersivetech:FluidInfo";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof TileEntitySteelSheetmetalTankSlave) {
                TileEntitySteelSheetmetalTankMaster master = ((TileEntitySteelSheetmetalTankSlave)te).master();
                int current = ((TileEntitySteelSheetmetalTankSlave)master).master().tank.getFluidAmount();
                int max = ((TileEntitySteelSheetmetalTankSlave)master).master().tank.getCapacity();
                if (current > 0) {
                    probeInfo.progress(current, max, probeInfo.defaultProgressStyle().suffix("mB").numberFormat(NumberFormat.COMPACT));
                }
            } else if (te instanceof TileEntitySteamTurbineSlave) {
                TileEntitySteamTurbineMaster master = ((TileEntitySteamTurbineSlave)te).master();
                int current = ((TileEntitySteamTurbineSlave)master).master().tanks[0].getFluidAmount();
                int max = ((TileEntitySteamTurbineSlave)master).master().tanks[0].getCapacity();
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(11)).text("Fuel").progress(current, max, probeInfo.defaultProgressStyle().numberFormat(NumberFormat.FULL).suffix("mB"));
            } else if (te instanceof TileEntityGasTurbineSlave) {
                TileEntityGasTurbineMaster master = ((TileEntityGasTurbineSlave)te).master();
                int current = ((TileEntityGasTurbineSlave)master).master().tanks[0].getFluidAmount();
                int max = ((TileEntityGasTurbineSlave)master).master().tanks[0].getCapacity();
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(11)).text("Fuel").progress(current, max, probeInfo.defaultProgressStyle().numberFormat(NumberFormat.FULL).suffix("mB"));
            }
        }
    }

    public static class MechanicalEnergyProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "immersivetech:MechanicalEnergyInfo";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof ITBlockInterfaces.IMechanicalEnergy) {
                TileEntityMultiblockPart master = ((TileEntityMultiblockPart)te).master();
                if (master == null) {
                    return;
                }
                int current = ((ITBlockInterfaces.IMechanicalEnergy)master).getSpeed();
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(2)).text("Speed").progress(current, maxSpeed, probeInfo.defaultProgressStyle().numberFormat(NumberFormat.FULL).suffix("RPM"));
            }
        }
    }

    public static class MiscProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "immersivetech:MiscInfo";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof TileEntityBoilerSlave) {
                TileEntityBoilerMaster master = ((TileEntityBoilerSlave)te).master();
                if (master == null) {
                    return;
                }
                int current = (int)(master.heatLevel / workingHeatLevel * 100.0);
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(2)).text("Heat Level").progress(current, 100, probeInfo.defaultProgressStyle().numberFormat(NumberFormat.FULL).suffix("%"));
            }
        }
    }
}

