/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.jei.gasturbine;

import java.util.List;
import mctmods.immersivetechnology.api.crafting.GasTurbineRecipe;
import mctmods.immersivetechnology.common.util.compat.jei.GenericMultiblockIngredient;
import mctmods.immersivetechnology.common.util.compat.jei.ITRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.JEIHelper;
import mctmods.immersivetechnology.common.util.compat.jei.gasturbine.GasTurbineRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GasTurbineRecipeCategory
extends ITRecipeCategory<GasTurbineRecipe, GasTurbineRecipeWrapper> {
    public static ResourceLocation background = new ResourceLocation("immersivetech:textures/gui/gui_steam_turbine.png");
    private final IDrawable tankOverlay;
    private final IDrawableAnimated turbineAndArrow;

    public GasTurbineRecipeCategory(IGuiHelper helper) {
        super("gasTurbine", "tile.immersivetech.metal_multiblock1.gas_turbine.name", (IDrawable)helper.createDrawable(background, 0, 0, 116, 69), GasTurbineRecipe.class, GenericMultiblockIngredient.GAS_TURBINE);
        this.tankOverlay = helper.createDrawable(background, 118, 2, 16, 47, -2, 2, -2, 2);
        IDrawableStatic staticImage = helper.createDrawable(background, 0, 78, 32, 42);
        this.turbineAndArrow = helper.createAnimatedDrawable(staticImage, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayout recipeLayout, GasTurbineRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(FluidStack.class);
        List outputs = ingredients.getOutputs(FluidStack.class);
        int tankSize = 0;
        for (List lists : inputs) {
            for (FluidStack fluid : lists) {
                if (fluid.amount <= tankSize) continue;
                tankSize = fluid.amount;
            }
        }
        for (List lists : outputs) {
            for (FluidStack fluid : lists) {
                if (fluid.amount <= tankSize) continue;
                tankSize = fluid.amount;
            }
        }
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiFluidStacks.init(0, true, 11, 11, 16, 47, tankSize, true, this.tankOverlay);
        guiFluidStacks.set(0, (List)inputs.get(0));
        if (!outputs.isEmpty()) {
            guiFluidStacks.init(1, false, 89, 11, 16, 47, tankSize, true, this.tankOverlay);
            guiFluidStacks.set(1, (List)outputs.get(0));
        }
        guiFluidStacks.addTooltipCallback(JEIHelper.fluidTooltipCallback);
    }

    public IRecipeWrapper getRecipeWrapper(GasTurbineRecipe recipe) {
        return new GasTurbineRecipeWrapper(recipe);
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        this.turbineAndArrow.draw(minecraft, 42, 18);
    }
}

