/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.jei.distiller;

import java.util.List;
import mctmods.immersivetechnology.api.crafting.DistillerRecipe;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.common.util.compat.jei.GenericMultiblockIngredient;
import mctmods.immersivetechnology.common.util.compat.jei.ITRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.JEIHelper;
import mctmods.immersivetechnology.common.util.compat.jei.distiller.DistillerRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class DistillerRecipeCategory
extends ITRecipeCategory<DistillerRecipe, DistillerRecipeWrapper> {
    public static ResourceLocation background = new ResourceLocation("immersivetech:textures/gui/gui_distiller.png");
    private final IDrawable tankOverlay;

    public DistillerRecipeCategory(IGuiHelper helper) {
        super("distiller", "tile.immersivetech.metal_multiblock.distiller.name", (IDrawable)helper.createDrawable(background, 0, 166, 176, 77), DistillerRecipe.class, GenericMultiblockIngredient.DISTILLER);
        this.tankOverlay = helper.createDrawable(background, 177, 31, 16, 47, -2, 2, -2, 2);
    }

    public void setRecipe(IRecipeLayout recipeLayout, DistillerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(FluidStack.class);
        List outputs = ingredients.getOutputs(FluidStack.class);
        int tankSize = 0;
        for (List lists : inputs) {
            for (FluidStack fluid : lists) {
                if (fluid.amount <= tankSize) continue;
                tankSize = fluid.amount;
            }
        }
        for (List lists : outputs) {
            for (FluidStack fluid : lists) {
                if (fluid.amount <= tankSize) continue;
                tankSize = fluid.amount;
            }
        }
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (inputs.size() > 0) {
            guiFluidStacks.init(0, true, 58, 21, 16, 47, tankSize, false, this.tankOverlay);
            guiFluidStacks.set(0, (List)inputs.get(0));
        }
        guiFluidStacks.init(1, false, 112, 21, 16, 47, tankSize, false, this.tankOverlay);
        guiFluidStacks.set(1, (List)outputs.get(0));
        guiFluidStacks.addTooltipCallback(JEIHelper.fluidTooltipCallback);
        ItemStack itemOutput = recipeWrapper.recipe.itemOutput;
        if (!itemOutput.func_190926_b()) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            guiItemStacks.init(0, false, 133, 52);
            guiItemStacks.set(0, itemOutput);
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> tooltip.add(TranslationKey.CATEGORY_DISTILLER_CHANCE.format(Float.valueOf(recipeWrapper.recipe.chance * 100.0f)) + "%"));
        }
    }

    public IRecipeWrapper getRecipeWrapper(DistillerRecipe recipe) {
        return new DistillerRecipeWrapper(recipe);
    }
}

