/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.jei;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import mctmods.immersivetechnology.api.crafting.BoilerRecipe;
import mctmods.immersivetechnology.api.crafting.CoolingTowerRecipe;
import mctmods.immersivetechnology.api.crafting.DistillerRecipe;
import mctmods.immersivetechnology.api.crafting.GasTurbineRecipe;
import mctmods.immersivetechnology.api.crafting.SolarTowerRecipe;
import mctmods.immersivetechnology.api.crafting.SteamTurbineRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.ITContent;
import mctmods.immersivetechnology.common.util.compat.ITCompatModule;
import mctmods.immersivetechnology.common.util.compat.jei.GenericMultiblockHelper;
import mctmods.immersivetechnology.common.util.compat.jei.GenericMultiblockIngredient;
import mctmods.immersivetechnology.common.util.compat.jei.GenericMultiblockRenderer;
import mctmods.immersivetechnology.common.util.compat.jei.ITFluidTooltipCallback;
import mctmods.immersivetechnology.common.util.compat.jei.ITRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.boiler.BoilerFuelRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.boiler.BoilerRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.coolingtower.CoolingTowerRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.distiller.DistillerRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.gasturbine.GasTurbineRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.solartower.SolarTowerRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.steamturbine.SteamTurbineRecipeCategory;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@JEIPlugin
public class JEIHelper
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IModRegistry modRegistry;
    public static IDrawable slotDrawable;
    public static ITooltipCallback<FluidStack> fluidTooltipCallback;
    Map<Class, ITRecipeCategory> categories = new LinkedHashMap<Class, ITRecipeCategory>();

    public void registerIngredients(IModIngredientRegistration registry) {
        registry.register(GenericMultiblockIngredient.class, GenericMultiblockIngredient.list, (IIngredientHelper)new GenericMultiblockHelper(), (IIngredientRenderer)new GenericMultiblockRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        slotDrawable = guiHelper.getSlotDrawable();
        if (Config.ITConfig.Machines.Multiblock.enable_distiller) {
            this.categories.put(DistillerRecipe.class, new DistillerRecipeCategory(guiHelper));
        }
        if (Config.ITConfig.Machines.Multiblock.enable_boiler) {
            this.categories.put(BoilerRecipe.class, new BoilerRecipeCategory(guiHelper));
            this.categories.put(BoilerRecipe.BoilerFuelRecipe.class, new BoilerFuelRecipeCategory(guiHelper));
        }
        if (Config.ITConfig.Machines.Multiblock.enable_solarTower) {
            this.categories.put(SolarTowerRecipe.class, new SolarTowerRecipeCategory(guiHelper));
        }
        if (Config.ITConfig.Machines.Multiblock.enable_steamTurbine) {
            this.categories.put(SteamTurbineRecipe.class, new SteamTurbineRecipeCategory(guiHelper));
        }
        if (Config.ITConfig.Machines.Multiblock.enable_coolingTower) {
            this.categories.put(CoolingTowerRecipe.class, new CoolingTowerRecipeCategory(guiHelper));
        }
        if (Config.ITConfig.Machines.Multiblock.enable_gasTurbine) {
            this.categories.put(GasTurbineRecipe.class, new GasTurbineRecipeCategory(guiHelper));
        }
        registry.addRecipeCategories(this.categories.values().toArray(new IRecipeCategory[this.categories.size()]));
    }

    public void register(IModRegistry registryIn) {
        modRegistry = registryIn;
        if (Config.ITConfig.Experimental.replace_IE_pipes) {
            registryIn.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ITContent.blockMetalDevice0Dummy, 1, 0));
            registryIn.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack(ITContent.blockMetalDevice1Dummy, 1, 0));
        }
        for (ITRecipeCategory cat : this.categories.values()) {
            cat.addCatalysts(registryIn);
            modRegistry.handleRecipes(cat.getRecipeClass(), (IRecipeWrapperFactory)cat, cat.getRecipeCategoryUid());
        }
        if (Config.ITConfig.Machines.Multiblock.enable_advancedCokeOven) {
            modRegistry.addRecipeCatalyst((Object)GenericMultiblockIngredient.COKE_OVEN_ADVANCED, new String[]{"ie.cokeoven"});
        }
        if (Config.ITConfig.Machines.Multiblock.enable_distiller) {
            modRegistry.addRecipes(new ArrayList<DistillerRecipe>(DistillerRecipe.recipeList), "it.distiller");
        }
        if (Config.ITConfig.Machines.Multiblock.enable_boiler) {
            modRegistry.addRecipes(new ArrayList<BoilerRecipe>(BoilerRecipe.recipeList), "it.boiler");
            modRegistry.addRecipes(new ArrayList<BoilerRecipe.BoilerFuelRecipe>(BoilerRecipe.fuelList), "it.boilerFuel");
        }
        if (Config.ITConfig.Machines.Multiblock.enable_solarTower) {
            modRegistry.addRecipes(new ArrayList<SolarTowerRecipe>(SolarTowerRecipe.recipeList), "it.solarTower");
        }
        if (Config.ITConfig.Machines.Multiblock.enable_steamTurbine) {
            modRegistry.addRecipes(new ArrayList<SteamTurbineRecipe>(SteamTurbineRecipe.recipeList), "it.steamTurbine");
        }
        if (Config.ITConfig.Machines.Multiblock.enable_coolingTower) {
            modRegistry.addRecipes(new ArrayList<CoolingTowerRecipe>(CoolingTowerRecipe.recipeList), "it.coolingTower");
        }
        if (Config.ITConfig.Machines.Multiblock.enable_gasTurbine) {
            modRegistry.addRecipes(new ArrayList<GasTurbineRecipe>(GasTurbineRecipe.recipeList), "it.gasTurbine");
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeRegistry registry = jeiRuntime.getRecipeRegistry();
        ITCompatModule.jeiAddFunc = recipe -> {
            ITRecipeCategory<Object, ?> factory = this.getFactory(recipe.getClass());
            if (factory != null) {
                registry.addRecipe(factory.getRecipeWrapper(recipe), factory.getUid());
            }
        };
        ITCompatModule.jeiRemoveFunc = recipe -> {
            ITRecipeCategory<Object, ?> factory = this.getFactory(recipe.getClass());
            if (factory != null) {
                registry.removeRecipe(factory.getRecipeWrapper(recipe), factory.getUid());
            }
        };
    }

    private ITRecipeCategory<Object, ?> getFactory(Class<?> recipeClass) {
        ITRecipeCategory<Object, ?> factory = this.categories.get(recipeClass);
        if (factory == null && recipeClass != Object.class) {
            factory = this.getFactory(recipeClass.getSuperclass());
        }
        return factory;
    }

    static {
        fluidTooltipCallback = new ITFluidTooltipCallback();
    }
}

