/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import mctmods.immersivetechnology.common.ITContent;
import mctmods.immersivetechnology.common.util.compat.crafttweaker.CraftTweakerHelper;
import net.minecraftforge.fluids.Fluid;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersivetechnology.PressurizedFluid")
public class PressurizedFluid {
    @ZenMethod
    public static void add(ILiquidStack fluid) {
        Fluid actualFluid = CraftTweakerHelper.toFluidStack(fluid).getFluid();
        if (ITContent.normallyPressurized.contains(actualFluid)) {
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(actualFluid));
    }

    @ZenMethod
    public static void remove(ILiquidStack fluid) {
        Fluid actualFluid = CraftTweakerHelper.toFluidStack(fluid).getFluid();
        if (!ITContent.normallyPressurized.contains(actualFluid)) {
            return;
        }
        CraftTweakerAPI.apply((IAction)new Remove(actualFluid));
    }

    private static class Remove
    implements IAction {
        public Fluid fluid;

        public Remove(Fluid fluid) {
            this.fluid = fluid;
        }

        public void apply() {
            ITContent.normallyPressurized.remove(this.fluid);
        }

        public String describe() {
            return "Removing Naturally Pressurized Fluid " + this.fluid.getName();
        }
    }

    private static class Add
    implements IAction {
        public Fluid fluid;

        public Add(Fluid fluid) {
            this.fluid = fluid;
        }

        public void apply() {
            ITContent.normallyPressurized.add(this.fluid);
        }

        public String describe() {
            return "Adding Naturally Pressurized Fluid " + this.fluid.getName();
        }
    }
}

