/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Iterator;
import mctmods.immersivetechnology.api.crafting.DistillerRecipe;
import mctmods.immersivetechnology.common.util.compat.crafttweaker.CraftTweakerHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersivetechnology.Distiller")
public class Distiller {
    @ZenMethod
    public static void addRecipe(ILiquidStack outputFluid, ILiquidStack inputFluid, IItemStack outputItem, Integer energy, Integer time, Float chance) {
        FluidStack fluidOut = CraftTweakerHelper.toFluidStack(outputFluid);
        FluidStack fluidIn = CraftTweakerHelper.toFluidStack(inputFluid);
        ItemStack itemOut = CraftTweakerHelper.toStack(outputItem);
        if (fluidIn == null || fluidOut == null || itemOut.func_190926_b()) {
            return;
        }
        if (energy == null) {
            energy = 10000;
        }
        if (time == null) {
            time = 20;
        }
        if (chance == null) {
            chance = Float.valueOf(0.01f);
        }
        DistillerRecipe recipe = new DistillerRecipe(fluidOut, fluidIn, itemOut, energy, time, chance.floatValue());
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack outputFluid, ILiquidStack inputFluid, IItemStack outputItem) {
        FluidStack fluidOut = CraftTweakerHelper.toFluidStack(outputFluid);
        FluidStack fluidIn = CraftTweakerHelper.toFluidStack(inputFluid);
        ItemStack itemOut = CraftTweakerHelper.toStack(outputItem);
        if (fluidIn == null || fluidOut == null || itemOut.func_190926_b()) {
            return;
        }
        int energy = 10000;
        int time = 20;
        float chance = 0.01f;
        DistillerRecipe recipe = new DistillerRecipe(fluidOut, fluidIn, itemOut, energy, time, chance);
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack inputFluid, @Optional IItemStack outputItem) {
        if (CraftTweakerHelper.toFluidStack(inputFluid) != null) {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toFluidStack(inputFluid), CraftTweakerHelper.toStack(outputItem)));
        }
    }

    private static class Remove
    implements IAction {
        private final FluidStack inputFluid;
        private final ItemStack outputItem;
        ArrayList<DistillerRecipe> removedRecipes = new ArrayList();

        public Remove(FluidStack inputFluid, ItemStack outputItem) {
            this.inputFluid = inputFluid;
            this.outputItem = outputItem;
        }

        public void apply() {
            Iterator<DistillerRecipe> iterator = DistillerRecipe.recipeList.iterator();
            while (iterator.hasNext()) {
                DistillerRecipe recipe = iterator.next();
                if (recipe == null || !recipe.fluidInput.isFluidEqual(this.inputFluid)) continue;
                this.removedRecipes.add(recipe);
                iterator.remove();
            }
        }

        public String describe() {
            if (this.outputItem.func_77973_b() == Items.field_190931_a) {
                return "Removing Distiller Input Recipe for " + this.inputFluid.getLocalizedName();
            }
            return "Removing Distiller Input Recipe for " + this.inputFluid.getLocalizedName() + " -> " + this.outputItem.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        public DistillerRecipe recipe;

        public Add(DistillerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            DistillerRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Distiller Recipe for " + this.recipe.fluidInput.getLocalizedName() + " -> " + this.recipe.fluidOutput.getLocalizedName();
        }
    }
}

