/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.tileentities;

import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.client.gui.GuiStackLimiter;
import mctmods.immersivetechnology.common.tileentities.TileEntityCommonValve;
import mctmods.immersivetechnology.common.util.TranslationKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityStackLimiter
extends TileEntityCommonValve
implements IItemHandler {
    public static final DummyInventory dummyInventory = new DummyInventory();
    boolean busy = false;

    public TileEntityStackLimiter() {
        super(TranslationKey.OVERLAY_OSD_STACK_LIMITER_NORMAL_FIRST_LINE, TranslationKey.OVERLAY_OSD_STACK_LIMITER_SNEAKING_FIRST_LINE, TranslationKey.OVERLAY_OSD_STACK_LIMITER_SNEAKING_SECOND_LINE, 8);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void showGui() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStackLimiter(this));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing.func_176740_k() == this.facing.func_176740_k();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == this.facing) {
                return (T)((Object)this);
            }
            if (facing == this.facing.func_176734_d()) {
                return (T)dummyInventory;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getDestination() {
        TileEntity dst = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177967_a(this.facing, -1));
        if (dst != null && dst.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.facing)) {
            return (IItemHandler)dst.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.facing);
        }
        return null;
    }

    public int getSlots() {
        IItemHandler dest = this.getDestination();
        if (dest == null) {
            return 0;
        }
        return dest.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int i) {
        IItemHandler dest = this.getDestination();
        if (dest == null) {
            return ItemStack.field_190927_a;
        }
        return dest.getStackInSlot(i);
    }

    @Nonnull
    public ItemStack insertItem(int i, @Nonnull ItemStack itemStack, boolean simulate) {
        if (this.busy) {
            return itemStack;
        }
        IItemHandler destination = this.getDestination();
        if (destination == null) {
            return itemStack;
        }
        int canAccept = itemStack.func_190916_E();
        canAccept = this.timeLimit != -1 ? Math.min(Math.max(this.timeLimit - TileEntityStackLimiter.longToInt(this.acceptedAmount), 0), canAccept) : canAccept;
        canAccept = this.keepSize != -1 ? Math.min(Math.max(this.keepSize - this.getInventoryFill(destination, itemStack), 0), canAccept) : canAccept;
        int n = canAccept = this.packetLimit != -1 ? Math.min(canAccept, this.packetLimit) : canAccept;
        if (this.redstoneMode > 0) {
            canAccept = (int)((double)canAccept * ((double)(this.redstoneMode == 1 ? 15 - this.getRSPower() : this.getRSPower()) / 15.0));
        }
        if (canAccept == 0) {
            return itemStack;
        }
        ItemStack toReturn = itemStack.func_77946_l();
        toReturn.func_190920_e(canAccept);
        this.busy = true;
        ItemStack inserted = destination.insertItem(i, toReturn, simulate);
        this.busy = false;
        if (!simulate) {
            this.acceptedAmount += inserted == ItemStack.field_190927_a ? (long)canAccept : (long)(canAccept - inserted.func_190916_E());
            ++this.packets;
        }
        toReturn.func_190920_e(inserted == ItemStack.field_190927_a ? itemStack.func_190916_E() - canAccept : inserted.func_190916_E() + itemStack.func_190916_E() - canAccept);
        return toReturn;
    }

    public int getInventoryFill(IItemHandler dest, ItemStack stack) {
        int count = 0;
        for (int index = 0; index < dest.getSlots(); ++index) {
            ItemStack stackInSlot = dest.getStackInSlot(index);
            if (!stackInSlot.func_77969_a(stack)) continue;
            count += stackInSlot.func_190916_E();
        }
        return count;
    }

    @Nonnull
    public ItemStack extractItem(int i, int i1, boolean b) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int i) {
        IItemHandler dest = this.getDestination();
        if (dest == null) {
            return 0;
        }
        return dest.getSlotLimit(i);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        IItemHandler dest = this.getDestination();
        if (dest == null) {
            return false;
        }
        return dest.isItemValid(slot, stack);
    }

    public static class DummyInventory
    implements IItemHandler {
        public int getSlots() {
            return 0;
        }

        @Nonnull
        public ItemStack getStackInSlot(int i) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int i, @Nonnull ItemStack itemStack, boolean b) {
            return itemStack;
        }

        @Nonnull
        public ItemStack extractItem(int i, int i1, boolean b) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int i) {
            return 0;
        }
    }
}

