/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.tileentities;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.common.util.network.MessageTileSync;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityCommonValve
extends TileEntityIEBase
implements IEBlockInterfaces.IDirectionalTile,
ITickable,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IGuiTile {
    final TranslationKey overlayNormal;
    final TranslationKey overlaySneakingFirstLine;
    final TranslationKey overlaySneakingSecondLine;
    final int GuiID;
    public EnumFacing facing = EnumFacing.NORTH;
    public int packetLimit = -1;
    public int timeLimit = -1;
    public int keepSize = -1;
    public byte redstoneMode = 0;
    public long acceptedAmount;
    public long lastAcceptedAmount;
    public int secondCounter;
    public int minuteCounter;
    public long average;
    public long lastAverage;
    public int packets;
    public int packetAverage;
    public int lastPacketAverage;
    public long[] averages = new long[60];
    public long[] packetTotals = new long[60];

    public TileEntityCommonValve(TranslationKey overlayNormal, TranslationKey overlaySneakingFirstLine, TranslationKey overlaySneakingSecondLine, int GuiID) {
        this.overlayNormal = overlayNormal;
        this.overlaySneakingFirstLine = overlaySneakingFirstLine;
        this.overlaySneakingSecondLine = overlaySneakingSecondLine;
        this.GuiID = GuiID;
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    public void calculateAverages() {
        long sum = 0L;
        for (long avg : this.averages) {
            sum += avg;
        }
        this.average = sum / 60L;
        sum = 0L;
        for (long avg : this.packetTotals) {
            sum += avg;
        }
        this.packetAverage = (int)sum;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.efficientMarkDirty();
        if (++this.secondCounter < 20) {
            return;
        }
        if (this.average == 0L && this.acceptedAmount > 0L) {
            for (int i = 0; i < 60; ++i) {
                this.averages[i] = this.acceptedAmount;
            }
            this.packetTotals[this.minuteCounter] = this.packets;
            this.calculateAverages();
        }
        if (this.averages[this.minuteCounter] != this.acceptedAmount || this.packetTotals[this.minuteCounter] != (long)this.packets) {
            this.averages[this.minuteCounter] = this.acceptedAmount;
            this.packetTotals[this.minuteCounter] = this.packets;
            this.calculateAverages();
        }
        if (this.lastAverage != this.average || this.lastPacketAverage != this.packetAverage) {
            this.notifyNearbyClients(new NBTTagCompound());
        }
        this.lastAcceptedAmount = this.acceptedAmount;
        this.acceptedAmount = 0L;
        this.packets = 0;
        this.secondCounter = 0;
        if (++this.minuteCounter == 60) {
            this.lastPacketAverage = this.packetAverage;
            this.lastAverage = this.average;
            this.minuteCounter = 0;
        }
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K && !Utils.isHammer((ItemStack)heldItem)) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("packetLimit", this.packetLimit);
            tag.func_74768_a("timeLimit", this.timeLimit);
            tag.func_74768_a("keepSize", this.keepSize);
            ImmersiveTechnology.packetHandler.sendTo((IMessage)new MessageTileSync(this, tag), (EntityPlayerMP)player);
            return true;
        }
        if (player.func_70093_af() && Utils.isHammer((ItemStack)heldItem)) {
            String translationKey;
            this.redstoneMode = (byte)(this.redstoneMode + 1);
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
            switch (this.redstoneMode) {
                case 1: {
                    translationKey = TranslationKey.OVERLAY_REDSTONE_NORMAL.location;
                    break;
                }
                case 2: {
                    translationKey = TranslationKey.OVERLAY_REDSTONE_INVERTED.location;
                    break;
                }
                default: {
                    translationKey = TranslationKey.OVERLAY_REDSTONE_OFF.location;
                }
            }
            ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation(translationKey, new Object[0])});
            this.efficientMarkDirty();
            return true;
        }
        return false;
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        String[] stringArray;
        if (player.func_70093_af()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.overlaySneakingFirstLine.format((double)this.average / 20.0);
            stringArray = stringArray2;
            stringArray2[1] = this.overlaySneakingSecondLine.format(this.packetAverage);
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.overlayNormal.format(this.acceptedAmount);
        }
        return stringArray;
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74771_c("facing"));
        this.packetLimit = nbt.func_74762_e("packetLimit");
        this.timeLimit = nbt.func_74762_e("timeLimit");
        this.keepSize = nbt.func_74762_e("keepSize");
        this.redstoneMode = nbt.func_74771_c("redstoneMode");
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return;
        }
        this.lastAcceptedAmount = this.acceptedAmount = nbt.func_74763_f("acceptedAmount");
        this.secondCounter = nbt.func_74762_e("secondCounter");
        long avg = nbt.func_74763_f("averages");
        for (int i = 0; i < 60; ++i) {
            this.averages[i] = avg;
        }
        this.calculateAverages();
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74774_a("facing", (byte)this.facing.func_176745_a());
        nbt.func_74768_a("packetLimit", this.packetLimit);
        nbt.func_74768_a("timeLimit", this.timeLimit);
        nbt.func_74768_a("keepSize", this.keepSize);
        nbt.func_74774_a("redstoneMode", this.redstoneMode);
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return;
        }
        nbt.func_74772_a("acceptedAmount", this.acceptedAmount);
        nbt.func_74768_a("secondCounter", this.secondCounter);
        this.calculateAverages();
        nbt.func_74772_a("averages", this.average);
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return this.GuiID;
    }

    @Nullable
    public TileEntity getGuiMaster() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void showGui();

    @SideOnly(value=Side.CLIENT)
    public void receiveMessageFromServer(NBTTagCompound message) {
        if (message.func_74764_b("packetLimit")) {
            this.packetLimit = message.func_74762_e("packetLimit");
            this.timeLimit = message.func_74762_e("timeLimit");
            this.keepSize = message.func_74762_e("keepSize");
            this.showGui();
        } else {
            this.packetAverage = message.func_74762_e("packets");
            this.average = message.func_74763_f("average");
            this.acceptedAmount = message.func_74763_f("acceptedAmount");
        }
    }

    public void receiveMessageFromClient(NBTTagCompound message) {
        this.packetLimit = message.func_74762_e("packetLimit");
        this.timeLimit = message.func_74762_e("timeLimit");
        this.keepSize = message.func_74762_e("keepSize");
        this.efficientMarkDirty();
    }

    public void notifyNearbyClients(NBTTagCompound tag) {
        tag.func_74768_a("packets", Math.max(this.packets, this.packetAverage));
        tag.func_74772_a("average", this.average);
        tag.func_74772_a("acceptedAmount", this.acceptedAmount);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageTileSync(this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
    }

    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 0;
    }

    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return !entity.func_70093_af();
    }

    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    public int getRSPower() {
        int toReturn = 0;
        for (EnumFacing directions : EnumSet.complementOf(EnumSet.of(this.facing, this.facing.func_176734_d()))) {
            toReturn = Math.max(this.field_145850_b.func_175651_c(this.field_174879_c.func_177967_a(directions, -1), directions), toReturn);
        }
        return toReturn;
    }

    public static int longToInt(long value) {
        return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (value < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value);
    }
}

