/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.stone.tileentities;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityCokeOvenPreheater;
import mctmods.immersivetechnology.common.blocks.stone.tileentities.TileEntityCokeOvenAdvancedSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.network.MessageTileSync;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityCokeOvenAdvancedMaster
extends TileEntityCokeOvenAdvancedSlave
implements IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IProcessTile,
ITFluidTank.TankListener {
    private static int tankSize = Config.ITConfig.Machines.AdvancedCokeOven.advancedCokeOven_tankSize;
    public static float baseSpeed = Config.ITConfig.Machines.AdvancedCokeOven.advancedCokeOven_speed_base;
    public static float preheaterAdd = Config.ITConfig.Machines.AdvancedCokeOven.advancedCokeOven_preheater_speed_increase;
    public static float preheaterMult = Config.ITConfig.Machines.AdvancedCokeOven.advancedCokeOven_preheater_speed_multiplier;
    BlockPos fluidOutputPos;
    public float process = 0.0f;
    public int processMax = 0;
    public boolean active = false;
    private float soundVolume;
    private CokeOvenRecipe processing;
    public ITFluidTank tank = new ITFluidTank(tankSize, this);
    public static int slotCount = 4;
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
    IItemHandler inputHandler = new IEInventoryHandler(1, (IIEInventory)this, 0, new boolean[]{true}, new boolean[]{false});
    IItemHandler outputHandler = new IEInventoryHandler(1, (IIEInventory)this, 1, new boolean[]{false}, new boolean[]{true});

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.process = nbt.func_74760_g("process");
        this.processMax = nbt.func_74762_e("processMax");
        this.active = nbt.func_74767_n("active");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        if (!descPacket) {
            this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)slotCount);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74776_a("process", this.process);
        nbt.func_74768_a("processMax", this.processMax);
        nbt.func_74757_a("active", this.active);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    private void pumpOutputOut() {
        IFluidHandler output;
        if (this.tank.getFluidAmount() == 0) {
            return;
        }
        if (this.fluidOutputPos == null) {
            this.fluidOutputPos = ITUtils.LocalOffsetToWorldBlockPos(this.func_174877_v(), 0, -1, 3, this.facing, this.mirrored);
        }
        if ((output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.fluidOutputPos, (EnumFacing)this.facing.func_176734_d())) == null) {
            return;
        }
        FluidStack out = this.tank.getFluid();
        int accepted = output.fill(out, false);
        if (accepted == 0) {
            return;
        }
        int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
        this.tank.drain(drained, true);
    }

    public void handleSounds() {
        if (this.active) {
            if (this.soundVolume < 1.0f) {
                this.soundVolume += 0.01f;
            }
        } else if (this.soundVolume > 0.0f) {
            this.soundVolume -= 0.01f;
        }
        BlockPos center = this.func_174877_v();
        if (this.soundVolume == 0.0f) {
            ITSoundHandler.StopSound(center);
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float attenuation = Math.max((float)player.func_70092_e((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p()) / 8.0f, 1.0f);
            ITSounds.advCokeOven.PlayRepeating(center, this.soundVolume / attenuation, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        ITSoundHandler.StopSound(this.func_174877_v());
        super.onChunkUnload();
    }

    public void disassemble() {
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(center), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
        super.disassemble();
    }

    public void notifyNearbyClients() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("active", this.active);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        if (message.func_74764_b("active")) {
            this.active = message.func_74767_n("active");
        } else if (message.func_74764_b("process")) {
            this.process = message.func_74760_g("process");
            this.processMax = message.func_74762_e("processMax");
        }
    }

    public void updateRequested(EntityPlayerMP player) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("process", this.process);
        tag.func_74768_a("processMax", this.processMax);
        ImmersiveTechnology.packetHandler.sendTo((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), player);
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    @Override
    public void func_73660_a() {
        ItemStack filledContainer;
        if (!this.formed) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
            return;
        }
        boolean update = false;
        if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
            if (this.processing == null) {
                this.processing = this.getRecipe();
                if (this.processing == null) {
                    if (this.active) {
                        this.process = 0.0f;
                        this.processMax = 0;
                        this.active = false;
                        update = true;
                        this.notifyNearbyClients();
                    }
                } else if (!this.active) {
                    this.processMax = this.processing.time;
                    this.process = this.processMax;
                    this.active = true;
                    update = true;
                    this.notifyNearbyClients();
                }
            }
            if (this.active && this.process > 0.0f) {
                this.process -= this.getProcessSpeed();
                update = true;
            }
            if (this.processing != null && this.process <= 0.0f) {
                if (this.tank.getFluidAmount() + this.processing.creosoteOutput <= this.tank.getCapacity() && ((ItemStack)this.inventory.get(1)).func_190916_E() + this.getRecipe().output.func_190916_E() <= ((ItemStack)this.inventory.get(1)).func_77976_d()) {
                    Utils.modifyInvStackSize(this.inventory, (int)0, (int)-1);
                    if (!((ItemStack)this.inventory.get(1)).func_190926_b()) {
                        ((ItemStack)this.inventory.get(1)).func_190917_f(this.processing.output.func_77946_l().func_190916_E());
                    } else if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                        this.inventory.set(1, (Object)this.processing.output.func_77946_l());
                    }
                    this.tank.fill(new FluidStack(IEContent.fluidCreosote, this.processing.creosoteOutput), true);
                    this.markContainingBlockForUpdate(null);
                    this.active = false;
                    update = true;
                    this.process = 0.0f;
                    this.processMax = 0;
                    this.processing = null;
                    this.notifyNearbyClients();
                } else if (this.active) {
                    update = true;
                    this.active = false;
                    this.notifyNearbyClients();
                }
            }
        } else if (this.active) {
            this.active = false;
            update = true;
            this.process = 0.0f;
            this.processMax = 0;
            this.processing = null;
            this.notifyNearbyClients();
        }
        if (this.tank.getFluidAmount() > 0 && this.tank.getFluid() != null && (((ItemStack)this.inventory.get(3)).func_190926_b() || ((ItemStack)this.inventory.get(3)).func_190916_E() + 1 <= ((ItemStack)this.inventory.get(3)).func_77976_d()) && !(filledContainer = Utils.fillFluidContainer((IFluidHandler)this.tank, (ItemStack)((ItemStack)this.inventory.get(2)), (ItemStack)((ItemStack)this.inventory.get(3)), null)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(2)).func_190916_E() == 1 && !Utils.isFluidContainerFull((ItemStack)filledContainer)) {
                this.inventory.set(2, (Object)filledContainer.func_77946_l());
                update = true;
            } else if (!((ItemStack)this.inventory.get(3)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)filledContainer, (boolean)true)) {
                ((ItemStack)this.inventory.get(3)).func_190917_f(filledContainer.func_190916_E());
            } else if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
                this.inventory.set(3, (Object)filledContainer.func_77946_l());
                Utils.modifyInvStackSize(this.inventory, (int)2, (int)(-filledContainer.func_190916_E()));
                update = true;
            }
        }
        TileEntity inventoryFront = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177967_a(this.facing.func_176734_d(), 1).func_177982_a(0, -1, 0));
        if (!((ItemStack)this.inventory.get(1)).func_190926_b()) {
            ItemStack stack = (ItemStack)this.inventory.get(1);
            if (inventoryFront != null) {
                stack = Utils.insertStackIntoInventory((TileEntity)inventoryFront, (ItemStack)stack, (EnumFacing)this.facing);
            }
            this.inventory.set(1, (Object)stack);
        }
        this.pumpOutputOut();
        if (update) {
            this.efficientMarkDirty();
        }
    }

    public CokeOvenRecipe getRecipe() {
        CokeOvenRecipe recipe = CokeOvenRecipe.findRecipe((ItemStack)((ItemStack)this.inventory.get(0)));
        if (recipe == null) {
            return null;
        }
        if ((((ItemStack)this.inventory.get(1)).func_190926_b() || OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)recipe.output, (boolean)false) && ((ItemStack)this.inventory.get(1)).func_190916_E() + recipe.output.func_190916_E() <= this.getSlotLimit(1)) && this.tank.getFluidAmount() + recipe.creosoteOutput <= this.tank.getCapacity()) {
            return recipe;
        }
        return null;
    }

    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntityCokeOvenAdvancedMaster master() {
        this.master = this;
        return this;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        return new int[]{Math.round((float)this.processMax - this.process)};
    }

    @Override
    public int[] getCurrentProcessesMax() {
        return new int[]{this.processMax};
    }

    private float getProcessSpeed() {
        int activePreheaters = 0;
        for (int k = 0; k < 2; ++k) {
            EnumFacing f = k == 0 ? this.facing.func_176746_e() : this.facing.func_176735_f();
            BlockPos pos = this.func_174877_v().func_177982_a(0, -1, 0).func_177967_a(f, 2).func_177967_a(this.facing, 1);
            TileEntity tile = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)pos);
            if (!(tile instanceof TileEntityCokeOvenPreheater)) continue;
            TileEntityCokeOvenPreheater preheater = (TileEntityCokeOvenPreheater)tile;
            if (preheater.facing != f.func_176734_d() || !preheater.doSpeedup()) continue;
            ++activePreheaters;
        }
        return (baseSpeed + (float)activePreheaters * preheaterAdd) * (1.0f + (float)activePreheaters * (preheaterMult - 1.0f));
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }
}

