/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.common.util.Utils;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySteelSheetmetalTankSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntitySteelSheetmetalTankMaster
extends TileEntitySteelSheetmetalTankSlave
implements ITFluidTank.TankListener {
    private static int tankSize = Config.ITConfig.Machines.SteelTank.steelTank_tankSize;
    private static int transferSpeed = Config.ITConfig.Machines.SteelTank.steelTank_transferSpeed;
    private int[] oldComps = new int[4];
    private int masterCompOld;
    private int sleep = 0;
    public ITFluidTank tank = new ITFluidTank(tankSize, this);

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntitySteelSheetmetalTankMaster master() {
        this.master = this;
        return this;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.tank.getFluidAmount() == 0) {
            return;
        }
        if (this.field_145850_b.func_175687_A(this.func_174877_v()) > 0) {
            for (int index = 0; index < 6; ++index) {
                if (index == 1) continue;
                EnumFacing face = EnumFacing.func_82600_a((int)index);
                IFluidHandler output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(face), (EnumFacing)face.func_176734_d());
                if (output == null) continue;
                if (this.sleep == 0) {
                    FluidStack accepted = Utils.copyFluidStackWithAmount((FluidStack)this.tank.getFluid(), (int)Math.min(transferSpeed, this.tank.getFluidAmount()), (boolean)false);
                    if (accepted == null) {
                        this.sleep = 20;
                        return;
                    }
                    accepted.amount = output.fill(Utils.copyFluidStackWithAmount((FluidStack)accepted, (int)accepted.amount, (boolean)true), false);
                    if (accepted.amount > 0) {
                        int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)accepted, (int)accepted.amount, (boolean)false), true);
                        this.tank.drain(drained, true);
                        this.sleep = 0;
                        continue;
                    }
                    this.sleep = 20;
                    continue;
                }
                --this.sleep;
            }
        }
    }

    @Override
    public void TankContentsChanged() {
        this.updateComparatorValues();
        this.markContainingBlockForUpdate(null);
    }

    private void updateComparatorValues() {
        int vol = this.tank.getCapacity() / 6;
        int currentValue = 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
        if (currentValue != this.masterCompOld) {
            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        }
        this.masterCompOld = currentValue;
        for (int i = 0; i < 4; ++i) {
            int filled = this.tank.getFluidAmount() - i * vol;
            int now = Math.min(15, Math.max(15 * filled / vol, 0));
            if (now != this.oldComps[i]) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos pos = this.func_174877_v().func_177982_a(-this.offset[0] + x, -this.offset[1] + i + 1, -this.offset[2] + z);
                        this.field_145850_b.func_175685_c(pos, this.field_145850_b.func_180495_p(pos).func_177230_c(), true);
                    }
                }
            }
            this.oldComps[i] = now;
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
    }
}

