/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.crafting.SolarTowerRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySolarReflectorMaster;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntitySolarTowerSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.network.MessageTileSync;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySolarTowerMaster
extends TileEntitySolarTowerSlave
implements ITFluidTank.TankListener {
    private static int inputTankSize = Config.ITConfig.Machines.SolarTower.solarTower_input_tankSize;
    private static int outputTankSize = Config.ITConfig.Machines.SolarTower.solarTower_output_tankSize;
    private static int solarMaxRange = Config.ITConfig.Machines.SolarReflector.solarReflector_maxRange;
    private static int solarMinRange = Config.ITConfig.Machines.SolarReflector.solarReflector_minRange;
    private static int progressLossPerTick = Config.ITConfig.Machines.SolarTower.solarTower_progress_lossInTicks;
    private static int heatLossPerTick = Config.ITConfig.Machines.SolarTower.solarTower_heat_lossPerTick;
    private static float speedMult = Config.ITConfig.Machines.SolarTower.solarTower_speed_multiplier;
    private static float reflectorSpeedMult = Config.ITConfig.Machines.SolarTower.solarTower_solarReflector_speed_multiplier;
    private static double workingHeatLevel = Config.ITConfig.Machines.SolarTower.solarTower_heat_workingLevel;
    BlockPos fluidOutputPos;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(inputTankSize, this), new ITFluidTank(outputTankSize, this)};
    public static int slotCount = 4;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
    public int recipeTimeRemaining = 0;
    public double heatLevel = 0.0;
    public int[] reflectors = new int[4];
    private int clientUpdateCooldown = 20;
    private SolarTowerRecipe lastRecipe;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.heatLevel = nbt.func_74769_h("heatLevel");
        this.recipeTimeRemaining = nbt.func_74762_e("recipeTimeRemaining");
        this.reflectors = nbt.func_74759_k("reflectors");
        if (this.reflectors.length != 4) {
            this.reflectors = new int[4];
        }
        if (!descPacket) {
            this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)slotCount);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74780_a("heatLevel", this.heatLevel);
        nbt.func_74768_a("recipeTimeRemaining", this.recipeTimeRemaining);
        nbt.func_74783_a("reflectors", this.reflectors);
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    protected boolean checkReflector() {
        boolean update = false;
        if (!this.field_145850_b.func_72935_r()) {
            for (int cont = 0; cont < 4; ++cont) {
                this.reflectors[cont] = 0;
            }
            return update;
        }
        if (this.field_145850_b.func_72896_J()) {
            for (int cont = 0; cont < 4; ++cont) {
                this.reflectors[cont] = 0;
            }
            update = true;
            return update;
        }
        int maxRange = solarMaxRange;
        int minRange = solarMinRange;
        block2: for (int cont = 0; cont < 4; ++cont) {
            EnumFacing fw = this.facing;
            if (cont == 1) {
                fw = fw.func_176735_f();
            } else if (cont == 2) {
                fw = fw.func_176734_d();
            } else if (cont == 3) {
                fw = fw.func_176746_e();
            }
            this.reflectors[cont] = 0;
            for (int i = minRange; i < maxRange + 2; ++i) {
                BlockPos pos = cont == 0 ? this.func_174877_v().func_177967_a(fw, i + 2).func_177982_a(0, 2, 0) : (cont % 2 != 0 ? this.func_174877_v().func_177967_a(this.facing, 1).func_177967_a(fw, i + 1).func_177982_a(0, 2, 0) : this.func_174877_v().func_177967_a(fw, i).func_177982_a(0, 2, 0));
                if (Utils.isBlockAt((World)this.field_145850_b, (BlockPos)pos, (Block)Blocks.field_150350_a, (int)0)) continue;
                TileEntity tile = this.field_145850_b.func_175625_s(pos);
                if (!(tile instanceof TileEntitySolarReflectorMaster)) continue block2;
                EnumFacing fr = ((TileEntitySolarReflectorMaster)tile).facing;
                if (cont % 2 == 0 && (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.SOUTH) || cont % 2 != 0 && (this.facing == EnumFacing.EAST || this.facing == EnumFacing.WEST)) {
                    if (fr != EnumFacing.NORTH && fr != EnumFacing.SOUTH) continue;
                    if (!((TileEntitySolarReflectorMaster)tile).canSeeSun()) continue block2;
                    update = true;
                    this.reflectors[cont] = 1;
                    continue block2;
                }
                if (fr != EnumFacing.EAST && fr != EnumFacing.WEST) continue;
                if (!((TileEntitySolarReflectorMaster)tile).canSeeSun()) continue block2;
                update = true;
                this.reflectors[cont] = 1;
                continue block2;
            }
        }
        return update;
    }

    private boolean heatUp() {
        double previousHeatLevel = this.heatLevel;
        double temp = 0.1;
        if (!this.field_145850_b.func_72896_J()) {
            temp = this.field_145850_b.func_72959_q().func_76939_a(this.field_145850_b.func_180494_b(this.func_174877_v()).func_180626_a(this.func_174877_v()), this.func_174877_v().func_177956_o());
        }
        this.heatLevel = Math.min((double)this.getSpeed() + (this.heatLevel + temp), workingHeatLevel);
        return previousHeatLevel != this.heatLevel;
    }

    protected float getSpeed() {
        int activeReflectors = 0;
        for (int reflectorValue : this.reflectors) {
            activeReflectors += reflectorValue;
        }
        if (activeReflectors == 0) {
            return 0.0f;
        }
        return speedMult * (1.0f + (float)(activeReflectors - 1) * (reflectorSpeedMult - 1.0f));
    }

    private boolean cooldown() {
        double previousHeatLevel = this.heatLevel;
        double temp = this.field_145850_b.func_72959_q().func_76939_a(this.field_145850_b.func_180494_b(this.func_174877_v()).func_180626_a(this.func_174877_v()), this.func_174877_v().func_177956_o());
        this.heatLevel = Math.max(this.heatLevel - temp - (double)heatLossPerTick, 0.0);
        return previousHeatLevel != this.heatLevel;
    }

    private boolean loseProgress() {
        int previousProgress = this.recipeTimeRemaining;
        if (this.lastRecipe == null) {
            this.recipeTimeRemaining = 0;
            return true;
        }
        this.recipeTimeRemaining = Math.min(this.recipeTimeRemaining + progressLossPerTick, this.lastRecipe.getTotalProcessTime());
        return previousProgress != this.recipeTimeRemaining;
    }

    private boolean gainProgress() {
        if (this.lastRecipe == null) {
            this.recipeTimeRemaining = 0;
            return true;
        }
        --this.recipeTimeRemaining;
        if (this.recipeTimeRemaining == 0) {
            this.tanks[0].drain(this.lastRecipe.fluidInput.amount, true);
            this.tanks[1].fillInternal(this.lastRecipe.fluidOutput, true);
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    private void pumpOutputOut() {
        IFluidHandler output;
        if (this.tanks[1].getFluidAmount() == 0) {
            return;
        }
        if (this.fluidOutputPos == null) {
            this.fluidOutputPos = ITUtils.LocalOffsetToWorldBlockPos(this.func_174877_v(), 0, -1, 3, this.facing, this.mirrored);
        }
        if ((output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.fluidOutputPos, (EnumFacing)this.facing.func_176734_d())) == null) {
            return;
        }
        FluidStack out = this.tanks[1].getFluid();
        int accepted = output.fill(out, false);
        if (accepted == 0) {
            return;
        }
        int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
        this.tanks[1].drain(drained, true);
    }

    public void handleSounds() {
        BlockPos center = this.func_174877_v();
        float level = (float)(this.heatLevel / workingHeatLevel);
        if (level == 0.0f) {
            ITSoundHandler.StopSound(center);
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float attenuation = Math.max((float)player.func_70092_e((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p()) / 8.0f, 1.0f);
            ITSounds.solarTower.PlayRepeating(center, 2.0f * level / attenuation, level);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        if (!this.isDummy()) {
            ITSoundHandler.StopSound(this.func_174877_v());
        }
        super.onChunkUnload();
    }

    public void disassemble() {
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(center), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
        super.disassemble();
    }

    public void notifyNearbyClients() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("heat", this.heatLevel);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 40.0));
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        this.heatLevel = message.func_74769_h("heat");
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    private boolean heatLogic() {
        boolean update = false;
        if (this.checkReflector()) {
            if (!this.isRSDisabled()) {
                if (this.heatUp()) {
                    update = true;
                }
            } else if (this.cooldown()) {
                update = true;
            }
        } else if (this.cooldown()) {
            update = true;
        }
        return update;
    }

    private boolean recipeLogic() {
        boolean update = false;
        if (this.heatLevel >= workingHeatLevel) {
            if (this.recipeTimeRemaining > 0) {
                if (this.gainProgress()) {
                    update = true;
                }
            } else if (this.tanks[0].getFluid() != null) {
                SolarTowerRecipe recipe;
                SolarTowerRecipe solarTowerRecipe = recipe = this.lastRecipe != null && this.tanks[0].getFluid().isFluidEqual(this.lastRecipe.fluidInput) ? this.lastRecipe : SolarTowerRecipe.findRecipe(this.tanks[0].getFluid());
                if (recipe != null && recipe.fluidInput.amount <= this.tanks[0].getFluidAmount() && recipe.fluidOutput.amount == this.tanks[1].fillInternal(recipe.fluidOutput, false)) {
                    this.lastRecipe = recipe;
                    this.recipeTimeRemaining = recipe.getTotalProcessTime();
                    this.gainProgress();
                    update = true;
                }
            }
        } else if (this.recipeTimeRemaining > 0 && this.loseProgress()) {
            update = true;
        }
        return update;
    }

    private boolean outputTankLogic() {
        boolean update = false;
        if (this.tanks[1].getFluidAmount() > 0) {
            ItemStack filledContainer = Utils.fillFluidContainer((IFluidHandler)this.tanks[1], (ItemStack)((ItemStack)this.inventory.get(2)), (ItemStack)((ItemStack)this.inventory.get(3)), null);
            if (!filledContainer.func_190926_b()) {
                if (!((ItemStack)this.inventory.get(3)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)filledContainer, (boolean)true)) {
                    ((ItemStack)this.inventory.get(3)).func_190917_f(filledContainer.func_190916_E());
                } else if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
                    this.inventory.set(3, (Object)filledContainer.func_77946_l());
                }
                ((ItemStack)this.inventory.get(2)).func_190918_g(1);
                if (((ItemStack)this.inventory.get(2)).func_190916_E() <= 0) {
                    this.inventory.set(2, (Object)ItemStack.field_190927_a);
                }
                this.markContainingBlockForUpdate(null);
                update = true;
            }
            this.pumpOutputOut();
        }
        return update;
    }

    private boolean inputTankLogic() {
        int amount_prev = this.tanks[0].getFluidAmount();
        ItemStack emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[0], (ItemStack)((ItemStack)this.inventory.get(0)), (ItemStack)((ItemStack)this.inventory.get(1)), null);
        if (amount_prev != this.tanks[0].getFluidAmount()) {
            if (!((ItemStack)this.inventory.get(1)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)emptyContainer, (boolean)true)) {
                ((ItemStack)this.inventory.get(1)).func_190917_f(emptyContainer.func_190916_E());
            } else if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                this.inventory.set(1, (Object)emptyContainer.func_77946_l());
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(0)).func_190916_E() <= 0) {
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            }
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        if (!this.formed) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
            return;
        }
        boolean update = false;
        if (this.heatLogic()) {
            update = true;
        }
        if (this.recipeLogic()) {
            update = true;
        }
        if (this.outputTankLogic()) {
            update = true;
        }
        if (this.inputTankLogic()) {
            update = true;
        }
        if (this.clientUpdateCooldown > 1) {
            --this.clientUpdateCooldown;
        }
        if (update) {
            this.efficientMarkDirty();
            if (this.clientUpdateCooldown == 1) {
                this.notifyNearbyClients();
                this.clientUpdateCooldown = 20;
            }
        }
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntitySolarTowerMaster master() {
        this.master = this;
        return this;
    }
}

