/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Random;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.client.MechanicalEnergyAnimation;
import mctmods.immersivetechnology.api.crafting.GasTurbineRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockGasTurbine;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityGasTurbineSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITFluxStorage;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.multiblock.PoICache;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.common.util.network.BinaryMessageTileSync;
import mctmods.immersivetechnology.common.util.network.IBinaryMessageReceiver;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGasTurbineMaster
extends TileEntityGasTurbineSlave
implements ITFluidTank.TankListener,
IBinaryMessageReceiver {
    private static final int maxSpeed = Config.ITConfig.MechanicalEnergy.mechanicalEnergy_speed_max;
    private static final float maxRotationSpeed = Config.ITConfig.Machines.GasTurbine.gasTurbine_speed_maxRotation;
    private static final int speedGainPerTick = Config.ITConfig.Machines.GasTurbine.gasTurbine_speed_gainPerTick;
    private static final int speedLossPerTick = Config.ITConfig.Machines.GasTurbine.gasTurbine_speed_lossPerTick;
    private static final int inputTankSize = Config.ITConfig.Machines.GasTurbine.gasTurbine_input_tankSize;
    private static final int outputTankSize = Config.ITConfig.Machines.GasTurbine.gasTurbine_input_tankSize;
    public static final int electricStarterConsumption = Config.ITConfig.Machines.GasTurbine.gasTurbine_electric_starter_consumption;
    public static final int sparkplugConsumption = Config.ITConfig.Machines.GasTurbine.gasTurbine_sparkplug_consumption;
    public static final int electricStarterSize = Config.ITConfig.Machines.GasTurbine.gasTurbine_electric_starter_size;
    public static final int sparkplugSize = Config.ITConfig.Machines.GasTurbine.gasTurbine_sparkplug_size;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(inputTankSize, this), new ITFluidTank(outputTankSize, this)};
    public ITFluxStorage starterStorage = new ITFluxStorage(electricStarterSize, false, true);
    public ITFluxStorage sparkplugStorage = new ITFluxStorage(sparkplugSize, false, true);
    public int burnRemaining = 0;
    public int speed;
    public int ignitionGracePeriod = 0;
    public boolean ignited;
    public boolean starterRunning = false;
    public GasTurbineRecipe lastRecipe;
    MechanicalEnergyAnimation animation = new MechanicalEnergyAnimation();
    ITBlockInterfaces.IMechanicalEnergy alternator;
    private PoICache input;
    private PoICache output;
    private PoICache power0;
    private PoICache power1;
    private PoICache redstone;
    private PoICache mechanicalOutput;
    private BlockPos particleOrigin;
    private BlockPos runningSoundOrigin;
    private BlockPos arcSoundOrigin;
    private BlockPos ignitionSoundOrigin;
    private BlockPos starterSoundOrigin;
    private BlockPos outputFront;
    private BlockPos mechanicalOutputFront;

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        Random rand;
        if (!this.starterRunning || this.speed < maxSpeed / 4) {
            return;
        }
        if (this.input == null) {
            this.InitializePoIs();
        }
        if ((rand = new Random()).nextInt(40) == 0) {
            return;
        }
        int lessParticleSetting = ClientUtils.mc().field_71474_y.field_74362_aa;
        if (lessParticleSetting == 2 || lessParticleSetting == 1 && rand.nextInt(3) == 0) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double distanceLimit = 64.0;
        if (this.particleOrigin.func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v) > distanceLimit * distanceLimit) {
            return;
        }
        Particle particle = new ParticleSmokeNormal.Factory().func_178902_a(0, this.field_145850_b, (double)((float)(this.particleOrigin.func_177958_n() + 2) - rand.nextFloat() * 3.0f), (double)((float)this.particleOrigin.func_177956_o() + 0.5f), (double)((float)(this.particleOrigin.func_177952_p() + 2) - rand.nextFloat() * 3.0f), 0.0, (double)0.02f, 0.0, new int[]{7});
        ClientUtils.mc().field_71452_i.func_78873_a(particle);
    }

    public void handleSounds() {
        float level = ITUtils.remapRange(0.0f, maxSpeed, 0.5f, 1.5f, this.speed);
        if (this.input == null) {
            this.InitializePoIs();
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float attenuation = Math.max((float)player.func_70092_e((double)this.runningSoundOrigin.func_177958_n(), (double)this.runningSoundOrigin.func_177956_o(), (double)this.runningSoundOrigin.func_177952_p()) / 64.0f, 1.0f);
        if (this.speed == 0) {
            ITSoundHandler.StopSound(this.runningSoundOrigin);
        } else {
            ITSounds.gasTurbineRunning.PlayRepeating(this.runningSoundOrigin, (level - 0.5f) / (4.0f * attenuation), level);
        }
        if (this.starterRunning) {
            ITSounds.gasTurbineStarter.PlayRepeating(this.starterSoundOrigin, Math.min((level - 0.5f) / attenuation, 0.2f), 1.0f);
            if (this.speed >= maxSpeed / 4) {
                ITSounds.gasTurbineArc.PlayRepeating(this.arcSoundOrigin, Math.min((level - 0.5f) / attenuation, 0.2f), 1.0f);
            }
        } else {
            ITSoundHandler.StopSound(this.starterSoundOrigin);
            ITSoundHandler.StopSound(this.arcSoundOrigin);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        if (this.input == null) {
            this.InitializePoIs();
        }
        ITSoundHandler.StopSound(this.runningSoundOrigin);
        ITSoundHandler.StopSound(this.arcSoundOrigin);
        ITSoundHandler.StopSound(this.ignitionSoundOrigin);
        ITSoundHandler.StopSound(this.starterSoundOrigin);
        super.onChunkUnload();
    }

    public void disassemble() {
        super.disassemble();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(this.runningSoundOrigin), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.runningSoundOrigin.func_177958_n(), (double)this.runningSoundOrigin.func_177956_o(), (double)this.runningSoundOrigin.func_177952_p(), 0.0));
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(this.arcSoundOrigin), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.arcSoundOrigin.func_177958_n(), (double)this.arcSoundOrigin.func_177956_o(), (double)this.arcSoundOrigin.func_177952_p(), 0.0));
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(this.ignitionSoundOrigin), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.ignitionSoundOrigin.func_177958_n(), (double)this.ignitionSoundOrigin.func_177956_o(), (double)this.ignitionSoundOrigin.func_177952_p(), 0.0));
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(this.starterSoundOrigin), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.starterSoundOrigin.func_177958_n(), (double)this.starterSoundOrigin.func_177956_o(), (double)this.starterSoundOrigin.func_177952_p(), 0.0));
    }

    private void speedUp() {
        if (this.starterRunning) {
            this.speed = this.speed >= maxSpeed / 4 ? Math.max(Math.min(maxSpeed, this.speed + speedGainPerTick - speedLossPerTick), maxSpeed / 4) : Math.min(maxSpeed / 4, this.speed + speedGainPerTick);
        } else if (this.speed >= maxSpeed / 4) {
            this.speed = Math.min(maxSpeed, this.speed + speedGainPerTick);
        } else {
            this.speedDown();
        }
    }

    private void speedDown() {
        if (this.ignitionGracePeriod > 0) {
            --this.ignitionGracePeriod;
        }
        this.speed = Math.max(0, this.speed - speedLossPerTick);
    }

    public boolean isValidAlternator() {
        if (this.alternator == null || !this.alternator.isValid()) {
            ITBlockInterfaces.IMechanicalEnergy possibleAlternator;
            TileEntity tile;
            if (this.input == null) {
                this.InitializePoIs();
            }
            if ((tile = this.field_145850_b.func_175625_s(this.mechanicalOutputFront)) instanceof ITBlockInterfaces.IMechanicalEnergy && (possibleAlternator = (ITBlockInterfaces.IMechanicalEnergy)tile).isValid() && possibleAlternator.isMechanicalEnergyReceiver(this.facing.func_176734_d())) {
                this.alternator = possibleAlternator;
            }
        }
        return this.alternator != null && this.alternator.isValid();
    }

    public void ignite() {
        this.sparkplugStorage.modifyEnergyStored(-sparkplugConsumption);
        this.ignited = true;
        this.ignitionGracePeriod = 60;
        BinaryMessageTileSync.sendToAllTracking(this.field_145850_b, this.func_174877_v(), Unpooled.buffer());
    }

    public boolean canIgnite() {
        return sparkplugConsumption <= this.sparkplugStorage.getEnergyStored();
    }

    @Override
    public void receiveMessageFromServer(ByteBuf buf) {
        if (this.input == null) {
            this.InitializePoIs();
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float attenuation = Math.max((float)player.func_70092_e((double)this.runningSoundOrigin.func_177958_n(), (double)this.runningSoundOrigin.func_177956_o(), (double)this.runningSoundOrigin.func_177952_p()) / 8.0f, 1.0f);
        ITSounds.gasTurbineSpark.PlayOnce(this.ignitionSoundOrigin, 1.0f / attenuation, 1.0f);
    }

    @Override
    public void func_73660_a() {
        boolean canRun;
        float rotationSpeed;
        if (!this.formed) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
            this.spawnParticles();
            return;
        }
        float f = rotationSpeed = this.speed == 0 ? 0.0f : (float)this.speed / (float)maxSpeed * maxRotationSpeed;
        if (ITUtils.setRotationAngle(this.animation, rotationSpeed)) {
            this.efficientMarkDirty();
            this.markContainingBlockForUpdate(null);
        }
        this.ignited = this.ignitionGracePeriod > 0;
        boolean bl = canRun = !this.isRSDisabled() && this.isValidAlternator();
        if (canRun && electricStarterConsumption <= this.starterStorage.getEnergyStored()) {
            this.starterRunning = true;
            this.starterStorage.modifyEnergyStored(-electricStarterConsumption);
        } else {
            this.starterRunning = false;
        }
        if (this.speed < maxSpeed / 4) {
            if (canRun) {
                if (this.ignitionGracePeriod > 0) {
                    --this.ignitionGracePeriod;
                }
                this.speedUp();
            } else {
                this.speedDown();
            }
        } else if (this.burnRemaining > 0 && (this.ignited || this.canIgnite())) {
            --this.burnRemaining;
            if (!this.ignited) {
                this.ignite();
            }
            this.speedUp();
        } else if (canRun && this.tanks[0].getFluid() != null && this.tanks[0].getFluid().getFluid() != null && (this.ignited || this.canIgnite())) {
            GasTurbineRecipe recipe;
            GasTurbineRecipe gasTurbineRecipe = recipe = this.lastRecipe != null && this.tanks[0].getFluid().isFluidEqual(this.lastRecipe.fluidInput) ? this.lastRecipe : GasTurbineRecipe.findFuel(this.tanks[0].getFluid());
            if (recipe != null && recipe.fluidInput.amount <= this.tanks[0].getFluidAmount()) {
                this.lastRecipe = recipe;
                this.burnRemaining = recipe.getTotalProcessTime() - 1;
                this.tanks[0].drain(recipe.fluidInput.amount, true);
                if (recipe.fluidOutput != null) {
                    this.tanks[1].fill(recipe.fluidOutput, true);
                }
                if (!this.ignited) {
                    this.ignite();
                }
                this.markContainingBlockForUpdate(null);
                this.speedUp();
            } else {
                this.speedDown();
            }
        } else {
            this.speedDown();
        }
        this.pumpOutputOut();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.speed = nbt.func_74762_e("speed");
        this.starterRunning = nbt.func_74767_n("starter");
        this.ignitionGracePeriod = nbt.func_74762_e("ignitionGracePeriod");
        this.animation.readFromNBT(nbt);
        this.burnRemaining = nbt.func_74762_e("burnRemaining");
        this.starterStorage.readFromNBT(nbt.func_74775_l("starterStorage"));
        this.sparkplugStorage.readFromNBT(nbt.func_74775_l("sparkplugStorage"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("speed", this.speed);
        nbt.func_74757_a("starter", this.starterRunning);
        nbt.func_74768_a("ignitionGracePeriod", this.ignitionGracePeriod);
        this.animation.writeToNBT(nbt);
        nbt.func_74768_a("burnRemaining", this.burnRemaining);
        nbt.func_74782_a("starterStorage", (NBTBase)this.starterStorage.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("sparkplugStorage", (NBTBase)this.sparkplugStorage.writeToNBT(new NBTTagCompound()));
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntityGasTurbineMaster master() {
        this.master = this;
        return this;
    }

    private void InitializePoIs() {
        for (PoIJSONSchema poi : MultiblockGasTurbine.instance.pointsOfInterest) {
            if (poi.name.equals("input")) {
                this.input = new PoICache(this.facing, poi, this.mirrored);
                continue;
            }
            if (poi.name.equals("output")) {
                this.output = new PoICache(this.facing, poi, this.mirrored);
                this.outputFront = this.getBlockPosForPos(this.output.position).func_177972_a(this.output.facing);
                continue;
            }
            if (poi.name.equals("particle")) {
                this.particleOrigin = this.getBlockPosForPos(poi.position);
                continue;
            }
            if (poi.name.equals("running_sound")) {
                this.runningSoundOrigin = this.getBlockPosForPos(poi.position);
                continue;
            }
            if (poi.name.equals("arc_sound")) {
                this.arcSoundOrigin = this.getBlockPosForPos(poi.position);
                continue;
            }
            if (poi.name.equals("ignition_sound")) {
                this.ignitionSoundOrigin = this.getBlockPosForPos(poi.position);
                continue;
            }
            if (poi.name.equals("starter_sound")) {
                this.starterSoundOrigin = this.getBlockPosForPos(poi.position);
                continue;
            }
            if (poi.name.equals("power0")) {
                this.power0 = new PoICache(this.facing, poi, this.mirrored);
                continue;
            }
            if (poi.name.equals("power1")) {
                this.power1 = new PoICache(this.facing, poi, this.mirrored);
                continue;
            }
            if (poi.name.equals("mechanical_output")) {
                this.mechanicalOutput = new PoICache(this.facing, poi, this.mirrored);
                this.mechanicalOutputFront = this.getBlockPosForPos(this.mechanicalOutput.position).func_177972_a(this.mechanicalOutput.facing);
                continue;
            }
            if (!poi.name.equals("redstone")) continue;
            this.redstone = new PoICache(this.facing, poi, this.mirrored);
        }
    }

    @Override
    public int[] getRedstonePos() {
        if (this.input == null) {
            this.InitializePoIs();
        }
        return new int[]{this.redstone.position};
    }

    public IFluidTank[] getAccessibleFluidTanks(EnumFacing side, int position) {
        if (this.input == null) {
            this.InitializePoIs();
        }
        if (side == null) {
            return this.tanks;
        }
        if (this.input.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[0]};
        }
        if (this.output.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[1]};
        }
        return ITUtils.emptyIFluidTankList;
    }

    public boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource, int position) {
        if (this.input == null) {
            this.InitializePoIs();
        }
        if (this.input.isPoI(side, position)) {
            if (this.tanks[0].getFluidAmount() >= this.tanks[0].getCapacity()) {
                return false;
            }
            if (this.tanks[0].getFluid() == null) {
                return GasTurbineRecipe.findFuelByFluid(resource.getFluid()) != null;
            }
            return resource.getFluid() == this.tanks[0].getFluid().getFluid();
        }
        return false;
    }

    public boolean canDrainTankFrom(int iTank, EnumFacing side, int position) {
        if (this.input == null) {
            this.InitializePoIs();
        }
        if (this.output.isPoI(side, position)) {
            return this.tanks[1].getFluidAmount() > 0;
        }
        return false;
    }

    private void pumpOutputOut() {
        IFluidHandler output;
        if (this.input == null) {
            this.InitializePoIs();
        }
        if ((output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.outputFront, (EnumFacing)this.output.facing.func_176734_d())) != null) {
            FluidStack out = this.tanks[1].getFluid();
            int accepted = output.fill(out, false);
            if (accepted == 0) {
                return;
            }
            int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
            this.tanks[1].drain(drained, true);
        }
    }

    public boolean isMechanicalEnergyTransmitter(EnumFacing facing, int position) {
        if (this.input == null) {
            this.InitializePoIs();
        }
        return this.mechanicalOutput.isPoI(facing, position);
    }

    public boolean isEnergyPosition(@Nullable EnumFacing facing, int position) {
        if (this.input == null) {
            this.InitializePoIs();
        }
        return this.power0.isPoI(facing, position) || this.power1.isPoI(facing, position);
    }

    public IEnergyStorage getEnergyAtPosition(@Nullable EnumFacing facing, int position) {
        if (this.input == null) {
            this.InitializePoIs();
        }
        if (facing == null) {
            return null;
        }
        if (this.power1.isPoI(facing, position)) {
            return this.sparkplugStorage;
        }
        if (this.power0.isPoI(facing, position)) {
            return this.starterStorage;
        }
        return null;
    }
}

