/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.api.AdvancedAABB;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.ITContent;
import mctmods.immersivetechnology.common.util.IPipe;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityFluidPipe
extends blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPipe
implements IPipe {
    public static ConcurrentHashMap<BlockPos, Set<DirectionalFluidOutput>> indirectConnections = new ConcurrentHashMap();
    public static int transferRate = Config.ITConfig.Experimental.pipe_transfer_rate;
    public static int transferRatePressurized = Config.ITConfig.Experimental.pipe_pressurized_transfer_rate;
    public static ArrayList<Function<ItemStack, Boolean>> validPipeCovers = new ArrayList();
    public static ArrayList<Function<ItemStack, Boolean>> climbablePipeCovers = new ArrayList();
    public int[] sideConfig = new int[]{0, 0, 0, 0, 0, 0};
    public ItemStack pipeCover = ItemStack.field_190927_a;
    private byte connections = 0;
    @Nullable
    private EnumDyeColor color = null;
    PipeFluidHandler[] sidedHandlers = new PipeFluidHandler[]{new PipeFluidHandler(this, EnumFacing.DOWN), new PipeFluidHandler(this, EnumFacing.UP), new PipeFluidHandler(this, EnumFacing.NORTH), new PipeFluidHandler(this, EnumFacing.SOUTH), new PipeFluidHandler(this, EnumFacing.WEST), new PipeFluidHandler(this, EnumFacing.EAST)};
    public static HashMap<String, OBJModel.OBJState> cachedOBJStates = new HashMap();
    static String[] CONNECTIONS = new String[]{"con_yMin", "con_yMax", "con_zMin", "con_zMax", "con_xMin", "con_xMax"};

    public static void initCovers() {
        final ArrayList scaffolds = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)IEContent.blockWoodenDecoration, 1, BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_1.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_2.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_0.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_1.getMeta()), new ItemStack((Block)IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_2.getMeta())});
        validPipeCovers.add(new Function<ItemStack, Boolean>(){

            @Override
            @Nullable
            public Boolean apply(ItemStack input) {
                if (input.func_190926_b()) {
                    return Boolean.FALSE;
                }
                for (ItemStack stack : scaffolds) {
                    if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)input, (boolean)false)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        climbablePipeCovers.add(new Function<ItemStack, Boolean>(){

            @Override
            @Nullable
            public Boolean apply(ItemStack input) {
                if (input.func_190926_b()) {
                    return Boolean.FALSE;
                }
                for (ItemStack stack : scaffolds) {
                    if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)input, (boolean)false)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    public static Set<DirectionalFluidOutput> getConnectedFluidHandlersIT(BlockPos node, World world) {
        if (indirectConnections.containsKey(node)) {
            return indirectConnections.get(node);
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        Set<DirectionalFluidOutput> fluidHandlers = Collections.newSetFromMap(new ConcurrentHashMap());
        openList.add(node);
        while (!openList.isEmpty() && closedList.size() < 1024) {
            BlockPos next = (BlockPos)openList.get(0);
            TileEntity pipeTile = Utils.getExistingTileEntity((World)world, (BlockPos)next);
            if (!closedList.contains(next) && pipeTile instanceof IFluidPipe) {
                if (pipeTile instanceof TileEntityFluidPipe) {
                    closedList.add(next);
                }
                for (int i = 0; i < 6; ++i) {
                    IFluidTankProperties[] tankInfo;
                    IFluidHandler handler;
                    BlockPos nextPos;
                    TileEntity adjacentTile;
                    EnumFacing fd = EnumFacing.func_82600_a((int)i);
                    if (!((IFluidPipe)pipeTile).hasOutputConnection(fd) || (adjacentTile = Utils.getExistingTileEntity((World)world, (BlockPos)(nextPos = next.func_177972_a(fd)))) == null) continue;
                    if (adjacentTile instanceof TileEntityFluidPipe) {
                        openList.add(nextPos);
                        continue;
                    }
                    if (!adjacentTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, fd.func_176734_d()) || (handler = (IFluidHandler)adjacentTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, fd.func_176734_d())) == null || (tankInfo = handler.getTankProperties()) == null || tankInfo.length <= 0) continue;
                    fluidHandlers.add(new DirectionalFluidOutput(handler, adjacentTile, fd));
                }
            }
            openList.remove(0);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !indirectConnections.containsKey(node)) {
            indirectConnections.put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
            indirectConnections.get(node).addAll(fluidHandlers);
        }
        return fluidHandlers;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            indirectConnections.clear();
        }
    }

    public void onEntityCollision(World world, Entity entity) {
        if (!(entity instanceof EntityLivingBase) || ((EntityLivingBase)entity).func_70617_f_() || this.pipeCover.func_190926_b()) {
            return;
        }
        boolean climb = false;
        for (Function<ItemStack, Boolean> f : climbablePipeCovers) {
            if (f == null || f.apply(this.pipeCover) != Boolean.TRUE) continue;
            climb = true;
            break;
        }
        if (!climb) {
            return;
        }
        float f5 = 0.15f;
        if (entity.field_70159_w < (double)(-f5)) {
            entity.field_70159_w = -f5;
        }
        if (entity.field_70159_w > (double)f5) {
            entity.field_70159_w = f5;
        }
        if (entity.field_70179_y < (double)(-f5)) {
            entity.field_70179_y = -f5;
        }
        if (entity.field_70179_y > (double)f5) {
            entity.field_70179_y = f5;
        }
        entity.field_70143_R = 0.0f;
        if (entity.field_70181_x < -0.15) {
            entity.field_70181_x = -0.15;
        }
        if (entity.field_70181_x < 0.0 && entity instanceof EntityPlayer && entity.func_70093_af()) {
            entity.field_70181_x = 0.05;
            return;
        }
        if (entity.field_70123_F) {
            entity.field_70181_x = 0.2;
        }
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length != 6) {
            this.sideConfig = new int[]{0, 0, 0, 0, 0, 0};
        }
        this.pipeCover = new ItemStack(nbt.func_74775_l("pipeCover"));
        EnumDyeColor oldColor = this.color;
        this.color = nbt.func_150297_b("color", 3) ? EnumDyeColor.func_176764_b((int)nbt.func_74762_e("color")) : null;
        byte oldConns = this.connections;
        this.connections = nbt.func_74771_c("connections");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && (this.connections != oldConns || this.color != oldColor)) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        if (!this.pipeCover.func_190926_b()) {
            nbt.func_74782_a("pipeCover", (NBTBase)this.pipeCover.func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74774_a("connections", this.connections);
        if (this.color != null) {
            nbt.func_74768_a("color", this.color.func_176765_a());
        }
    }

    boolean canOutputPressurized(TileEntity output, boolean consumePower) {
        if (output instanceof IFluidPipe) {
            return ((IFluidPipe)output).canOutputPressurized(consumePower);
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && this.sideConfig[facing.ordinal()] == 0) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && this.sideConfig[facing.ordinal()] == 0) {
            return (T)this.sidedHandlers[facing.ordinal()];
        }
        return (T)super.getCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(IBlockState object, List<BakedQuad> quads) {
        if (!this.pipeCover.func_190926_b()) {
            Block b = Block.func_149634_a((Item)this.pipeCover.func_77973_b());
            IBlockState state = b != null ? b.func_176203_a(this.pipeCover.func_77960_j()) : Blocks.field_150348_b.func_176223_P();
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
            BlockRenderLayer curL = MinecraftForgeClient.getRenderLayer();
            if (model != null) {
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        quads.addAll(model.func_188616_a(state, facing, 0L));
                    }
                    quads.addAll(model.func_188616_a(state, null, 0L));
                }
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)curL);
        }
        return quads;
    }

    @SideOnly(value=Side.CLIENT)
    public String getCacheKey(IBlockState object) {
        return this.getRenderCacheKey();
    }

    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(IBlockState object, String group, Optional<TRSRTransformation> transform) {
        return transform;
    }

    public Collection<ItemStack> getExtraDrops(EntityPlayer player, IBlockState state) {
        if (!this.pipeCover.func_190926_b()) {
            return Lists.newArrayList((Object[])new ItemStack[]{this.pipeCover});
        }
        return null;
    }

    public void onNeighborBlockChange(BlockPos otherPos) {
        EnumFacing dir = EnumFacing.func_176737_a((float)(otherPos.func_177958_n() - this.field_174879_c.func_177958_n()), (float)(otherPos.func_177956_o() - this.field_174879_c.func_177956_o()), (float)(otherPos.func_177952_p() - this.field_174879_c.func_177952_p()));
        if (this.updateConnectionByte(dir)) {
            ITUtils.improvedMarkBlockForUpdate(this.field_145850_b, this.field_174879_c, null, EnumSet.complementOf(EnumSet.of(dir)));
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            boolean changed = false;
            for (EnumFacing f : EnumFacing.field_82609_l) {
                if (!this.field_145850_b.func_175667_e(this.field_174879_c.func_177972_a(f))) continue;
                changed |= this.updateConnectionByte(f);
            }
            if (changed) {
                ITUtils.improvedMarkBlockForUpdate(this.field_145850_b, this.field_174879_c, null);
            }
        }
    }

    public boolean updateConnectionByte(EnumFacing dir) {
        IFluidTankProperties[] tankInfo;
        IFluidHandler handler;
        byte oldConn = this.connections;
        int i = dir.func_176745_a();
        int mask = 1 << i;
        this.connections = (byte)(this.connections & ~mask);
        TileEntity con = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir));
        if (this.sideConfig[i] == 0 && con != null && con.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()) && (handler = (IFluidHandler)con.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) != null && (tankInfo = handler.getTankProperties()) != null && tankInfo.length > 0) {
            this.connections = (byte)(this.connections | mask);
        }
        return oldConn != this.connections;
    }

    public byte getAvailableConnectionByte() {
        byte connections = 0;
        for (int i = 5; i >= 0; --i) {
            IFluidTankProperties[] tankInfo;
            IFluidHandler handler;
            EnumFacing dir = EnumFacing.func_82600_a((int)i);
            TileEntity con = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir));
            connections = (byte)(connections << 1);
            if (con == null || !con.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()) || (handler = (IFluidHandler)con.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) == null || (tankInfo = handler.getTankProperties()) == null || tankInfo.length <= 0) continue;
            connections = (byte)(connections | 1);
        }
        return connections;
    }

    public int getConnectionStyle(int connection) {
        byte tileConnections;
        if (this.sideConfig[connection] == -1) {
            return 0;
        }
        if ((this.connections & 1 << connection) == 0) {
            return 0;
        }
        if (this.connections != 3 && this.connections != 12 && this.connections != 48) {
            return 1;
        }
        TileEntity con = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.func_82600_a((int)connection)));
        if (con instanceof TileEntityFluidPipe && this.connections == (tileConnections = ((TileEntityFluidPipe)con).connections)) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean hasCover() {
        return this.pipeCover.func_190926_b();
    }

    @Override
    public void toggleSide(int side) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 0) {
            this.sideConfig[side] = -1;
        }
        this.func_70296_d();
        EnumFacing fd = EnumFacing.func_82600_a((int)side);
        TileEntity connected = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(fd));
        if (connected instanceof TileEntityFluidPipe) {
            ((TileEntityFluidPipe)connected).sideConfig[fd.func_176734_d().ordinal()] = this.sideConfig[side];
            connected.func_70296_d();
            this.field_145850_b.func_175641_c(this.func_174877_v().func_177972_a(fd), this.func_145838_q(), 0, 0);
        }
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
    }

    @Override
    public int[] getSideConfig() {
        return this.sideConfig;
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            ITUtils.improvedMarkBlockForUpdate(this.field_145850_b, this.field_174879_c, null);
            return true;
        }
        return false;
    }

    public float[] getBlockBounds() {
        return null;
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        ArrayList list = Lists.newArrayList();
        if (!this.pipeCover.func_190926_b()) {
            list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186662_g(-0.03125).func_186670_a(this.func_174877_v()));
            return list;
        }
        if (this.connections == 48) {
            list.add(new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75).func_186670_a(this.func_174877_v()));
            if ((this.connections & 0x10) == 0) {
                list.add(new AxisAlignedBB(0.0, 0.125, 0.125, 0.125, 0.875, 0.875).func_186670_a(this.func_174877_v()));
            }
            if ((this.connections & 0x20) == 0) {
                list.add(new AxisAlignedBB(0.875, 0.125, 0.125, 1.0, 0.875, 0.875).func_186670_a(this.func_174877_v()));
            }
        } else if (this.connections == 12) {
            list.add(new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0).func_186670_a(this.func_174877_v()));
            if ((this.connections & 4) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125).func_186670_a(this.func_174877_v()));
            }
            if ((this.connections & 8) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.125, 0.875, 0.875, 0.875, 1.0).func_186670_a(this.func_174877_v()));
            }
        } else if (this.connections == 3) {
            list.add(new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75).func_186670_a(this.func_174877_v()));
            if ((this.connections & 1) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875).func_186670_a(this.func_174877_v()));
            }
            if ((this.connections & 2) == 0) {
                list.add(new AxisAlignedBB(0.125, 0.875, 0.125, 0.875, 1.0, 0.875).func_186670_a(this.func_174877_v()));
            }
        } else {
            list.add(new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75).func_186670_a(this.func_174877_v()));
            for (int i = 0; i < 6; ++i) {
                if ((this.connections & 1 << i) == 0) continue;
                list.add(new AxisAlignedBB(i == 4 ? 0.0 : (i == 5 ? 0.875 : 0.125), i == 0 ? 0.0 : (i == 1 ? 0.875 : 0.125), i == 2 ? 0.0 : (i == 3 ? 0.875 : 0.125), i == 4 ? 0.125 : (i == 5 ? 1.0 : 0.875), i == 0 ? 0.125 : (i == 1 ? 1.0 : 0.875), i == 2 ? 0.125 : (i == 3 ? 1.0 : 0.875)).func_186670_a(this.func_174877_v()));
            }
        }
        return list;
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        double[] dArray;
        ArrayList list = Lists.newArrayList();
        byte availableConnections = this.getAvailableConnectionByte();
        if (!this.pipeCover.func_190926_b()) {
            double[] dArray2 = new double[6];
            dArray2[0] = 0.002;
            dArray2[1] = 0.998;
            dArray2[2] = 0.002;
            dArray2[3] = 0.998;
            dArray2[4] = 0.002;
            dArray = dArray2;
            dArray2[5] = 0.998;
        } else {
            double[] dArray3 = new double[6];
            dArray3[0] = 0.25;
            dArray3[1] = 0.75;
            dArray3[2] = 0.25;
            dArray3[3] = 0.75;
            dArray3[4] = 0.25;
            dArray = dArray3;
            dArray3[5] = 0.75;
        }
        double[] baseAABB = dArray;
        for (int i = 0; i < 6; ++i) {
            double size;
            double depth = this.getConnectionStyle(i) == 0 ? 0.25 : 0.125;
            double d = size = this.getConnectionStyle(i) == 0 ? 0.25 : 0.125;
            if ((availableConnections & 1) == 1) {
                list.add(new AdvancedAABB(new AxisAlignedBB(i == 4 ? 0.0 : (i == 5 ? 1.0 - depth : size), i == 0 ? 0.0 : (i == 1 ? 1.0 - depth : size), i == 2 ? 0.0 : (i == 3 ? 1.0 - depth : size), i == 4 ? depth : (i == 5 ? 1.0 : 1.0 - size), i == 0 ? depth : (i == 1 ? 1.0 : 1.0 - size), i == 2 ? depth : (i == 3 ? 1.0 : 1.0 - size)).func_186670_a(this.func_174877_v()), EnumFacing.func_82600_a((int)i)));
            }
            if ((this.connections & 1 << i) != 0) {
                int n = i;
                baseAABB[n] = baseAABB[n] + (i % 2 == 1 ? 0.125 : -0.125);
            }
            baseAABB[i] = Math.min(Math.max(baseAABB[i], 0.0), 1.0);
            availableConnections = (byte)(availableConnections >> 1);
        }
        list.add(new AdvancedAABB(new AxisAlignedBB(baseAABB[4], baseAABB[0], baseAABB[2], baseAABB[5], baseAABB[1], baseAABB[3]).func_186670_a(this.func_174877_v()), null));
        return list;
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        if (box instanceof AdvancedAABB && box.func_186662_g(0.002).func_72318_a(mop.field_72307_f)) {
            AxisAlignedBB changedBox = ((AdvancedAABB)box).fd != null ? box.func_72314_b(((AdvancedAABB)box).fd.func_82601_c() != 0 ? 0.0 : 0.03125, ((AdvancedAABB)box).fd.func_96559_d() != 0 ? 0.0 : 0.03125, ((AdvancedAABB)box).fd.func_82599_e() != 0 ? 0.0 : 0.03125) : box;
            list.add(changedBox);
            return true;
        }
        return false;
    }

    String getRenderCacheKey() {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            if ((this.connections & 1 << i) != 0) {
                key.append(this.getConnectionStyle(i) == 1 ? "2" : "1");
                continue;
            }
            key.append("0");
        }
        if (!this.pipeCover.func_190926_b()) {
            key.append("scaf : ").append(this.pipeCover);
        }
        key.append(this.color);
        return key.toString();
    }

    private static short getConnectionsFromKey(String key) {
        short ret = 0;
        block5: for (int i = 0; i < 6; ++i) {
            char c = key.charAt(i);
            switch (c) {
                case '0': {
                    continue block5;
                }
                case '2': {
                    ret = (short)(ret | (1 << i | 1 << i + 8));
                    continue block5;
                }
                case '1': {
                    ret = (short)(ret | 1 << i);
                }
            }
        }
        return ret;
    }

    private static int getConnectionStyle(int dir, short conns) {
        return 1 & conns >> dir + 8;
    }

    public OBJModel.OBJState getOBJState() {
        String key = this.getRenderCacheKey();
        return TileEntityFluidPipe.getStateFromKey(key);
    }

    public static OBJModel.OBJState getStateFromKey(String key) {
        if (!cachedOBJStates.containsKey(key)) {
            ArrayList<String> parts = new ArrayList<String>();
            Matrix4 rotationMatrix = new Matrix4(TRSRTransformation.identity().getMatrix());
            short connections = TileEntityFluidPipe.getConnectionsFromKey(key);
            int totalConnections = Integer.bitCount(connections & 0xFF);
            boolean straightY = (connections & 3) == 3;
            boolean straightZ = (connections & 0xC) == 12;
            boolean straightX = (connections & 0x30) == 48;
            switch (totalConnections) {
                case 0: {
                    parts.add("center");
                    break;
                }
                case 1: {
                    parts.add("stopper");
                    if ((connections & 2) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                    } else if ((connections & 4) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 8) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    } else if ((connections & 0x20) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    }
                    parts.add("con_yMin");
                    break;
                }
                case 2: {
                    if (straightY) {
                        parts.add("pipe_y");
                        if (TileEntityFluidPipe.getConnectionStyle(0, connections) == 1) {
                            parts.add("con_yMin");
                        }
                        if (TileEntityFluidPipe.getConnectionStyle(1, connections) != 1) break;
                        parts.add("con_yMax");
                        break;
                    }
                    if (straightZ) {
                        parts.add("pipe_z");
                        if (TileEntityFluidPipe.getConnectionStyle(2, connections) == 1) {
                            parts.add("con_zMin");
                        }
                        if (TileEntityFluidPipe.getConnectionStyle(3, connections) != 1) break;
                        parts.add("con_zMax");
                        break;
                    }
                    if (straightX) {
                        parts.add("pipe_x");
                        if (TileEntityFluidPipe.getConnectionStyle(4, connections) == 1) {
                            parts.add("con_xMin");
                        }
                        if (TileEntityFluidPipe.getConnectionStyle(5, connections) != 1) break;
                        parts.add("con_xMax");
                        break;
                    }
                    parts.add("curve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    byte connectTo = (byte)(connections & 0x3C);
                    if ((connections & 3) != 0) {
                        if (connectTo == 16) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 32) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        } else if (connectTo == 8) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                    if (connectTo == 40) {
                        rotationMatrix.rotate(Math.PI, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo == 24) {
                        rotationMatrix.rotate(-1.5707963267948966, 1.0, 0.0, 0.0);
                        break;
                    }
                    if (connectTo != 36) break;
                    rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    if (straightX || straightZ || straightY) {
                        parts.add("tcross");
                        parts.add("con_yMin");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (straightX) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                            if ((connections & 4) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 2) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                            if ((connections & 0x10) != 0) {
                                rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 0x20) != 0) {
                                rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                                break;
                            }
                            if ((connections & 8) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x20) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(Math.PI, 0.0, 0.0, 1.0);
                        break;
                    }
                    parts.add("tcurve");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_xMax");
                    if ((connections & 8) != 0) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        } else {
                            rotationMatrix.rotate(-1.5707963267948966, 0.0, 1.0, 0.0);
                        }
                    } else if ((connections & 0x10) != 0) {
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 4: {
                    boolean cross;
                    boolean bl = cross = straightX && straightZ || straightX && straightY || straightZ && straightY;
                    if (cross) {
                        parts.add("cross");
                        parts.add("con_yMin");
                        parts.add("con_yMax");
                        parts.add("con_zMin");
                        parts.add("con_zMax");
                        if (!straightY) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                        break;
                    }
                    parts.add("tcross2");
                    parts.add("con_yMin");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if ((connections & 0x10) != 0) {
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                        }
                        if ((connections & 2) == 0) break;
                        rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (straightY) {
                        rotationMatrix.rotate(1.5707963267948966, 1.0, 0.0, 0.0);
                        if ((connections & 8) != 0) {
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                            break;
                        }
                        if ((connections & 0x10) == 0) break;
                        rotationMatrix.rotate(-1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) != 0) {
                        rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    }
                    if ((connections & 2) == 0) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 0.0, 1.0);
                    break;
                }
                case 5: {
                    parts.add("tcross3");
                    parts.add("con_yMin");
                    parts.add("con_yMax");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMax");
                    if (straightZ) {
                        if (straightY) {
                            if ((connections & 0x10) == 0) break;
                            rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                            break;
                        }
                        if (!straightX) break;
                        rotationMatrix.rotate((connections & 2) != 0 ? 1.5707963267948966 : -1.5707963267948966, 0.0, 0.0, 1.0);
                        break;
                    }
                    if (!straightX) break;
                    rotationMatrix.rotate(1.5707963267948966, 0.0, 1.0, 0.0);
                    if ((connections & 8) == 0) break;
                    rotationMatrix.rotate(Math.PI, 0.0, 1.0, 0.0);
                    break;
                }
                case 6: {
                    parts.add("con_yMin");
                    parts.add("con_yMax");
                    parts.add("con_zMin");
                    parts.add("con_zMax");
                    parts.add("con_xMin");
                    parts.add("con_xMax");
                }
            }
            Matrix4 tempMatr = new Matrix4();
            tempMatr.m23 = 0.5;
            tempMatr.m13 = 0.5;
            tempMatr.m03 = 0.5;
            rotationMatrix.leftMultiply(tempMatr);
            tempMatr.invert();
            rotationMatrix = rotationMatrix.multiply(tempMatr);
            cachedOBJStates.put(key, new OBJModel.OBJState(parts, true, (IModelState)new TRSRTransformation(rotationMatrix.toMatrix4f())));
        }
        return cachedOBJStates.get(key);
    }

    public int getRenderColour(int tintIndex) {
        return 0xFFFFFF;
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (heldItem.func_190926_b() && player.func_70093_af() && !this.pipeCover.func_190926_b()) {
            EntityItem entityitem;
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82736_K().func_82766_b("doTileDrops") && (entityitem = player.func_71019_a(this.pipeCover.func_77946_l(), false)) != null) {
                entityitem.func_174868_q();
            }
            this.pipeCover = ItemStack.field_190927_a;
            ITUtils.improvedMarkBlockForUpdate(this.field_145850_b, this.field_174879_c, null);
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 255, 0);
            return true;
        }
        if (!heldItem.func_190926_b() && !player.func_70093_af()) {
            for (Function<ItemStack, Boolean> func : validPipeCovers) {
                EntityItem entityitem;
                if (func.apply(heldItem) != Boolean.TRUE || OreDictionary.itemMatches((ItemStack)this.pipeCover, (ItemStack)heldItem, (boolean)true)) continue;
                if (!this.field_145850_b.field_72995_K && !this.pipeCover.func_190926_b() && this.field_145850_b.func_82736_K().func_82766_b("doTileDrops") && (entityitem = player.func_71019_a(this.pipeCover.func_77946_l(), false)) != null) {
                    entityitem.func_174868_q();
                }
                this.pipeCover = Utils.copyStackWithAmount((ItemStack)heldItem, (int)1);
                heldItem.func_190918_g(1);
                ITUtils.improvedMarkBlockForUpdate(this.field_145850_b, this.field_174879_c, null);
                this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 255, 0);
                return true;
            }
            int heldDye = Utils.getDye((ItemStack)heldItem);
            if (heldDye != -1) {
                this.color = EnumDyeColor.func_176766_a((int)heldDye);
                ITUtils.improvedMarkBlockForUpdate(this.field_145850_b, this.field_174879_c, null);
                return true;
            }
        }
        return false;
    }

    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        EnumFacing fd = side;
        List<AxisAlignedBB> boxes = this.getAdvancedSelectionBounds();
        for (AxisAlignedBB box : boxes) {
            if (!(box instanceof AdvancedAABB) || !box.func_186662_g(0.002).func_72318_a(new Vec3d((double)((float)this.func_174877_v().func_177958_n() + hitX), (double)((float)this.func_174877_v().func_177956_o() + hitY), (double)((float)this.func_174877_v().func_177952_p() + hitZ))) || ((AdvancedAABB)box).fd == null) continue;
            fd = ((AdvancedAABB)box).fd;
        }
        if (fd != null) {
            this.toggleSide(fd.ordinal());
            ITUtils.improvedMarkBlockForUpdate(this.field_145850_b, this.field_174879_c, null);
            indirectConnections.clear();
            return true;
        }
        return false;
    }

    public void onTilePlaced(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
        for (EnumFacing dir : EnumFacing.values()) {
            TileEntity te = world.func_175625_s(pos.func_177972_a(dir));
            if (!(te instanceof TileEntityFluidPipe) || ((TileEntityFluidPipe)te).color == this.color) continue;
            this.toggleSide(dir.ordinal());
        }
    }

    public boolean canOutputPressurized(boolean consumePower) {
        return false;
    }

    public boolean hasOutputConnection(EnumFacing side) {
        return side != null && this.sideConfig[side.ordinal()] == 0;
    }

    public int getRenderColour(IBlockState object, String group) {
        if (this.color != null) {
            return this.color.func_193350_e() | 0xFF000000;
        }
        return -1;
    }

    public static class DirectionalFluidOutput {
        IFluidHandler output;
        EnumFacing direction;
        TileEntity containingTile;

        public DirectionalFluidOutput(IFluidHandler output, TileEntity containingTile, EnumFacing direction) {
            this.output = output;
            this.direction = direction;
            this.containingTile = containingTile;
        }
    }

    static class PipeFluidHandler
    implements IFluidHandler {
        TileEntityFluidPipe pipe;
        EnumFacing facing;

        public PipeFluidHandler(TileEntityFluidPipe pipe, EnumFacing facing) {
            this.pipe = pipe;
            this.facing = facing;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(null, transferRatePressurized, true, false)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            int canAccept = resource.amount;
            if (canAccept <= 0) {
                return 0;
            }
            ArrayList<DirectionalFluidOutput> outputList = new ArrayList<DirectionalFluidOutput>(TileEntityFluidPipe.getConnectedFluidHandlersIT(this.pipe.func_174877_v(), this.pipe.field_145850_b));
            if (outputList.size() < 1) {
                return 0;
            }
            BlockPos ccFrom = new BlockPos((Vec3i)this.pipe.func_174877_v().func_177972_a(this.facing));
            int sum = 0;
            HashMap<DirectionalFluidOutput, Integer> sorting = new HashMap<DirectionalFluidOutput, Integer>();
            for (DirectionalFluidOutput output : outputList) {
                int limit;
                int tileSpecificAcceptedFluid;
                int temp;
                BlockPos cc = Utils.toCC((Object)output.containingTile);
                if (cc.equals((Object)ccFrom) || !this.pipe.field_145850_b.func_175667_e(cc) || this.pipe.equals(output.containingTile) || (temp = output.output.fill(Utils.copyFluidStackWithAmount((FluidStack)resource, (int)(tileSpecificAcceptedFluid = Math.min(limit = this.getTranferrableAmount(resource, output), canAccept)), (!(output.containingTile instanceof IFluidPipe) ? 1 : 0) != 0), false)) <= 0) continue;
                sorting.put(output, temp);
                sum += temp;
            }
            if (sum > 0) {
                int f = 0;
                for (DirectionalFluidOutput output : sorting.keySet()) {
                    int amount = (Integer)sorting.get(output);
                    if (sum > resource.amount) {
                        int limit = this.getTranferrableAmount(resource, output);
                        int tileSpecificAcceptedFluid = Math.min(limit, canAccept);
                        float prio = (float)amount / (float)sum;
                        amount = (int)Math.ceil(MathHelper.func_76131_a((float)amount, (float)1.0f, (float)Math.min((float)resource.amount * prio, (float)tileSpecificAcceptedFluid)));
                        amount = Math.min(amount, canAccept);
                    }
                    int r = output.output.fill(Utils.copyFluidStackWithAmount((FluidStack)resource, (int)amount, (!(output.containingTile instanceof IFluidPipe) ? 1 : 0) != 0), doFill);
                    f += r;
                    if ((canAccept -= r) > 0) continue;
                    break;
                }
                return f;
            }
            return 0;
        }

        private int getTranferrableAmount(FluidStack resource, DirectionalFluidOutput output) {
            return resource.tag != null && resource.tag.func_74764_b("pressurized") || ITContent.normallyPressurized.contains(resource.getFluid()) ? transferRatePressurized : transferRate;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

