/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Random;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.crafting.CoolingTowerRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.metal.multiblocks.MultiblockCoolingTower;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityCoolingTowerSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.ParticleSmokeCustomSize;
import mctmods.immersivetechnology.common.util.multiblock.PoICache;
import mctmods.immersivetechnology.common.util.multiblock.PoIJSONSchema;
import mctmods.immersivetechnology.common.util.network.BinaryMessageTileSync;
import mctmods.immersivetechnology.common.util.network.IBinaryMessageReceiver;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCoolingTowerMaster
extends TileEntityCoolingTowerSlave
implements ITFluidTank.TankListener,
IBinaryMessageReceiver {
    private static int inputTankSize = Config.ITConfig.Machines.CoolingTower.coolingTower_input_tankSize;
    private static int outputTankSize = Config.ITConfig.Machines.CoolingTower.coolingTower_output_tankSize;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(inputTankSize, this), new ITFluidTank(inputTankSize, this), new ITFluidTank(outputTankSize, this), new ITFluidTank(outputTankSize, this)};
    CoolingTowerRecipe recipe;
    private float soundVolume;
    private int gracePeriod = 60;
    private int clientUpdateCooldown = 1;
    private boolean isRunning;
    private PoICache input0;
    private PoICache input1;
    private PoICache output0;
    private PoICache output1;
    private BlockPos particleOrigin;
    private BlockPos soundOrigin;
    private BlockPos output0Front;
    private BlockPos output1Front;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank2"));
        this.tanks[3].readFromNBT(nbt.func_74775_l("tank3"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank2", (NBTBase)this.tanks[2].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank3", (NBTBase)this.tanks[3].writeToNBT(new NBTTagCompound()));
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        if (!this.isRunning) {
            return;
        }
        Random rand = new Random();
        if (rand.nextInt(40) == 0) {
            return;
        }
        int lessParticleSetting = ClientUtils.mc().field_71474_y.field_74362_aa;
        if (lessParticleSetting == 2 || lessParticleSetting == 1 && rand.nextInt(3) == 0) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double distanceLimit = 64.0;
        if (this.particleOrigin.func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v) > distanceLimit * distanceLimit) {
            return;
        }
        ParticleSmokeCustomSize cloud = new ParticleSmokeCustomSize(this.field_145850_b, (float)(this.particleOrigin.func_177958_n() + 2) - rand.nextFloat() * 3.0f, this.particleOrigin.func_177956_o(), (float)(this.particleOrigin.func_177952_p() + 2) - rand.nextFloat() * 3.0f, 0.0, 0.02f, 0.0, 7.0f);
        cloud.func_70538_b(1.0f, 1.0f, 1.0f);
        ClientUtils.mc().field_71452_i.func_78873_a((Particle)cloud);
    }

    public void notifyNearbyClients() {
        ByteBuf buffer = Unpooled.copyBoolean((boolean)this.isRunning);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllAround((IMessage)new BinaryMessageTileSync(center, buffer), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 40.0));
    }

    @Override
    public void receiveMessageFromServer(ByteBuf message) {
        this.isRunning = message.readBoolean();
    }

    public void handleSounds() {
        if (this.isRunning) {
            if (this.soundVolume < 1.0f) {
                this.soundVolume += 0.01f;
            }
        } else if (this.soundVolume > 0.0f) {
            this.soundVolume -= 0.01f;
        }
        if (this.soundVolume == 0.0f) {
            ITSoundHandler.StopSound(this.soundOrigin);
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float attenuation = Math.max((float)player.func_70092_e((double)this.soundOrigin.func_177958_n(), (double)this.soundOrigin.func_177956_o(), (double)this.soundOrigin.func_177952_p()) / 8.0f, 1.0f);
            ITSounds.coolingTower.PlayRepeating(this.soundOrigin, 10.0f * this.soundVolume / attenuation, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        ITSoundHandler.StopSound(this.soundOrigin);
        super.onChunkUnload();
    }

    @Override
    public void disassemble() {
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(this.soundOrigin), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.soundOrigin.func_177958_n(), (double)this.soundOrigin.func_177956_o(), (double)this.soundOrigin.func_177952_p(), 0.0));
        super.disassemble();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            if (this.input0 == null) {
                this.InitializePoIs();
            }
            this.handleSounds();
            this.spawnParticles();
            return;
        }
        this.pumpOutputOut();
        boolean update = false;
        if (this.processQueue.size() < this.getProcessQueueMaxLength() && (this.tanks[0].getFluidAmount() > 0 || this.tanks[1].getFluidAmount() > 0)) {
            TileEntityMultiblockMetal.MultiblockProcessInMachine process;
            this.recipe = CoolingTowerRecipe.findRecipe(this.tanks[0].getFluid(), this.tanks[1].getFluid());
            if (this.recipe != null && this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)(process = new TileEntityMultiblockMetal.MultiblockProcessInMachine((IMultiblockRecipe)this.recipe, new int[0]).setInputTanks(new int[]{0, 1})), true)) {
                this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process, false);
                update = true;
            }
        }
        if (this.tickedProcesses > 0) {
            this.isRunning = true;
            this.gracePeriod = 60;
        } else if (this.gracePeriod == 0) {
            this.isRunning = false;
        } else {
            --this.gracePeriod;
        }
        if (this.clientUpdateCooldown > 1) {
            --this.clientUpdateCooldown;
        } else {
            this.notifyNearbyClients();
            this.clientUpdateCooldown = 20;
        }
        if (update) {
            this.efficientMarkDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntityCoolingTowerMaster master() {
        this.master = this;
        return this;
    }

    private void InitializePoIs() {
        for (PoIJSONSchema poi : MultiblockCoolingTower.instance.pointsOfInterest) {
            if (poi.name.equals("input0")) {
                this.input0 = new PoICache(this.facing, poi, this.mirrored);
                continue;
            }
            if (poi.name.equals("input1")) {
                this.input1 = new PoICache(this.facing, poi, this.mirrored);
                continue;
            }
            if (poi.name.equals("output0")) {
                this.output0 = new PoICache(this.facing, poi, this.mirrored);
                this.output0Front = this.getBlockPosForPos(this.output0.position).func_177972_a(this.output0.facing);
                continue;
            }
            if (poi.name.equals("output1")) {
                this.output1 = new PoICache(this.facing, poi, this.mirrored);
                this.output1Front = this.getBlockPosForPos(this.output1.position).func_177972_a(this.output1.facing);
                continue;
            }
            if (poi.name.equals("particle")) {
                this.particleOrigin = this.getBlockPosForPos(poi.position);
                continue;
            }
            if (!poi.name.equals("sound")) continue;
            this.soundOrigin = this.getBlockPosForPos(poi.position);
        }
    }

    public IFluidTank[] getAccessibleFluidTanks(EnumFacing side, int position) {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (side == null) {
            return this.tanks;
        }
        if (this.input0.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[0]};
        }
        if (this.input1.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[1]};
        }
        if (this.output0.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[2]};
        }
        if (this.output1.isPoI(side, position)) {
            return new FluidTank[]{this.tanks[3]};
        }
        return ITUtils.emptyIFluidTankList;
    }

    public boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource, int position) {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (this.input0.isPoI(side, position)) {
            if (this.tanks[0].getFluidAmount() >= this.tanks[0].getCapacity()) {
                return false;
            }
            if (this.tanks[0].getFluid() == null) {
                return CoolingTowerRecipe.findRecipeByFluid0(resource.getFluid()) != null;
            }
            return resource.getFluid() == this.tanks[0].getFluid().getFluid();
        }
        if (this.input1.isPoI(side, position)) {
            if (this.tanks[1].getFluidAmount() >= this.tanks[1].getCapacity()) {
                return false;
            }
            if (this.tanks[1].getFluid() == null) {
                return CoolingTowerRecipe.findRecipeByFluid1(resource.getFluid()) != null;
            }
            return resource.getFluid() == this.tanks[1].getFluid().getFluid();
        }
        return false;
    }

    public boolean canDrainTankFrom(int iTank, EnumFacing side, int position) {
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (this.output0.isPoI(side, position)) {
            return this.tanks[2].getFluidAmount() > 0;
        }
        if (this.output1.isPoI(side, position)) {
            return this.tanks[3].getFluidAmount() > 0;
        }
        return false;
    }

    private void pumpOutputOut() {
        int drained;
        int accepted;
        FluidStack out;
        IFluidHandler output;
        if (this.input0 == null) {
            this.InitializePoIs();
        }
        if (this.tanks[2].getFluidAmount() > 0 && (output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.output0Front, (EnumFacing)this.output0.facing.func_176734_d())) != null) {
            out = this.tanks[2].getFluid();
            accepted = output.fill(out, false);
            if (accepted == 0) {
                return;
            }
            drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
            this.tanks[2].drain(drained, true);
        }
        if (this.tanks[3].getFluidAmount() > 0 && (output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.output1Front, (EnumFacing)this.output1.facing.func_176734_d())) != null) {
            out = this.tanks[3].getFluid();
            accepted = output.fill(out, false);
            if (accepted == 0) {
                return;
            }
            drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
            this.tanks[3].drain(drained, true);
        }
    }
}

