/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.crafting.BoilerRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityBoilerSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.network.MessageTileSync;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityBoilerMaster
extends TileEntityBoilerSlave
implements ITFluidTank.TankListener {
    private static int inputTankSize = Config.ITConfig.Machines.Boiler.boiler_input_tankSize;
    private static int outputTankSize = Config.ITConfig.Machines.Boiler.boiler_output_tankSize;
    private static int inputFuelTankSize = Config.ITConfig.Machines.Boiler.boiler_fuel_tankSize;
    private static int heatLossPerTick = Config.ITConfig.Machines.Boiler.boiler_heat_lossPerTick;
    private static int progressLossPerTick = Config.ITConfig.Machines.Boiler.boiler_progress_lossInTicks;
    private static double workingHeatLevel = Config.ITConfig.Machines.Boiler.boiler_heat_workingLevel;
    BlockPos fluidOutputPos;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(inputFuelTankSize, this), new ITFluidTank(inputTankSize, this), new ITFluidTank(outputTankSize, this)};
    public static int slotCount = 6;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
    public int burnRemaining = 0;
    public int recipeTimeRemaining = 0;
    public double heatLevel = 0.0;
    private int clientUpdateCooldown = 20;
    public BoilerRecipe.BoilerFuelRecipe lastFuel;
    public BoilerRecipe lastRecipe;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.tanks[2].readFromNBT(nbt.func_74775_l("tank2"));
        this.heatLevel = nbt.func_74769_h("heatLevel");
        this.burnRemaining = nbt.func_74762_e("burnRemaining");
        this.recipeTimeRemaining = nbt.func_74762_e("recipeTimeRemaining");
        if (!descPacket) {
            this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)slotCount);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank2", (NBTBase)this.tanks[2].writeToNBT(new NBTTagCompound()));
        nbt.func_74780_a("heatLevel", this.heatLevel);
        nbt.func_74768_a("burnRemaining", this.burnRemaining);
        nbt.func_74768_a("recipeTimeRemaining", this.recipeTimeRemaining);
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    private boolean heatUp() {
        double previousHeatLevel = this.heatLevel;
        if (this.lastFuel == null) {
            this.burnRemaining = 0;
            return true;
        }
        this.heatLevel = Math.min(this.lastFuel.getHeat() + this.heatLevel, workingHeatLevel);
        return previousHeatLevel != this.heatLevel;
    }

    private boolean cooldown() {
        double previousHeatLevel = this.heatLevel;
        this.heatLevel = Math.max(this.heatLevel - (double)heatLossPerTick, 0.0);
        return previousHeatLevel != this.heatLevel;
    }

    private boolean loseProgress() {
        int previousProgress = this.recipeTimeRemaining;
        if (this.lastRecipe == null) {
            this.recipeTimeRemaining = 0;
            return true;
        }
        this.recipeTimeRemaining = Math.min(this.recipeTimeRemaining + progressLossPerTick, this.lastRecipe.getTotalProcessTime());
        return previousProgress != this.recipeTimeRemaining;
    }

    private boolean gainProgress() {
        if (this.lastRecipe == null) {
            this.recipeTimeRemaining = 0;
            return true;
        }
        --this.recipeTimeRemaining;
        if (this.recipeTimeRemaining == 0) {
            this.tanks[1].drain(this.lastRecipe.fluidInput.amount, true);
            this.tanks[2].fillInternal(this.lastRecipe.fluidOutput, true);
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    private void pumpOutputOut() {
        IFluidHandler output;
        if (this.tanks[2].getFluidAmount() == 0) {
            return;
        }
        if (this.fluidOutputPos == null) {
            this.fluidOutputPos = ITUtils.LocalOffsetToWorldBlockPos(this.func_174877_v(), -2, 2, 1, this.facing, this.mirrored);
        }
        if ((output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.fluidOutputPos, (EnumFacing)EnumFacing.DOWN)) == null) {
            return;
        }
        FluidStack out = this.tanks[2].getFluid();
        int accepted = output.fill(out, false);
        if (accepted == 0) {
            return;
        }
        int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
        this.tanks[2].drain(drained, true);
    }

    public void handleSounds() {
        BlockPos center = this.func_174877_v();
        float level = (float)(this.heatLevel / workingHeatLevel);
        if (level == 0.0f) {
            ITSoundHandler.StopSound(center);
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float attenuation = Math.max((float)player.func_70092_e((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p()) / 8.0f, 1.0f);
            ITSounds.boiler.PlayRepeating(center, 2.0f * level / attenuation, level);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        ITSoundHandler.StopSound(this.func_174877_v());
        super.onChunkUnload();
    }

    public void disassemble() {
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(center), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
        super.disassemble();
    }

    public void notifyNearbyClients() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("heat", this.heatLevel);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllAround((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 40.0));
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        this.heatLevel = message.func_74769_h("heat");
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    private boolean heatLogic() {
        boolean update = false;
        if (this.burnRemaining > 0) {
            --this.burnRemaining;
            if (this.heatUp()) {
                update = true;
            }
        } else if (!this.isRSDisabled() && this.tanks[0].getFluid() != null) {
            BoilerRecipe.BoilerFuelRecipe fuel;
            BoilerRecipe.BoilerFuelRecipe boilerFuelRecipe = fuel = this.lastFuel != null && this.tanks[0].getFluid().isFluidEqual(this.lastFuel.fluidInput) ? this.lastFuel : BoilerRecipe.findFuel(this.tanks[0].getFluid());
            if (fuel != null && fuel.fluidInput.amount <= this.tanks[0].getFluidAmount()) {
                this.lastFuel = fuel;
                this.tanks[0].drain(fuel.fluidInput.amount, true);
                this.burnRemaining = fuel.getTotalProcessTime() - 1;
                this.markContainingBlockForUpdate(null);
                if (this.heatUp()) {
                    update = true;
                }
            } else if (this.cooldown()) {
                update = true;
            }
        } else if (this.cooldown()) {
            update = true;
        }
        return update;
    }

    private boolean recipeLogic() {
        boolean update = false;
        if (this.heatLevel >= workingHeatLevel) {
            if (this.recipeTimeRemaining > 0) {
                if (this.gainProgress()) {
                    update = true;
                }
            } else if (this.tanks[1].getFluid() != null) {
                BoilerRecipe recipe;
                BoilerRecipe boilerRecipe = recipe = this.lastRecipe != null && this.tanks[1].getFluid().isFluidEqual(this.lastRecipe.fluidInput) ? this.lastRecipe : BoilerRecipe.findRecipe(this.tanks[1].getFluid());
                if (recipe != null && recipe.fluidInput.amount <= this.tanks[1].getFluidAmount() && recipe.fluidOutput.amount == this.tanks[2].fillInternal(recipe.fluidOutput, false)) {
                    this.lastRecipe = recipe;
                    this.recipeTimeRemaining = recipe.getTotalProcessTime();
                    this.gainProgress();
                    update = true;
                }
            }
        } else if (this.recipeTimeRemaining > 0 && this.loseProgress()) {
            update = true;
        }
        return update;
    }

    private boolean outputTankLogic() {
        boolean update = false;
        if (this.tanks[2].getFluidAmount() > 0) {
            ItemStack filledContainer = Utils.fillFluidContainer((IFluidHandler)this.tanks[2], (ItemStack)((ItemStack)this.inventory.get(4)), (ItemStack)((ItemStack)this.inventory.get(5)), null);
            if (!filledContainer.func_190926_b()) {
                if (!((ItemStack)this.inventory.get(5)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(5)), (ItemStack)filledContainer, (boolean)true)) {
                    ((ItemStack)this.inventory.get(5)).func_190917_f(filledContainer.func_190916_E());
                } else if (((ItemStack)this.inventory.get(5)).func_190926_b()) {
                    this.inventory.set(5, (Object)filledContainer.func_77946_l());
                }
                ((ItemStack)this.inventory.get(4)).func_190918_g(1);
                if (((ItemStack)this.inventory.get(4)).func_190916_E() <= 0) {
                    this.inventory.set(4, (Object)ItemStack.field_190927_a);
                }
                this.markContainingBlockForUpdate(null);
                update = true;
            }
            this.pumpOutputOut();
        }
        return update;
    }

    private boolean fuelTankLogic() {
        int amount_prev = this.tanks[0].getFluidAmount();
        ItemStack emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[0], (ItemStack)((ItemStack)this.inventory.get(0)), (ItemStack)((ItemStack)this.inventory.get(1)), null);
        if (amount_prev != this.tanks[0].getFluidAmount()) {
            if (!((ItemStack)this.inventory.get(1)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)emptyContainer, (boolean)true)) {
                ((ItemStack)this.inventory.get(1)).func_190917_f(emptyContainer.func_190916_E());
            } else if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                this.inventory.set(1, (Object)emptyContainer.func_77946_l());
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(0)).func_190916_E() <= 0) {
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            }
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    private boolean inputTankLogic() {
        int amount_prev = this.tanks[1].getFluidAmount();
        ItemStack emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[1], (ItemStack)((ItemStack)this.inventory.get(2)), (ItemStack)((ItemStack)this.inventory.get(3)), null);
        if (amount_prev != this.tanks[1].getFluidAmount()) {
            if (!((ItemStack)this.inventory.get(3)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)emptyContainer, (boolean)true)) {
                ((ItemStack)this.inventory.get(3)).func_190917_f(emptyContainer.func_190916_E());
            } else if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
                this.inventory.set(3, (Object)emptyContainer.func_77946_l());
            }
            ((ItemStack)this.inventory.get(2)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(2)).func_190916_E() <= 0) {
                this.inventory.set(2, (Object)ItemStack.field_190927_a);
            }
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        if (!this.formed) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
            return;
        }
        boolean update = false;
        if (this.heatLogic()) {
            update = true;
        }
        if (this.recipeLogic()) {
            update = true;
        }
        if (this.outputTankLogic()) {
            update = true;
        }
        if (this.fuelTankLogic()) {
            update = true;
        }
        if (this.inputTankLogic()) {
            update = true;
        }
        if (this.clientUpdateCooldown > 1) {
            --this.clientUpdateCooldown;
        }
        if (update) {
            this.efficientMarkDirty();
            if (this.clientUpdateCooldown == 1) {
                this.notifyNearbyClients();
                this.clientUpdateCooldown = 20;
            }
        }
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntityBoilerMaster master() {
        this.master = this;
        return this;
    }
}

