/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Random;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityBarrelSteel;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.TranslationKey;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityBarrelOpen
extends TileEntityBarrelSteel {
    private static int tankSize = Config.ITConfig.Barrels.barrel_open_tankSize;
    private static int transferSpeed = Config.ITConfig.Barrels.barrel_open_transferSpeed;
    private int lastRandom = 0;
    private int sleep = 0;
    private static Random RANDOM = new Random();

    @Override
    public void createTank() {
        this.tank = new ITFluidTank(tankSize, this);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tank.getFluidAmount() != this.tank.getCapacity()) {
            int random = 1 + RANDOM.nextInt(100);
            if (random == this.lastRandom && (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == FluidRegistry.WATER)) {
                float temp = this.field_145850_b.func_72959_q().func_76939_a(this.field_145850_b.func_180494_b(this.field_174879_c).func_180626_a(this.field_174879_c), this.field_174879_c.func_177956_o());
                if (this.field_145850_b.func_72896_J() && this.field_145850_b.func_175678_i(this.field_174879_c) && temp > 0.05f && temp < 2.0f) {
                    int amount = 100;
                    if (this.field_145850_b.func_72911_I()) {
                        amount = 200;
                    }
                    this.tank.fill(new FluidStack(FluidRegistry.WATER, amount), true);
                } else if (temp >= 2.0f) {
                    this.tank.drain(Math.min(100, this.tank.getFluidAmount()), true);
                }
            }
            this.lastRandom = random;
        }
        for (int index = 0; index < 2; ++index) {
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig[index] != 1 || this.tank.getFluidAmount() <= 0) continue;
            EnumFacing face = EnumFacing.func_82600_a((int)index);
            IFluidHandler output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(face), (EnumFacing)face.func_176734_d());
            if (output == null) continue;
            if (this.sleep == 0) {
                FluidStack accepted = Utils.copyFluidStackWithAmount((FluidStack)this.tank.getFluid(), (int)Math.min(transferSpeed, this.tank.getFluidAmount()), (boolean)false);
                accepted.amount = output.fill(Utils.copyFluidStackWithAmount((FluidStack)accepted, (int)accepted.amount, (boolean)true), false);
                if (accepted.amount > 0) {
                    int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)accepted, (int)accepted.amount, (boolean)false), true);
                    this.tank.drain(drained, true);
                    this.sleep = 0;
                    continue;
                }
                this.sleep = 20;
                continue;
            }
            --this.sleep;
        }
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND))) {
            String[] stringArray;
            FluidStack fluid = this.tank.getFluid();
            if (fluid != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = TranslationKey.OVERLAY_OSD_BARREL_NORMAL_FIRST_LINE.format(fluid.getLocalizedName(), fluid.amount);
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = TranslationKey.GUI_EMPTY.text();
            }
            return stringArray;
        }
        return null;
    }

    @Override
    public boolean toggleSide(int side, EntityPlayer p) {
        return false;
    }

    @Override
    public boolean isFluidValid(FluidStack fluid) {
        return fluid != null && fluid.getFluid() != null && !fluid.getFluid().isGaseous(fluid);
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)heldItem);
        if (!this.isFluidValid(fluid)) {
            ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.noGasAllowed", new Object[0])});
            return true;
        }
        return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank);
    }
}

