/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.common.tileentities.TileEntityCommonOSD;
import mctmods.immersivetechnology.common.util.TranslationKey;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityBarrel
extends TileEntityCommonOSD
implements IFluidTank,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.ITileDrop,
IFluidTankProperties,
IFluidHandler {
    public FluidStack infiniteFluid;
    IFluidTankProperties[] tank = new IFluidTankProperties[]{this};

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        Fluid fluid = FluidRegistry.getFluid((String)nbt.func_74779_i("fluid"));
        if (fluid != null) {
            this.infiniteFluid = new FluidStack(fluid, Integer.MAX_VALUE);
        } else if (nbt.func_74764_b("tank") && nbt.func_74775_l("tank").func_74764_b("FluidName") && (fluid = FluidRegistry.getFluid((String)nbt.func_74775_l("tank").func_74779_i("FluidName"))) != null) {
            this.infiniteFluid = new FluidStack(fluid, Integer.MAX_VALUE);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.infiniteFluid != null) {
            nbt.func_74778_a("fluid", this.infiniteFluid.getFluid().getName());
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K || this.infiniteFluid == null) {
            return;
        }
        for (int index = 0; index < 6; ++index) {
            EnumFacing face = EnumFacing.func_82600_a((int)index);
            IFluidHandler output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(face), (EnumFacing)face.func_176734_d());
            if (output == null) continue;
            this.acceptedAmount += (long)output.fill(this.infiniteFluid, true);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public FluidStack getFluid() {
        return this.infiniteFluid;
    }

    public int getFluidAmount() {
        return Integer.MAX_VALUE;
    }

    @Nullable
    public FluidStack getContents() {
        return this.infiniteFluid;
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public boolean canFill() {
        return false;
    }

    public boolean canDrain() {
        return true;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return false;
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return fluidStack.getFluid() == this.infiniteFluid.getFluid();
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.infiniteFluid, Integer.MAX_VALUE);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack fluidStack, boolean b) {
        return this.drain(fluidStack.amount, b);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.infiniteFluid == null) {
            return null;
        }
        if (doDrain) {
            this.acceptedAmount += (long)maxDrain;
        }
        return new FluidStack(this.infiniteFluid, maxDrain);
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)heldItem);
        if (fluid != null) {
            this.infiniteFluid = new FluidStack(fluid, Integer.MAX_VALUE);
            this.efficientMarkDirty();
            return true;
        }
        if (player.func_70093_af()) {
            this.infiniteFluid = null;
            this.efficientMarkDirty();
            return true;
        }
        return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this);
    }

    @Override
    public void receiveMessageFromServer(NBTTagCompound message) {
        if (this.serializeNBT().func_74764_b("fluid")) {
            this.infiniteFluid = new FluidStack(FluidRegistry.getFluid((String)message.func_74779_i("fluid")), Integer.MAX_VALUE);
        }
        super.receiveMessageFromServer(message);
    }

    @Override
    public void notifyNearbyClients(NBTTagCompound nbt) {
        if (this.infiniteFluid != null) {
            nbt.func_74778_a("fluid", this.infiniteFluid.getFluid().getName());
        }
        super.notifyNearbyClients(nbt);
    }

    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        if (this.infiniteFluid != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("fluid", this.infiniteFluid.getFluid().getName());
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readCustomNBT(stack.func_77978_p(), false);
        }
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        return new String[]{this.infiniteFluid != null ? this.text().format(this.infiniteFluid.getLocalizedName(), this.lastAcceptedAmount) : TranslationKey.GUI_EMPTY.text()};
    }

    @Override
    public TranslationKey text() {
        return TranslationKey.OVERLAY_OSD_BARREL_NORMAL_FIRST_LINE;
    }
}

