/*
 * Decompiled with CFR 0.152.
 */
package tfctech.registry;

import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import tfctech.api.recipes.GlassworkingRecipe;
import tfctech.api.recipes.SmelteryRecipe;
import tfctech.api.recipes.WireDrawingRecipe;

@Mod.EventBusSubscriber(modid="tfctech")
public final class TechRegistries {
    public static IForgeRegistry<WireDrawingRecipe> WIRE_DRAWING;
    public static IForgeRegistry<SmelteryRecipe> SMELTERY;
    public static IForgeRegistry<GlassworkingRecipe> GLASSWORKING;

    @SubscribeEvent
    public static void onNewRegistryEvent(RegistryEvent.NewRegistry event) {
        WIRE_DRAWING = TechRegistries.createRegistry(new ResourceLocation("tfctech", "wire_drawing_recipe"), WireDrawingRecipe.class);
        SMELTERY = TechRegistries.createRegistry(new ResourceLocation("tfctech", "smeltery_recipe"), SmelteryRecipe.class);
        GLASSWORKING = TechRegistries.createRegistry(new ResourceLocation("tfctech", "glassworking_recipe"), GlassworkingRecipe.class);
    }

    private static <T extends IForgeRegistryEntry<T>> IForgeRegistry<T> createRegistry(ResourceLocation name, Class<T> tClass) {
        return new RegistryBuilder().setName(name).allowModification().setType(tClass).create();
    }
}

