/*
 * Decompiled with CFR 0.152.
 */
package tfctech.registry;

import java.util.ArrayList;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.recipes.WeldingRecipe;
import net.dries007.tfc.api.recipes.anvil.AnvilRecipe;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.recipes.heat.HeatRecipeSimple;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipe;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipeSimple;
import net.dries007.tfc.api.recipes.knapping.KnappingType;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.items.metal.ItemMetal;
import net.dries007.tfc.objects.recipes.ShapelessDamageRecipe;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.forge.ForgeRule;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import tfctech.TechConfig;
import tfctech.api.recipes.GlassworkingRecipe;
import tfctech.api.recipes.SmelteryRecipe;
import tfctech.api.recipes.WireDrawingRecipe;
import tfctech.objects.fluids.TechFluids;
import tfctech.objects.items.TechItems;
import tfctech.objects.items.glassworking.ItemBlowpipe;
import tfctech.objects.items.metal.ItemTechMetal;

@Mod.EventBusSubscriber(modid="tfctech")
public final class TechRecipes {
    @SubscribeEvent
    public static void onRecipeRegister(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)event.getRegistry();
        if (TechConfig.TWEAKS.removeGlassRecipes) {
            modRegistry.remove(new ResourceLocation("minecraft:glass_pane"));
            ArrayList removeList = new ArrayList();
            FurnaceRecipes.func_77602_a().func_77599_b().keySet().forEach(stack -> {
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                if (OreDictionaryHelper.doesStackMatchOre((ItemStack)result, (String)"blockGlass")) {
                    removeList.add(result);
                }
            });
            removeList.forEach(stack -> {
                ItemStack cfr_ignored_0 = (ItemStack)FurnaceRecipes.func_77602_a().func_77599_b().remove(stack);
            });
        }
    }

    @SubscribeEvent
    public static void onRegisterBarrelRecipeEvent(RegistryEvent.Register<BarrelRecipe> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new BarrelRecipe[]{(BarrelRecipe)new BarrelRecipe(IIngredient.of((Fluid)TechFluids.LATEX.get(), (int)100), IIngredient.of((ItemStack)new ItemStack((Item)TechItems.VULCANIZING_AGENTS)), null, new ItemStack((Item)TechItems.RUBBER_MIX, 6), 8000).setRegistryName("rubber_mix")});
    }

    @SubscribeEvent
    public static void onRegisterHeatRecipeEvent(RegistryEvent.Register<HeatRecipe> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new HeatRecipe[]{(HeatRecipe)new HeatRecipeSimple(IIngredient.of((ItemStack)new ItemStack((Item)TechItems.RUBBER_MIX)), new ItemStack((Item)TechItems.RUBBER), 600.0f, Metal.Tier.TIER_I).setRegistryName("rubber"), (HeatRecipe)new HeatRecipeSimple(IIngredient.of((ItemStack)new ItemStack((Item)TechItems.UNFIRED_RACKWHEEL_PIECE)), new ItemStack((Item)TechItems.MOLD_RACKWHEEL_PIECE), 1599.0f, Metal.Tier.TIER_I).setRegistryName("fired_mold_rackwheel"), (HeatRecipe)new HeatRecipeSimple(IIngredient.of((ItemStack)new ItemStack((Item)TechItems.UNFIRED_SLEEVE)), new ItemStack((Item)TechItems.MOLD_SLEEVE), 1599.0f, Metal.Tier.TIER_I).setRegistryName("fired_mold_sleeve"), (HeatRecipe)new HeatRecipeSimple(IIngredient.of((String)"dustWood"), new ItemStack((Item)TechItems.ASH), 850.0f, Metal.Tier.TIER_I).setRegistryName("ash"), (HeatRecipe)new HeatRecipeSimple(IIngredient.of((ItemStack)new ItemStack((Item)TechItems.ASH_POT)), new ItemStack((Item)TechItems.POTASH_POT), 500.0f, Metal.Tier.TIER_I).setRegistryName("potash_pot"), (HeatRecipe)new HeatRecipeSimple(IIngredient.of((String)"rockFlux"), new ItemStack((Item)TechItems.LIME, 2), 600.0f, Metal.Tier.TIER_I).setRegistryName("lime"), (HeatRecipe)new HeatRecipeSimple(IIngredient.of((ItemStack)new ItemStack((Item)TechItems.UNFIRED_MOLD_PANE)), new ItemStack((Item)TechItems.MOLD_PANE), 1599.0f, Metal.Tier.TIER_I).setRegistryName("fired_mold_pane"), (HeatRecipe)new HeatRecipeSimple(IIngredient.of((ItemStack)new ItemStack((Item)TechItems.UNFIRED_MOLD_BLOCK)), new ItemStack((Item)TechItems.MOLD_BLOCK), 1599.0f, Metal.Tier.TIER_I).setRegistryName("fired_mold_block")});
        IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)event.getRegistry();
        if (TechConfig.TWEAKS.removeGlassRecipes) {
            modRegistry.remove(new ResourceLocation("tfc", "glass"));
            modRegistry.remove(new ResourceLocation("tfc", "glass_shard"));
        }
    }

    @SubscribeEvent
    public static void onRegisterAnvilRecipeEvent(RegistryEvent.Register<AnvilRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfctech", "iron_groove"), IIngredient.of((Item)ItemTechMetal.get(Metal.WROUGHT_IRON, ItemTechMetal.ItemType.STRIP)), new ItemStack((Item)TechItems.IRON_GROOVE), Metal.Tier.TIER_III, null, new ForgeRule[]{ForgeRule.HIT_LAST, ForgeRule.BEND_SECOND_LAST, ForgeRule.BEND_THIRD_LAST}));
        r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfctech", "iron_bowl_mount"), IIngredient.of((Item)ItemMetal.get((Metal)Metal.WROUGHT_IRON, (Metal.ItemType)Metal.ItemType.INGOT)), new ItemStack((Item)TechItems.IRON_BOWL_MOUNT), Metal.Tier.TIER_III, null, new ForgeRule[]{ForgeRule.BEND_LAST, ForgeRule.DRAW_SECOND_LAST, ForgeRule.BEND_NOT_LAST}));
        r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfctech", "iron_tongs"), IIngredient.of((Item)ItemMetal.get((Metal)Metal.WROUGHT_IRON, (Metal.ItemType)Metal.ItemType.INGOT)), new ItemStack((Item)TechItems.IRON_TONGS), Metal.Tier.TIER_III, null, new ForgeRule[]{ForgeRule.HIT_LAST, ForgeRule.DRAW_SECOND_LAST, ForgeRule.BEND_THIRD_LAST}));
        r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfctech", "iron_draw_plate"), IIngredient.of((Item)ItemMetal.get((Metal)Metal.WROUGHT_IRON, (Metal.ItemType)Metal.ItemType.INGOT)), new ItemStack((Item)TechItems.IRON_DRAW_PLATE), Metal.Tier.TIER_III, null, new ForgeRule[]{ForgeRule.PUNCH_LAST, ForgeRule.PUNCH_SECOND_LAST, ForgeRule.HIT_ANY}));
        r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfctech", "steel_draw_plate"), IIngredient.of((Item)ItemMetal.get((Metal)((Metal)TFCRegistries.METALS.getValue(new ResourceLocation("tfc", "steel"))), (Metal.ItemType)Metal.ItemType.INGOT)), new ItemStack((Item)TechItems.STEEL_DRAW_PLATE), Metal.Tier.TIER_IV, null, new ForgeRule[]{ForgeRule.PUNCH_LAST, ForgeRule.PUNCH_SECOND_LAST, ForgeRule.HIT_ANY}));
        r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfctech", "black_steel_draw_plate"), IIngredient.of((Item)ItemMetal.get((Metal)((Metal)TFCRegistries.METALS.getValue(new ResourceLocation("tfc", "black_steel"))), (Metal.ItemType)Metal.ItemType.INGOT)), new ItemStack((Item)TechItems.BLACK_STEEL_DRAW_PLATE), Metal.Tier.TIER_V, null, new ForgeRule[]{ForgeRule.PUNCH_LAST, ForgeRule.PUNCH_SECOND_LAST, ForgeRule.HIT_ANY}));
        for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
            ItemStack output;
            IIngredient ingredient;
            if (ObfuscationReflectionHelper.getPrivateValue(Metal.class, (Object)metal, (String)"usable").equals(false)) continue;
            IMetalItem item = ItemTechMetal.get(metal, ItemTechMetal.ItemType.STRIP);
            if (item != null) {
                ItemStack output2;
                ingredient = IIngredient.of((ItemStack)new ItemStack((Item)item));
                ItemTechMetal outputItem = ItemTechMetal.get(metal, ItemTechMetal.ItemType.WIRE);
                if (outputItem != null && !(output2 = new ItemStack((Item)outputItem, 1, 4)).func_190926_b()) {
                    r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfctech", metal.getRegistryName().func_110623_a().toLowerCase() + "_wire"), ingredient, output2, metal.getTier(), null, new ForgeRule[]{ForgeRule.DRAW_LAST, ForgeRule.DRAW_NOT_LAST}));
                }
            }
            ingredient = IIngredient.of((ItemStack)new ItemStack(ItemMetal.get((Metal)metal, (Metal.ItemType)Metal.ItemType.INGOT)));
            item = ItemTechMetal.get(metal, ItemTechMetal.ItemType.LONG_ROD);
            if (item != null && !(output = new ItemStack((Item)item)).func_190926_b()) {
                r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfctech", metal.getRegistryName().func_110623_a().toLowerCase() + "_long_rod"), ingredient, output, metal.getTier(), null, new ForgeRule[]{ForgeRule.HIT_LAST, ForgeRule.HIT_SECOND_LAST, ForgeRule.HIT_THIRD_LAST}));
            }
            ingredient = IIngredient.of((ItemStack)new ItemStack(ItemMetal.get((Metal)metal, (Metal.ItemType)Metal.ItemType.SHEET)));
            item = ItemBlowpipe.get(metal);
            if (item == null || (output = new ItemStack((Item)item)).func_190926_b()) continue;
            r.register((IForgeRegistryEntry)new AnvilRecipe(new ResourceLocation("tfctech", metal.getRegistryName().func_110623_a().toLowerCase() + "_blowpipe"), ingredient, output, metal.getTier(), null, new ForgeRule[]{ForgeRule.BEND_LAST, ForgeRule.BEND_SECOND_LAST}));
        }
    }

    @SubscribeEvent
    public static void onRegisterKnappingRecipeEvent(RegistryEvent.Register<KnappingRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        r.registerAll((IForgeRegistryEntry[])new KnappingRecipe[]{(KnappingRecipe)new KnappingRecipeSimple(KnappingType.CLAY, true, new ItemStack((Item)TechItems.UNFIRED_SLEEVE), new String[]{"XXXXX", "XX XX", "X X X", "XX XX", "XXXXX"}).setRegistryName("clay_sleeve"), (KnappingRecipe)new KnappingRecipeSimple(KnappingType.CLAY, true, new ItemStack((Item)TechItems.UNFIRED_RACKWHEEL_PIECE), new String[]{"XXXXX", "X XXX", "X  XX", "XX  X", "XXXXX"}).setRegistryName("clay_rackwheel_piece"), (KnappingRecipe)new KnappingRecipeSimple(KnappingType.CLAY, true, new ItemStack((Item)TechItems.UNFIRED_MOLD_PANE), new String[]{"XXXXX", "X   X", "X   X", "X   X", "XXXXX"}).setRegistryName("clay_mold_pane"), (KnappingRecipe)new KnappingRecipeSimple(KnappingType.CLAY, true, new ItemStack((Item)TechItems.UNFIRED_MOLD_BLOCK), new String[]{"X   X", "X   X", "X   X", "X   X", " XXX "}).setRegistryName("clay_mold_block")});
    }

    @SubscribeEvent
    public static void onRegisterGlassworkingRecipeEvent(RegistryEvent.Register<GlassworkingRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        r.registerAll((IForgeRegistryEntry[])new GlassworkingRecipe[]{(GlassworkingRecipe)new GlassworkingRecipe(new ItemStack(Items.field_151069_bo), " X X ", " X X ", "X   X", "X   X", " XXX ").setRegistryName("tfctech", "glass_bottle")});
    }

    @SubscribeEvent
    public static void onRegisterSmelteryRecipeEvent(RegistryEvent.Register<SmelteryRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        r.registerAll((IForgeRegistryEntry[])new SmelteryRecipe[]{(SmelteryRecipe)new SmelteryRecipe.Builder().addInput((IIngredient<ItemStack>)IIngredient.of((String)"dustPotash")).addInput((IIngredient<ItemStack>)IIngredient.of((String)"sandSilica")).addInput((IIngredient<ItemStack>)IIngredient.of((String)"dustLime")).setOutput(new FluidStack(TechFluids.GLASS.get(), 1000), 800.0f).build().setRegistryName(new ResourceLocation("tfctech", "glass")), (SmelteryRecipe)new SmelteryRecipe.Builder().addInput((IIngredient<ItemStack>)IIngredient.of((String)"blockGlass")).setOutput(new FluidStack(TechFluids.GLASS.get(), 1000), 800.0f).build().setRegistryName(new ResourceLocation("tfctech", "glass_block")), (SmelteryRecipe)new SmelteryRecipe.Builder().addInput((IIngredient<ItemStack>)IIngredient.of((String)"paneGlass")).setOutput(new FluidStack(TechFluids.GLASS.get(), 375), 800.0f).build().setRegistryName(new ResourceLocation("tfctech", "glass_pane")), (SmelteryRecipe)new SmelteryRecipe.Builder().addInput((IIngredient<ItemStack>)IIngredient.of((Item)ItemsTFC.GLASS_SHARD)).setOutput(new FluidStack(TechFluids.GLASS.get(), 500), 800.0f).build().setRegistryName(new ResourceLocation("tfctech", "glass_shard")), (SmelteryRecipe)new SmelteryRecipe.Builder().addInput((IIngredient<ItemStack>)IIngredient.of((Item)Items.field_151069_bo)).setOutput(new FluidStack(TechFluids.GLASS.get(), 250), 800.0f).build().setRegistryName(new ResourceLocation("tfctech", "glass_bottle"))});
    }

    @SubscribeEvent
    public static void onRegisterWireDrawingRecipeEvent(RegistryEvent.Register<WireDrawingRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
            if (ObfuscationReflectionHelper.getPrivateValue(Metal.class, (Object)metal, (String)"usable").equals(false)) continue;
            for (int i = 4; i > 0; --i) {
                IIngredient ingredient = IIngredient.of((ItemStack)new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.WIRE), 1, i));
                ItemStack output = new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.WIRE), 1, i - 1);
                Metal.Tier tier = metal.getTier();
                int color = metal.getColor();
                if (output.func_190926_b()) continue;
                r.register((IForgeRegistryEntry)new WireDrawingRecipe(new ResourceLocation("tfctech", metal.getRegistryName().func_110623_a().toLowerCase() + "_wire_" + i), (IIngredient<ItemStack>)ingredient, tier, output, color));
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterWeldingRecipeEvent(RegistryEvent.Register<WeldingRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
            if (ObfuscationReflectionHelper.getPrivateValue(Metal.class, (Object)metal, (String)"usable").equals(false)) continue;
            IIngredient ingredient1 = IIngredient.of((ItemStack)new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.RACKWHEEL)));
            IIngredient ingredient2 = metal.getTier().isAtMost(Metal.Tier.TIER_II) ? IIngredient.of((ItemStack)new ItemStack((Item)TechItems.TIN_SLEEVE)) : (metal.getTier().isAtMost(Metal.Tier.TIER_IV) ? IIngredient.of((ItemStack)new ItemStack((Item)TechItems.BRASS_SLEEVE)) : IIngredient.of((ItemStack)new ItemStack((Item)TechItems.STEEL_SLEEVE)));
            ItemStack output = new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.GEAR));
            if (output.func_190926_b()) continue;
            r.register((IForgeRegistryEntry)new WeldingRecipe(new ResourceLocation("tfctech", metal.getRegistryName().func_110623_a().toLowerCase() + "_gear"), ingredient1, ingredient2, output, metal.getTier(), null));
        }
    }

    @SubscribeEvent
    public static void onRegisterCraftingRecipeEvent(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry r = event.getRegistry();
        ArrayList<ItemStack> allChisels = new ArrayList<ItemStack>();
        for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
            if (!metal.isToolMetal()) continue;
            allChisels.add(new ItemStack(ItemMetal.get((Metal)metal, (Metal.ItemType)Metal.ItemType.CHISEL), 1, Short.MAX_VALUE));
        }
        Ingredient chisel = Ingredient.func_193369_a((ItemStack[])allChisels.toArray(new ItemStack[0]));
        ResourceLocation groupStrip = new ResourceLocation("tfctech", "strip");
        ResourceLocation groupRod = new ResourceLocation("tfctech", "rod");
        ResourceLocation groupBolt = new ResourceLocation("tfctech", "bolt");
        ResourceLocation groupScrew = new ResourceLocation("tfctech", "screw");
        for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
            NonNullList list;
            if (ObfuscationReflectionHelper.getPrivateValue(Metal.class, (Object)metal, (String)"usable").equals(false)) continue;
            Ingredient ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(ItemMetal.get((Metal)metal, (Metal.ItemType)Metal.ItemType.SHEET))});
            ItemStack output = new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.STRIP), 4);
            if (!output.func_190926_b()) {
                list = NonNullList.func_191196_a();
                list.add((Object)chisel);
                list.add((Object)ingredient);
                r.register(new ShapelessDamageRecipe(groupStrip, list, output, 1).setRegistryName("tfctech", metal.getRegistryName().func_110623_a().toLowerCase() + "_strip"));
            }
            ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.LONG_ROD))});
            output = new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.ROD), 2);
            if (!output.func_190926_b()) {
                list = NonNullList.func_191196_a();
                list.add((Object)chisel);
                list.add((Object)ingredient);
                r.register(new ShapelessDamageRecipe(groupRod, list, output, 1).setRegistryName("tfctech", metal.getRegistryName().func_110623_a().toLowerCase() + "_rod"));
            }
            ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.ROD))});
            output = new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.BOLT), 2);
            if (!output.func_190926_b()) {
                list = NonNullList.func_191196_a();
                list.add((Object)chisel);
                list.add((Object)ingredient);
                r.register(new ShapelessDamageRecipe(groupBolt, list, output, 1).setRegistryName("tfctech", metal.getRegistryName().func_110623_a().toLowerCase() + "_bolt"));
            }
            ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.BOLT))});
            output = new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.SCREW));
            if (!output.func_190926_b()) {
                list = NonNullList.func_191196_a();
                list.add((Object)chisel);
                list.add((Object)ingredient);
                r.register(new ShapelessDamageRecipe(groupScrew, list, output, 1).setRegistryName("tfctech", metal.getRegistryName().func_110623_a().toLowerCase() + "_screw"));
            }
            ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.RACKWHEEL_PIECE))});
            output = new ItemStack((Item)ItemTechMetal.get(metal, ItemTechMetal.ItemType.RACKWHEEL));
            if (output.func_190926_b()) continue;
            list = NonNullList.func_191196_a();
            list.add((Object)ingredient);
            list.add((Object)ingredient);
            list.add((Object)ingredient);
            list.add((Object)ingredient);
            r.register(new ShapedRecipes("rackwheel", 2, 2, list, output).setRegistryName("tfctech", metal.getRegistryName().func_110623_a().toLowerCase() + "_rackwheel"));
        }
    }
}

