/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.tileentities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.te.TEInventory;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.TFCTech;
import tfctech.api.recipes.WireDrawingRecipe;
import tfctech.client.TechSounds;
import tfctech.network.PacketTileEntityUpdate;
import tfctech.objects.items.metal.ItemTechMetal;
import tfctech.registry.TechRegistries;

public class TEWireDrawBench
extends TEInventory
implements ITickable {
    private int progress = 0;
    private int lastProgress = 0;
    private boolean working = false;
    private int cachedWireColor = 0;

    public TEWireDrawBench() {
        super(2);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        switch (slot) {
            case 0: {
                return stack.func_77973_b() instanceof ItemTechMetal && ((ItemTechMetal)stack.func_77973_b()).getType() == ItemTechMetal.ItemType.DRAW_PLATE;
            }
            case 1: {
                WireDrawingRecipe recipe = TechRegistries.WIRE_DRAWING.getValuesCollection().stream().filter(x -> x.matches(stack)).findFirst().orElse(null);
                return recipe != null;
            }
        }
        return false;
    }

    public boolean hasDrawPlate() {
        return this.inventory.getStackInSlot(0) != ItemStack.field_190927_a;
    }

    public boolean hasWire() {
        WireDrawingRecipe recipe = TechRegistries.WIRE_DRAWING.getValuesCollection().stream().filter(x -> x.matches(this.inventory.getStackInSlot(1))).findFirst().orElse(null);
        return recipe != null;
    }

    public boolean startWork(EntityPlayer player) {
        if (this.canWork()) {
            if (this.progress == 0) {
                WireDrawingRecipe recipe = TechRegistries.WIRE_DRAWING.getValuesCollection().stream().filter(x -> x.matches(this.inventory.getStackInSlot(1))).findFirst().orElse(null);
                Metal.Tier workableTier = ((ItemTechMetal)this.inventory.getStackInSlot(0).func_77973_b()).getMetal(this.inventory.getStackInSlot(0)).getTier();
                if (recipe == null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.tfctech.wiredraw.no_recipe", new Object[0]), true);
                    return false;
                }
                if (!recipe.getTier().isAtMost(workableTier)) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, TechSounds.WIREDRAW_TONGS_FALL, SoundCategory.BLOCKS, 1.0f, 2.0f);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.tfctech.wiredraw.low_tier", new Object[0]), true);
                    return true;
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, TechSounds.WIREDRAW_DRAWING, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.working = true;
                this.setAndUpdateSlots(0);
            }
            return true;
        }
        return false;
    }

    public ItemStack insertWire(@Nonnull ItemStack stack, boolean simulate) {
        if (!this.hasWire() && this.hasDrawPlate() && this.isItemValid(1, stack)) {
            ItemStack output = this.inventory.insertItem(1, stack, simulate);
            if (!simulate) {
                this.cachedWireColor = 0;
                TechRegistries.WIRE_DRAWING.getValuesCollection().stream().filter(x -> x.matches(stack)).findFirst().ifPresent(x -> {
                    this.cachedWireColor = x.getWireColor();
                });
                this.setAndUpdateSlots(0);
            }
            return output;
        }
        return stack;
    }

    public ItemStack insertDrawPlate(@Nonnull ItemStack stack, boolean simulate) {
        if (!this.hasDrawPlate() && this.isItemValid(0, stack)) {
            ItemStack output = this.inventory.insertItem(0, stack, simulate);
            if (!simulate) {
                this.setAndUpdateSlots(0);
            }
            return output;
        }
        return stack;
    }

    public void setAndUpdateSlots(int slot) {
        TFCTech.getNetwork().sendToAllTracking((IMessage)new PacketTileEntityUpdate((TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
        super.setAndUpdateSlots(slot);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.cachedWireColor = nbt.func_74762_e("wireColor");
        this.working = nbt.func_74767_n("working");
        this.lastProgress = this.progress = nbt.func_74762_e("progress");
        super.func_145839_a(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("wireColor", this.cachedWireColor);
        nbt.func_74757_a("working", this.working);
        nbt.func_74768_a("progress", this.progress);
        return super.func_189515_b(nbt);
    }

    @Nonnull
    public ItemStack extractItem(int slot, boolean simulate) {
        if (slot < 0 || slot > 1 || this.progress > 0 && this.progress < 100) {
            return ItemStack.field_190927_a;
        }
        if (slot == 1 && !simulate) {
            this.cachedWireColor = 0;
            this.progress = 0;
        }
        ItemStack output = this.inventory.extractItem(slot, 64, simulate);
        if (!simulate) {
            this.setAndUpdateSlots(slot);
        }
        return output;
    }

    @Nullable
    public Metal getDrawPlateMetal() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_77973_b() instanceof ItemTechMetal) {
            return ((ItemTechMetal)stack.func_77973_b()).getMetal(stack);
        }
        return null;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getLastProgress() {
        return this.lastProgress;
    }

    public int getWireColor() {
        return this.inventory.getStackInSlot(1) != ItemStack.field_190927_a ? this.cachedWireColor : 0;
    }

    public EnumFacing getRotation() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
    }

    public void func_73660_a() {
        this.lastProgress = this.progress++;
        if (this.working && this.progress % 25 == 0) {
            this.working = false;
            if (this.progress >= 100 && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, TechSounds.WIREDRAW_TONGS_FALL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (this.inventory.getStackInSlot(0).func_96631_a(32, Constants.RNG, null)) {
                    this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                }
                TechRegistries.WIRE_DRAWING.getValuesCollection().stream().filter(x -> x.matches(this.inventory.getStackInSlot(1))).findFirst().ifPresent(recipe -> this.inventory.setStackInSlot(1, recipe.getOutput()));
                this.setAndUpdateSlots(1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    private boolean canWork() {
        return this.hasDrawPlate() && this.hasWire() && !this.working && this.progress < 100;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }
}

