/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.tileentities;

import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.te.ITileFields;
import net.dries007.tfc.objects.te.TETickableInventory;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.fuel.Fuel;
import net.dries007.tfc.util.fuel.FuelManager;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import tfctech.objects.blocks.devices.BlockSmelteryCauldron;

public class TESmelteryFirebox
extends TETickableInventory
implements ITickable,
ICalendarTickable,
ITileFields {
    private float temperature = 0.0f;
    private float burnTemperature = 0.0f;
    private int burnTicks = 0;
    private int airTicks = 0;
    private long lastPlayerTick = CalendarTFC.PLAYER_TIME.getTicks();
    private int reload = 0;

    public TESmelteryFirebox() {
        super(8);
    }

    public int getFieldCount() {
        return 2;
    }

    public void setField(int index, int value) {
        switch (index) {
            case 0: {
                this.temperature = value;
                break;
            }
            case 1: {
                this.burnTicks = value;
            }
        }
    }

    public int getField(int index) {
        switch (index) {
            case 0: {
                return (int)this.temperature;
            }
            case 1: {
                return this.burnTicks;
            }
        }
        return 0;
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.checkForCalendarUpdate();
        if (!this.field_145850_b.field_72995_K) {
            float targetTemperature;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT)).booleanValue()) {
                this.burnTicks -= this.airTicks > 0 ? 2 : 1;
                if (--this.airTicks <= 0) {
                    this.airTicks = 0;
                }
                if (this.burnTicks <= 0) {
                    this.consumeFuel();
                }
                if (this.reload++ >= 20) {
                    this.reload = 0;
                    if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() instanceof BlockSmelteryCauldron)) {
                        this.temperature = 0.0f;
                        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(false)));
                        this.burnTicks = 0;
                        this.airTicks = 0;
                    }
                }
            } else {
                this.burnTemperature = 0.0f;
                this.burnTicks = 0;
                this.airTicks = 0;
            }
            if ((this.temperature > 0.0f || this.burnTemperature > 0.0f) && this.temperature != (targetTemperature = this.burnTemperature + (float)this.airTicks)) {
                float delta = (float)ConfigTFC.Devices.TEMPERATURE.heatingModifier;
                this.temperature = CapabilityItemHeat.adjustTempTowards((float)this.temperature, (float)targetTemperature, (float)(delta * (float)(this.airTicks > 0 ? 2 : 1)));
            }
        }
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public boolean onIgnite() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT)).booleanValue()) {
            this.consumeFuel();
            return (Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT);
        }
        return false;
    }

    public void onCalendarUpdate(long deltaPlayerTicks) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT)).booleanValue()) {
            return;
        }
        while (deltaPlayerTicks > 0L) {
            float delta;
            if ((long)this.burnTicks > deltaPlayerTicks) {
                this.burnTicks = (int)((long)this.burnTicks - deltaPlayerTicks);
                delta = (float)ConfigTFC.Devices.TEMPERATURE.heatingModifier * (float)deltaPlayerTicks;
                this.temperature = CapabilityItemHeat.adjustTempTowards((float)this.temperature, (float)this.burnTemperature, (float)delta, (float)delta);
                deltaPlayerTicks = 0L;
                continue;
            }
            deltaPlayerTicks -= (long)this.burnTicks;
            delta = (float)ConfigTFC.Devices.TEMPERATURE.heatingModifier * (float)this.burnTicks;
            this.temperature = CapabilityItemHeat.adjustTempTowards((float)this.temperature, (float)this.burnTemperature, (float)delta, (float)delta);
            this.consumeFuel();
        }
    }

    public long getLastUpdateTick() {
        return this.lastPlayerTick;
    }

    public void setLastUpdateTick(long ticks) {
        this.lastPlayerTick = ticks;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return FuelManager.isItemFuel((ItemStack)stack);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.temperature = nbt.func_74760_g("temperature");
        this.burnTemperature = nbt.func_74760_g("burnTemperature");
        this.burnTicks = nbt.func_74762_e("burnTicks");
        this.lastPlayerTick = nbt.func_74763_f("lastPlayerTick");
        this.airTicks = nbt.func_74762_e("airTicks");
        super.func_145839_a(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74776_a("temperature", this.temperature);
        nbt.func_74768_a("burnTicks", this.burnTicks);
        nbt.func_74776_a("burnTemperature", this.burnTemperature);
        nbt.func_74772_a("lastPlayerTick", this.lastPlayerTick);
        nbt.func_74768_a("airTicks", this.airTicks);
        return super.func_189515_b(nbt);
    }

    public void onAirIntake(int airAmount) {
        this.airTicks += airAmount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    private void consumeFuel() {
        this.burnTicks = 0;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        for (int i = 0; i < 8; ++i) {
            ItemStack stack = this.inventory.extractItem(i, 1, false);
            if (stack.func_190926_b()) continue;
            Fuel fuel = FuelManager.getFuel((ItemStack)stack);
            this.burnTicks = fuel.getAmount();
            this.burnTemperature = fuel.getTemperature();
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(true)));
            break;
        }
        if (this.burnTicks <= 0) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(false)));
            this.burnTicks = 0;
            this.airTicks = 0;
            this.burnTemperature = 0.0f;
        }
    }
}

