/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.tileentities;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.objects.fluids.capability.FluidHandlerSided;
import net.dries007.tfc.objects.fluids.capability.FluidTankCallback;
import net.dries007.tfc.objects.fluids.capability.IFluidHandlerSidedCallback;
import net.dries007.tfc.objects.fluids.capability.IFluidTankCallback;
import net.dries007.tfc.objects.te.ITileFields;
import net.dries007.tfc.objects.te.TEInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tfctech.api.recipes.SmelteryRecipe;
import tfctech.objects.blocks.devices.BlockSmelteryCauldron;
import tfctech.objects.tileentities.TESmelteryFirebox;

@ParametersAreNonnullByDefault
public class TESmelteryCauldron
extends TEInventory
implements ITickable,
IFluidHandlerSidedCallback,
IFluidTankCallback,
ITileFields {
    public static final int FLUID_CAPACITY = 4000;
    private final FluidTank tank = new FluidTankCallback((IFluidTankCallback)this, 0, 4000);
    private float temp;
    private int reload = 0;

    public TESmelteryCauldron() {
        super(8);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ++this.reload >= 10) {
            this.reload = 0;
            TESmelteryFirebox firebox = (TESmelteryFirebox)Helpers.getTE((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), TESmelteryFirebox.class);
            this.temp = firebox != null ? firebox.getTemperature() : 0.0f;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (this.temp > 0.0f && !((Boolean)state.func_177229_b((IProperty)BlockSmelteryCauldron.LIT)).booleanValue()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockSmelteryCauldron.LIT, (Comparable)Boolean.valueOf(true)));
            } else if (this.temp <= 0.0f && ((Boolean)state.func_177229_b((IProperty)BlockSmelteryCauldron.LIT)).booleanValue()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockSmelteryCauldron.LIT, (Comparable)Boolean.valueOf(false)));
            }
            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
            for (int i = 0; i < 8; ++i) {
                input.add(this.inventory.extractItem(i, 64, true));
            }
            SmelteryRecipe recipe = SmelteryRecipe.get(input.toArray(new ItemStack[0]));
            if (recipe != null) {
                FluidStack output = recipe.getOutput();
                if (recipe.getMeltTemp() <= this.temp && this.tank.fill(output, false) >= output.amount) {
                    recipe.consumeInputs(input);
                    for (int i = 0; i < 8; ++i) {
                        this.inventory.setStackInSlot(i, (ItemStack)input.get(i));
                    }
                    this.tank.fillInternal(output, true);
                    this.temp = (float)((double)this.temp - ConfigTFC.Devices.TEMPERATURE.heatingModifier * 150.0);
                    if (firebox != null) {
                        firebox.setTemperature(this.temp);
                    }
                }
            }
        }
    }

    public FluidStack getFluid() {
        return this.tank.drain(4000, false);
    }

    public float getTemp() {
        return this.temp;
    }

    public boolean isSolidified() {
        FluidStack fluid = this.getFluid();
        return fluid != null && this.temp + 273.0f < (float)fluid.getFluid().getTemperature();
    }

    public boolean canFill(FluidStack fluidStack, EnumFacing enumFacing) {
        return false;
    }

    public boolean canDrain(EnumFacing enumFacing) {
        return !this.isSolidified();
    }

    public void setAndUpdateFluidTank(int i) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return super.func_189515_b(nbt);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerSided((IFluidHandlerSidedCallback)this, (IFluidHandler)this.tank, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getFieldCount() {
        return 1;
    }

    public void setField(int index, int value) {
        this.temp = value;
    }

    public int getField(int index) {
        return (int)this.temp;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }
}

