/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.tileentities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.Constants;
import net.dries007.tfc.objects.te.TEBase;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.TFCTech;
import tfctech.network.PacketLatexUpdate;
import tfctech.objects.fluids.TechFluids;
import tfctech.objects.items.TechItems;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TELatexExtractor
extends TEBase
implements ITickable {
    public static final int MAX_FLUID = 1000;
    private int flowTicks = -1;
    private int serverUpdate = 0;
    private int fluid = 0;
    private boolean pot = false;
    private boolean base = false;

    public void func_145839_a(NBTTagCompound nbt) {
        this.flowTicks = nbt.func_74762_e("flowTicks");
        this.fluid = nbt.func_74762_e("fluid");
        this.pot = nbt.func_74767_n("pot");
        this.base = nbt.func_74767_n("base");
        super.func_145839_a(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("flowTicks", this.flowTicks);
        nbt.func_74768_a("fluid", this.fluid);
        nbt.func_74757_a("pot", this.pot);
        nbt.func_74757_a("base", this.base);
        return super.func_189515_b(nbt);
    }

    public boolean hasFluid() {
        return this.fluid > 0 && this.hasPot();
    }

    public boolean hasPot() {
        return this.pot;
    }

    public boolean hasBase() {
        return this.base;
    }

    public int getFluidAmount() {
        return !this.hasFluid() ? 0 : Math.min(1000, this.fluid);
    }

    public int cutState() {
        if (this.flowTicks < 0) {
            return 0;
        }
        if (this.flowTicks > 0 && this.hasPot()) {
            return 2;
        }
        return 1;
    }

    @Nullable
    public IBlockState getBlockState() {
        if (!this.func_145830_o()) {
            return null;
        }
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public boolean makeCut() {
        if (this.flowTicks < 1 && this.hasPot() && this.hasBase()) {
            this.flowTicks = 12000 + Constants.RNG.nextInt(48000);
            return true;
        }
        return false;
    }

    public void onBreakBlock() {
        ItemStack base;
        ItemStack pot;
        if (this.hasPot() && (pot = this.removePot()) != ItemStack.field_190927_a) {
            Helpers.spawnItemStack((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)pot);
        }
        if (this.hasBase() && (base = this.removeBase()) != ItemStack.field_190927_a) {
            Helpers.spawnItemStack((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)base);
        }
        Helpers.spawnItemStack((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)new ItemStack((Item)TechItems.IRON_GROOVE));
    }

    public boolean isValidPot(ItemStack pot) {
        return pot.func_77973_b() == TechItems.FLUID_BOWL;
    }

    public boolean isValidBase(ItemStack base) {
        return base.func_77973_b() == TechItems.IRON_BOWL_MOUNT;
    }

    public boolean addPot(ItemStack stack) {
        if (!this.hasPot() && this.hasBase() && this.isValidPot(stack)) {
            FluidStack fluidStack;
            IFluidHandler cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (cap != null && (fluidStack = cap.drain(1000, false)) != null) {
                if (fluidStack.getFluid() != TechFluids.LATEX.get()) {
                    return false;
                }
                this.fluid = Math.min(fluidStack.amount, 1000);
            }
            this.pot = true;
            return true;
        }
        return false;
    }

    public boolean addBase(ItemStack stack) {
        if (!this.hasBase() && this.isValidBase(stack)) {
            this.base = true;
            return true;
        }
        return false;
    }

    public ItemStack removePot() {
        ItemStack stack = new ItemStack((Item)TechItems.FLUID_BOWL);
        IFluidHandler cap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (cap != null && this.hasFluid()) {
            cap.fill(new FluidStack(TechFluids.LATEX.get(), this.fluid), true);
        }
        if (this.flowTicks > -1) {
            this.flowTicks = 0;
            this.fluid = 0;
        }
        this.pot = false;
        return stack;
    }

    public ItemStack removeBase() {
        if (!this.hasPot()) {
            this.base = false;
            return new ItemStack((Item)TechItems.IRON_BOWL_MOUNT);
        }
        return ItemStack.field_190927_a;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.flowTicks > 0 && --this.flowTicks % 40 == 0) {
                ++this.fluid;
                if (this.fluid >= 1000) {
                    this.fluid = 1000;
                    this.flowTicks = 0;
                }
            }
            if (++this.serverUpdate % 40 == 0) {
                this.serverUpdate = 0;
                TFCTech.getNetwork().sendToAllTracking((IMessage)new PacketLatexUpdate(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClient(int cutState, int fluid, boolean pot, boolean base) {
        this.flowTicks = cutState - 1;
        this.fluid = fluid;
        this.pot = pot;
        this.base = base;
    }
}

