/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.tileentities;

import gregtech.api.capability.GregtechCapabilities;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.objects.te.TECrucible;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.TFCTech;
import tfctech.TechConfig;
import tfctech.client.TechSounds;
import tfctech.client.audio.IMachineSoundEffect;
import tfctech.objects.blocks.devices.BlockElectricForge;
import tfctech.objects.blocks.devices.BlockInductionCrucible;
import tfctech.objects.storage.MachineEnergyContainer;

@ParametersAreNonnullByDefault
@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")
public class TEInductionCrucible
extends TECrucible
implements IMachineSoundEffect,
IEnergySink {
    private final MachineEnergyContainer energyContainer;
    private int litTime = 0;
    private boolean addedToIc2Network = false;
    private boolean soundPlay = false;

    public TEInductionCrucible() {
        this.energyContainer = new MachineEnergyContainer(TechConfig.DEVICES.inductionCrucibleEnergyCapacity, TechConfig.DEVICES.inductionCrucibleEnergyCapacity, 0);
    }

    @Optional.Method(modid="ic2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.addedToIc2Network) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToIc2Network = false;
        }
    }

    @Optional.Method(modid="ic2")
    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && TechConfig.DEVICES.acceptIc2EU && !this.addedToIc2Network) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToIc2Network = true;
        }
    }

    public double getDemandedEnergy() {
        return Math.ceil((double)this.energyContainer.receiveEnergy(Integer.MAX_VALUE, true) / (double)TechConfig.DEVICES.ratioIc2);
    }

    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    public double injectEnergy(EnumFacing facing, double amount, double voltage) {
        this.energyContainer.receiveEnergy((int)Math.ceil(amount) * TechConfig.DEVICES.ratioIc2, false);
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing facing) {
        return TechConfig.DEVICES.acceptIc2EU && facing == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
    }

    public int getEnergyCapacity() {
        return this.energyContainer.getMaxEnergyStored();
    }

    public void func_73660_a() {
        boolean acceptHeat;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            IMachineSoundEffect.super.update();
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        boolean isLit = (Boolean)state.func_177229_b((IProperty)BlockInductionCrucible.LIT);
        int energyUsage = TechConfig.DEVICES.inductionCrucibleEnergyConsumption;
        boolean bl = acceptHeat = this.getAlloy().removeAlloy(1, true) > 0;
        if (!acceptHeat) {
            for (int i = 0; i <= 8; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                if (cap == null) continue;
                acceptHeat = true;
                break;
            }
        }
        if (acceptHeat && this.energyContainer.consumeEnergy(energyUsage, false)) {
            this.acceptHeat(Heat.maxVisibleTemperature());
            this.litTime = 15;
            if (!isLit) {
                state = state.func_177226_a((IProperty)BlockElectricForge.LIT, (Comparable)Boolean.valueOf(true));
                this.field_145850_b.func_180501_a(this.field_174879_c, state, 2);
                isLit = true;
            }
        }
        if (this.litTime > 0 && --this.litTime <= 0 && isLit) {
            state = state.func_177226_a((IProperty)BlockElectricForge.LIT, (Comparable)Boolean.valueOf(false));
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 2);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.energyContainer.deserializeNBT(nbt.func_74775_l("energyContainer"));
        super.func_145839_a(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("energyContainer", (NBTBase)this.energyContainer.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing == null || facing == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            if (capability == CapabilityEnergy.ENERGY) {
                return true;
            }
            if (TechConfig.DEVICES.acceptGTCEEU && Loader.isModLoaded((String)"gregtech") && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing == null || facing == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this.energyContainer);
            }
            if (TechConfig.DEVICES.acceptGTCEEU && Loader.isModLoaded((String)"gregtech") && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
                return (T)this.energyContainer.getGTCEHandler();
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getFieldCount() {
        return 2;
    }

    public void setField(int index, int value) {
        if (index == 0) {
            super.setField(0, value);
        } else if (index == 1) {
            this.energyContainer.setEnergy(value);
        } else {
            TFCTech.getLog().warn("Invalid field ID {} in TEElectricForge#setField", (Object)index);
        }
    }

    public int getField(int index) {
        if (index == 0) {
            return super.getField(0);
        }
        if (index == 1) {
            return this.energyContainer.getEnergyStored();
        }
        TFCTech.getLog().warn("Invalid field ID {} in TEElectricForge#setField", (Object)index);
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SoundEvent getSoundEvent() {
        return TechSounds.INDUCTION_WORK;
    }

    @Override
    public boolean shouldPlay() {
        if (!this.func_145837_r()) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() instanceof BlockInductionCrucible && (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockElectricForge.LIT) != false;
    }

    @Override
    public boolean isPlaying() {
        return this.soundPlay;
    }

    @Override
    public void setPlaying(boolean value) {
        this.soundPlay = value;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getSoundPos() {
        return this.func_174877_v();
    }

    public int getEnergyStored() {
        return this.energyContainer.getEnergyStored();
    }
}

