/*
 * Decompiled with CFR 0.152.
 */
package tfctech.objects.tileentities;

import gregtech.api.capability.GregtechCapabilities;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.objects.te.TEInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tfctech.TFCTech;
import tfctech.TechConfig;
import tfctech.client.TechSounds;
import tfctech.network.PacketFridgeUpdate;
import tfctech.network.PacketTileEntityUpdate;
import tfctech.objects.blocks.devices.BlockFridge;
import tfctech.objects.storage.MachineEnergyContainer;
import tfctech.registry.TechFoodTraits;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")
public class TEFridge
extends TEInventory
implements ITickable,
IEnergySink {
    private static final float MAX_DEGREE = 90.0f;
    private static final float DOOR_SPEED = 6.0f;
    private final MachineEnergyContainer energyContainer;
    private float open = 0.0f;
    private float lastOpen = 0.0f;
    private int openingState = 0;
    private float efficiency = 0.0f;
    private int applyTrait = 0;
    private int serverUpdate;
    private boolean addedToIc2Network = false;
    private int mainBlock = 0;

    public TEFridge() {
        super(8);
        this.energyContainer = new MachineEnergyContainer(TechConfig.DEVICES.fridgeEnergyCapacity, TechConfig.DEVICES.fridgeEnergyCapacity, 0);
    }

    public float getEfficiency() {
        return this.efficiency;
    }

    public void updateClient(float efficiency) {
        this.efficiency = efficiency;
    }

    public int getEnergyCapacity() {
        return this.energyContainer.getMaxEnergyStored();
    }

    public int getEnergyStored() {
        return this.energyContainer.getEnergyStored();
    }

    public boolean isMainBlock() {
        if (this.mainBlock == 0) {
            if (!this.func_145830_o() || this.field_145850_b.func_175623_d(this.field_174879_c)) {
                return false;
            }
            this.mainBlock = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFridge.UPPER) != false ? 1 : -1;
        }
        return this.mainBlock == 1;
    }

    public ItemStack insertItem(int slot, ItemStack stack) {
        ItemStack output = this.inventory.insertItem(slot, stack, false);
        this.setAndUpdateSlots(slot);
        return output;
    }

    public ItemStack extractItem(int slot) {
        ItemStack stack = this.inventory.extractItem(slot, 64, false);
        IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
        if (cap != null) {
            CapabilityFood.removeTrait((IFood)cap, (FoodTrait)TechFoodTraits.FROZEN);
            CapabilityFood.removeTrait((IFood)cap, (FoodTrait)TechFoodTraits.COLD);
        }
        this.setAndUpdateSlots(slot);
        return stack;
    }

    public void setAndUpdateSlots(int slot) {
        TFCTech.getNetwork().sendToAllTracking((IMessage)new PacketTileEntityUpdate((TileEntity)this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
        super.setAndUpdateSlots(slot);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.lastOpen = this.open = nbt.func_74760_g("open");
        this.openingState = nbt.func_74762_e("openingState");
        this.efficiency = nbt.func_74760_g("efficiency");
        this.energyContainer.deserializeNBT(nbt.func_74775_l("energyContainer"));
        super.func_145839_a(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74776_a("open", this.open);
        nbt.func_74768_a("openingState", this.openingState);
        nbt.func_74776_a("efficiency", this.efficiency);
        nbt.func_74782_a("energyContainer", (NBTBase)this.energyContainer.serializeNBT());
        return super.func_189515_b(nbt);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (!this.isMainBlock()) {
            TEFridge te = (TEFridge)Helpers.getTE((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), TEFridge.class);
            if (te != null) {
                return te.hasCapability(capability, facing);
            }
            return false;
        }
        if (facing == null || facing == this.getRotation().func_176734_d()) {
            if (capability == CapabilityEnergy.ENERGY) {
                return true;
            }
            if (TechConfig.DEVICES.acceptGTCEEU && Loader.isModLoaded((String)"gregtech") && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (!this.isMainBlock()) {
            TEFridge te = (TEFridge)Helpers.getTE((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), TEFridge.class);
            if (te != null) {
                return te.getCapability(capability, facing);
            }
            return null;
        }
        if (facing == null || facing == this.getRotation().func_176734_d()) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this.energyContainer);
            }
            if (TechConfig.DEVICES.acceptGTCEEU && Loader.isModLoaded((String)"gregtech") && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
                return (T)this.energyContainer.getGTCEHandler();
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void onBreakBlock(World world, BlockPos pos, IBlockState state) {
        if (Loader.isModLoaded((String)"ic2")) {
            this.ic2Unload();
            if (this.isMainBlock()) {
                TEFridge child = (TEFridge)Helpers.getTE((IBlockAccess)world, (BlockPos)pos.func_177977_b(), TEFridge.class);
                if (child != null) {
                    child.ic2Unload();
                }
            } else {
                TEFridge main = (TEFridge)Helpers.getTE((IBlockAccess)world, (BlockPos)pos.func_177984_a(), TEFridge.class);
                if (main != null) {
                    main.ic2Unload();
                }
            }
        }
        super.onBreakBlock(world, pos, state);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (Loader.isModLoaded((String)"ic2")) {
            this.ic2Unload();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double getDemandedEnergy() {
        if (!this.isMainBlock()) {
            TEFridge te = (TEFridge)Helpers.getTE((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), TEFridge.class);
            if (te != null && te.addedToIc2Network) {
                return Math.ceil((double)te.energyContainer.receiveEnergy(Integer.MAX_VALUE, true) / (double)TechConfig.DEVICES.ratioIc2);
            }
            return 0.0;
        }
        return Math.ceil((double)this.energyContainer.receiveEnergy(Integer.MAX_VALUE, true) / (double)TechConfig.DEVICES.ratioIc2);
    }

    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    public double injectEnergy(EnumFacing facing, double amount, double voltage) {
        if (!this.isMainBlock()) {
            TEFridge te = (TEFridge)Helpers.getTE((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), TEFridge.class);
            if (te != null && te.addedToIc2Network) {
                te.energyContainer.receiveEnergy((int)Math.ceil(amount) * TechConfig.DEVICES.ratioIc2, false);
            }
            return 0.0;
        }
        this.energyContainer.receiveEnergy((int)Math.ceil(amount) * TechConfig.DEVICES.ratioIc2, false);
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public void ic2Unload() {
        if (!this.field_145850_b.field_72995_K && this.addedToIc2Network) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToIc2Network = false;
        }
    }

    @Optional.Method(modid="ic2")
    public void ic2Load() {
        if (!this.field_145850_b.field_72995_K && TechConfig.DEVICES.acceptIc2EU && !this.addedToIc2Network) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToIc2Network = true;
        }
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing facing) {
        TEFridge te;
        if (!(this.isMainBlock() || (te = (TEFridge)Helpers.getTE((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), TEFridge.class)) != null && te.addedToIc2Network)) {
            return false;
        }
        return TechConfig.DEVICES.acceptIc2EU && facing == this.getRotation().func_176734_d();
    }

    public ItemStack getSlot(int slot) {
        return this.inventory.extractItem(slot, 64, true);
    }

    public float getOpen() {
        return this.open;
    }

    public float getLastOpen() {
        return this.lastOpen;
    }

    public boolean isOpen() {
        return this.open >= 90.0f;
    }

    public boolean hasStack(int slot) {
        return this.inventory.extractItem(slot, 64, true) != ItemStack.field_190927_a;
    }

    public EnumFacing getRotation() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
    }

    public boolean isAnimating() {
        return this.openingState != 0;
    }

    @Nullable
    public Vec3d[] getItems() {
        if (!this.func_145830_o()) {
            return null;
        }
        return BlockFridge.getItems(this.getRotation());
    }

    public boolean setOpening(boolean value) {
        if (this.openingState != 0) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (value) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, TechSounds.FRIDGE_OPEN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.open = 0.0f;
                this.openingState = 1;
            } else {
                this.open = 90.0f;
                this.openingState = -1;
            }
            this.setAndUpdateSlots(0);
        }
        return true;
    }

    public void func_73660_a() {
        if (Loader.isModLoaded((String)"ic2")) {
            this.ic2Load();
        }
        if (!this.isMainBlock()) {
            return;
        }
        this.lastOpen = this.open;
        if (this.openingState == 1) {
            this.open += 6.0f;
            if (this.open >= 90.0f) {
                this.open = 90.0f;
                this.openingState = 0;
            }
        }
        if (this.openingState == -1) {
            this.open -= 6.0f;
            if (this.open <= 0.0f) {
                this.open = 0.0f;
                this.openingState = 0;
                this.field_145850_b.func_184133_a(null, this.field_174879_c, TechSounds.FRIDGE_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            int consumption = (int)Math.max(1.0, TechConfig.DEVICES.fridgeEnergyConsumption * 10.0);
            if (this.efficiency >= 75.0f) {
                consumption = (int)Math.max(1.0, (double)consumption / 4.0);
            }
            if (this.isOpen() || !this.energyContainer.consumeEnergy(consumption, false)) {
                this.efficiency = (float)((double)this.efficiency - 100.0 / (TechConfig.DEVICES.fridgeLoseEfficiency * 6000.0));
                if (this.efficiency <= 0.0f) {
                    this.efficiency = 0.0f;
                }
            } else {
                this.efficiency = (float)((double)this.efficiency + 100.0 / (TechConfig.DEVICES.fridgeEfficiency * 36000.0));
                if (this.efficiency >= 100.0f) {
                    this.efficiency = 100.0f;
                }
            }
            if (++this.applyTrait >= 100) {
                this.applyTrait = 0;
                if (this.efficiency >= 80.0f) {
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        IFood cap = (IFood)this.inventory.getStackInSlot(i).getCapability(CapabilityFood.CAPABILITY, null);
                        if (cap == null) continue;
                        CapabilityFood.removeTrait((IFood)cap, (FoodTrait)TechFoodTraits.COLD);
                        CapabilityFood.applyTrait((IFood)cap, (FoodTrait)TechFoodTraits.FROZEN);
                    }
                } else if (this.efficiency >= 30.0f) {
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        IFood cap = (IFood)this.inventory.getStackInSlot(i).getCapability(CapabilityFood.CAPABILITY, null);
                        if (cap == null) continue;
                        CapabilityFood.removeTrait((IFood)cap, (FoodTrait)TechFoodTraits.FROZEN);
                        CapabilityFood.applyTrait((IFood)cap, (FoodTrait)TechFoodTraits.COLD);
                    }
                } else {
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        IFood cap = (IFood)this.inventory.getStackInSlot(i).getCapability(CapabilityFood.CAPABILITY, null);
                        if (cap == null) continue;
                        CapabilityFood.removeTrait((IFood)cap, (FoodTrait)TechFoodTraits.FROZEN);
                        CapabilityFood.removeTrait((IFood)cap, (FoodTrait)TechFoodTraits.COLD);
                    }
                }
            }
            if (++this.serverUpdate % 40 == 0) {
                this.serverUpdate = 0;
                TFCTech.getNetwork().sendToAllTracking((IMessage)new PacketFridgeUpdate(this.field_174879_c, this.efficiency), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
            }
        }
    }
}

